/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.nio.charset.StandardCharsets;
import java.security.MessageDigest;
import java.security.Principal;
import java.util.Collections;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.token.SecurityTokenReference;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.UsernameTokenUtil;
import org.apache.wss4j.dom.common.EncodedPasswordCallbackHandler;
import org.apache.wss4j.dom.common.UsernamePasswordCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecDKEncrypt;
import org.apache.wss4j.dom.message.WSSecDKSign;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.apache.wss4j.dom.message.token.UsernameToken;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class UTDerivedKeyTest {
    private static final Logger LOG = LoggerFactory.getLogger(UTDerivedKeyTest.class);
    private CallbackHandler callbackHandler = new UsernamePasswordCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance();

    @Test
    public void testUsernameTokenUnit() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        UsernameToken usernameToken = new UsernameToken(true, doc, null);
        usernameToken.setName("bob");
        byte[] salt = UsernameTokenUtil.generateSalt((boolean)false);
        usernameToken.addSalt(doc, salt, false);
        Assertions.assertTrue((salt.length == 16 ? 1 : 0) != 0);
        Assertions.assertTrue((salt[0] == 2 ? 1 : 0) != 0);
        byte[] utSalt = usernameToken.getSalt();
        Assertions.assertTrue((salt.length == utSalt.length ? 1 : 0) != 0);
        for (int i = 0; i < salt.length; ++i) {
            Assertions.assertTrue((salt[i] == utSalt[i] ? 1 : 0) != 0);
        }
        usernameToken.addIteration(doc, 500);
        Assertions.assertTrue((usernameToken.getIteration() == 500 ? 1 : 0) != 0);
        WSSecurityUtil.prependChildElement((Element)secHeader.getSecurityHeaderElement(), (Element)usernameToken.getElement());
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)outputString.contains("wsse:Username"));
        Assertions.assertFalse((boolean)outputString.contains("wsse:Password"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        byte[] derivedKey = UsernameTokenUtil.generateDerivedKey((String)"security", (byte[])salt, (int)500);
        Assertions.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        derivedKey = UsernameTokenUtil.generateDerivedKey((byte[])XMLUtils.decode((String)"c2VjdXJpdHk="), (byte[])salt, (int)500);
        Assertions.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
    }

    @Test
    public void testDerivedKeyWithEncodedPasswordBaseline() throws Exception {
        String password = "password";
        byte[] passwordHash = MessageDigest.getInstance("SHA-1").digest(password.getBytes(StandardCharsets.UTF_8));
        byte[] salt = XMLUtils.decode((String)"LKpycbfgRzwDnBz6kkhAAQ==");
        int iteration = 1049;
        byte[] expectedDerivedKey = XMLUtils.decode((String)"C7Ll/OY4TECb6hZuMMiX/5hzszo=");
        byte[] derivedKey = UsernameTokenUtil.generateDerivedKey((byte[])passwordHash, (byte[])salt, (int)iteration);
        Assertions.assertArrayEquals((byte[])expectedDerivedKey, (byte[])derivedKey, (String)"the derived key is not as expected");
    }

    @Test
    public void testDerivedKeyEncryption() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken builder = new WSSecUsernameToken(secHeader);
        builder.setUserInfo("bob", "security");
        builder.addDerivedKey(false, 1000);
        byte[] salt = UsernameTokenUtil.generateSalt((boolean)false);
        builder.prepare(salt);
        byte[] derivedKey = builder.getDerivedKey(salt);
        Assertions.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setTokenIdentifier(tokenIdentifier);
        encrBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document encryptedDoc = encrBuilder.build(derivedKey);
        builder.prependToHeader();
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        Assertions.assertTrue((boolean)outputString.contains("wsse:Username"));
        Assertions.assertFalse((boolean)outputString.contains("wsse:Password"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        Assertions.assertFalse((boolean)outputString.contains("testMethod"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(encryptedDoc);
        try {
            this.verify(encryptedDoc, false);
            Assertions.fail((String)"Failure expected on deriving keys from a UsernameToken not allowed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_AUTHENTICATION ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDerivedKeyEncryptionWithEncodedPassword() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken builder = new WSSecUsernameToken(secHeader);
        builder.setPasswordsAreEncoded(true);
        byte[] bytes = MessageDigest.getInstance("SHA-1").digest("security".getBytes(StandardCharsets.UTF_8));
        builder.setUserInfo("bob", XMLUtils.encodeToString((byte[])bytes));
        builder.addDerivedKey(false, 1000);
        byte[] salt = UsernameTokenUtil.generateSalt((boolean)false);
        builder.prepare(salt);
        byte[] derivedKey = builder.getDerivedKey(salt);
        Assertions.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setTokenIdentifier(tokenIdentifier);
        encrBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document encryptedDoc = encrBuilder.build(derivedKey);
        builder.prependToHeader();
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        Assertions.assertTrue((boolean)outputString.contains("wsse:Username"));
        Assertions.assertFalse((boolean)outputString.contains("wsse:Password"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        Assertions.assertFalse((boolean)outputString.contains("testMethod"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        RequestData requestData = new RequestData();
        requestData.setEncodePasswords(true);
        requestData.setAllowUsernameTokenNoPassword(true);
        requestData.setCallbackHandler((CallbackHandler)new EncodedPasswordCallbackHandler());
        WSSecurityEngine newEngine = new WSSecurityEngine();
        newEngine.processSecurityHeader(encryptedDoc, requestData);
    }

    @Test
    public void testDerivedKeyChangedEncryption() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken builder = new WSSecUsernameToken(secHeader);
        builder.setUserInfo("bob", "security");
        builder.addDerivedKey(false, 1000);
        byte[] salt = UsernameTokenUtil.generateSalt((boolean)false);
        builder.prepare(salt);
        byte[] derivedKey = builder.getDerivedKey(salt);
        derivedKey[5] = 122;
        derivedKey[6] = 97;
        Assertions.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setTokenIdentifier(tokenIdentifier);
        encrBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document encryptedDoc = encrBuilder.build(derivedKey);
        builder.prependToHeader();
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        Assertions.assertTrue((boolean)outputString.contains("wsse:Username"));
        Assertions.assertFalse((boolean)outputString.contains("wsse:Password"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        Assertions.assertFalse((boolean)outputString.contains("testMethod"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(encryptedDoc);
            Assertions.fail((String)"Failure expected on a bad derived encryption");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDerivedKeyBadUserEncryption() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken builder = new WSSecUsernameToken(secHeader);
        builder.setUserInfo("colm", "security");
        builder.addDerivedKey(false, 1000);
        byte[] salt = UsernameTokenUtil.generateSalt((boolean)false);
        builder.prepare(salt);
        byte[] derivedKey = builder.getDerivedKey(salt);
        Assertions.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setTokenIdentifier(tokenIdentifier);
        encrBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document encryptedDoc = encrBuilder.build(derivedKey);
        builder.prependToHeader();
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        Assertions.assertTrue((boolean)outputString.contains("wsse:Username"));
        Assertions.assertFalse((boolean)outputString.contains("wsse:Password"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        Assertions.assertFalse((boolean)outputString.contains("testMethod"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(encryptedDoc);
            Assertions.fail((String)"Failure expected on a bad derived encryption");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_AUTHENTICATION ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDerivedKeySignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken builder = new WSSecUsernameToken(secHeader);
        builder.setUserInfo("bob", "security");
        builder.addDerivedKey(true, 1000);
        byte[] salt = UsernameTokenUtil.generateSalt((boolean)true);
        builder.prepare(salt);
        byte[] derivedKey = builder.getDerivedKey(salt);
        Assertions.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKSign sigBuilder = new WSSecDKSign(secHeader);
        sigBuilder.setTokenIdentifier(tokenIdentifier);
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sigBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document signedDoc = sigBuilder.build(derivedKey);
        builder.prependToHeader();
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)signedDoc);
        Assertions.assertTrue((boolean)outputString.contains("wsse:Username"));
        Assertions.assertFalse((boolean)outputString.contains("wsse:Password"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(signedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        Assertions.assertTrue((boolean)principal.getName().contains("DK"));
    }

    @Test
    public void testDerivedKeySignatureWithEncodedPassword() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken builder = new WSSecUsernameToken(secHeader);
        builder.setPasswordsAreEncoded(true);
        byte[] bytes = MessageDigest.getInstance("SHA-1").digest("security".getBytes(StandardCharsets.UTF_8));
        builder.setUserInfo("bob", XMLUtils.encodeToString((byte[])bytes));
        builder.addDerivedKey(true, 1000);
        byte[] salt = UsernameTokenUtil.generateSalt((boolean)true);
        builder.prepare(salt);
        byte[] derivedKey = builder.getDerivedKey(salt);
        Assertions.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKSign sigBuilder = new WSSecDKSign(secHeader);
        sigBuilder.setTokenIdentifier(tokenIdentifier);
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sigBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document signedDoc = sigBuilder.build(derivedKey);
        builder.prependToHeader();
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)signedDoc);
        Assertions.assertTrue((boolean)outputString.contains("wsse:Username"));
        Assertions.assertFalse((boolean)outputString.contains("wsse:Password"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        RequestData requestData = new RequestData();
        requestData.setEncodePasswords(true);
        requestData.setAllowUsernameTokenNoPassword(true);
        requestData.setCallbackHandler((CallbackHandler)new EncodedPasswordCallbackHandler());
        WSSecurityEngine newEngine = new WSSecurityEngine();
        WSHandlerResult results = newEngine.processSecurityHeader(signedDoc, requestData);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        Assertions.assertTrue((boolean)principal.getName().contains("DK"));
    }

    @Test
    public void testDerivedKeyChangedSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken builder = new WSSecUsernameToken(secHeader);
        builder.setUserInfo("bob", "security");
        builder.addDerivedKey(true, 1000);
        byte[] salt = UsernameTokenUtil.generateSalt((boolean)true);
        builder.prepare(salt);
        byte[] derivedKey = builder.getDerivedKey(salt);
        derivedKey[5] = derivedKey[5] != 12 ? 12 : 13;
        Assertions.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKSign sigBuilder = new WSSecDKSign(secHeader);
        sigBuilder.setTokenIdentifier(tokenIdentifier);
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sigBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document signedDoc = sigBuilder.build(derivedKey);
        builder.prependToHeader();
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc);
            Assertions.fail((String)"Failure expected on a bad derived signature");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDerivedKeyBadUserSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken builder = new WSSecUsernameToken(secHeader);
        builder.setUserInfo("colm", "security");
        builder.addDerivedKey(true, 1000);
        byte[] salt = UsernameTokenUtil.generateSalt((boolean)true);
        builder.prepare(salt);
        byte[] derivedKey = builder.getDerivedKey(salt);
        Assertions.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKSign sigBuilder = new WSSecDKSign(secHeader);
        sigBuilder.setTokenIdentifier(tokenIdentifier);
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sigBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document signedDoc = sigBuilder.build(derivedKey);
        builder.prependToHeader();
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc);
            Assertions.fail((String)"Failure expected on a bad derived signature");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_AUTHENTICATION ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNoSaltEncryption() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        UsernameToken usernameToken = new UsernameToken(true, doc, null);
        usernameToken.setName("bob");
        WSSConfig config = WSSConfig.getNewInstance();
        usernameToken.setID(config.getIdAllocator().createId("UsernameToken-", (Object)usernameToken));
        byte[] salt = UsernameTokenUtil.generateSalt((boolean)false);
        usernameToken.addIteration(doc, 1000);
        byte[] derivedKey = UsernameTokenUtil.generateDerivedKey((String)"security", (byte[])salt, (int)1000);
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setTokenIdentifier(usernameToken.getID());
        encrBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document encryptedDoc = encrBuilder.build(derivedKey);
        WSSecurityUtil.prependChildElement((Element)secHeader.getSecurityHeaderElement(), (Element)usernameToken.getElement());
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)outputString.contains("wsse:Username"));
        Assertions.assertFalse((boolean)outputString.contains("wsse:Password"));
        Assertions.assertFalse((boolean)outputString.contains("wsse11:Salt"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(encryptedDoc);
            Assertions.fail((String)"Failure expected on no salt element");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNoIterationEncryption() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        UsernameToken usernameToken = new UsernameToken(true, doc, null);
        usernameToken.setName("bob");
        WSSConfig config = WSSConfig.getNewInstance();
        usernameToken.setID(config.getIdAllocator().createId("UsernameToken-", (Object)usernameToken));
        byte[] salt = UsernameTokenUtil.generateSalt((boolean)false);
        usernameToken.addSalt(doc, salt, false);
        byte[] derivedKey = UsernameTokenUtil.generateDerivedKey((String)"security", (byte[])salt, (int)1000);
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setTokenIdentifier(usernameToken.getID());
        encrBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document encryptedDoc = encrBuilder.build(derivedKey);
        WSSecurityUtil.prependChildElement((Element)secHeader.getSecurityHeaderElement(), (Element)usernameToken.getElement());
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)outputString.contains("wsse:Username"));
        Assertions.assertFalse((boolean)outputString.contains("wsse:Password"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        Assertions.assertFalse((boolean)outputString.contains("wsse11:Iteration"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(encryptedDoc);
            Assertions.fail((String)"Failure expected on no iteration element");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY_TOKEN ? 1 : 0) != 0);
        }
    }

    @Test
    public void testLowIterationEncryption() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        UsernameToken usernameToken = new UsernameToken(true, doc, null);
        usernameToken.setName("bob");
        WSSConfig config = WSSConfig.getNewInstance();
        usernameToken.setID(config.getIdAllocator().createId("UsernameToken-", (Object)usernameToken));
        usernameToken.addIteration(doc, 500);
        byte[] salt = UsernameTokenUtil.generateSalt((boolean)false);
        usernameToken.addSalt(doc, salt, false);
        byte[] derivedKey = UsernameTokenUtil.generateDerivedKey((String)"security", (byte[])salt, (int)500);
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setTokenIdentifier(usernameToken.getID());
        encrBuilder.setCustomValueType("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken");
        Document encryptedDoc = encrBuilder.build(derivedKey);
        WSSecurityUtil.prependChildElement((Element)secHeader.getSecurityHeaderElement(), (Element)usernameToken.getElement());
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)outputString.contains("wsse:Username"));
        Assertions.assertFalse((boolean)outputString.contains("wsse:Password"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(encryptedDoc);
            Assertions.fail((String)"Failure expected on a low iteration value");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        RequestData data = new RequestData();
        data.setCallbackHandler(this.callbackHandler);
        data.setDecCrypto(this.crypto);
        data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R4218));
        data.setAllowUsernameTokenNoPassword(true);
        WSSecurityEngine engine = new WSSecurityEngine();
        engine.setWssConfig(config);
        engine.processSecurityHeader(doc, data);
    }

    @Test
    public void testBadValueType() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken builder = new WSSecUsernameToken(secHeader);
        builder.setUserInfo("bob", "security");
        builder.addDerivedKey(false, 1000);
        byte[] salt = UsernameTokenUtil.generateSalt((boolean)false);
        builder.prepare(salt);
        byte[] derivedKey = builder.getDerivedKey(salt);
        Assertions.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setTokenIdentifier(tokenIdentifier);
        encrBuilder.setCustomValueType("http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.1#SAMLV1.1");
        Document encryptedDoc = encrBuilder.build(derivedKey);
        builder.prependToHeader();
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        Assertions.assertTrue((boolean)outputString.contains("wsse:Username"));
        Assertions.assertFalse((boolean)outputString.contains("wsse:Password"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        Assertions.assertFalse((boolean)outputString.contains("testMethod"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(encryptedDoc);
            Assertions.fail((String)"Failure expected on a bad value type");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        RequestData data = new RequestData();
        data.setCallbackHandler(this.callbackHandler);
        data.setDecCrypto(this.crypto);
        data.setAllowUsernameTokenNoPassword(true);
        WSSConfig config = WSSConfig.getNewInstance();
        WSSecurityEngine newEngine = new WSSecurityEngine();
        newEngine.setWssConfig(config);
        data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R4214));
        newEngine.processSecurityHeader(encryptedDoc, data);
    }

    @Test
    public void testKeyIdentifier() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken builder = new WSSecUsernameToken(secHeader);
        builder.setUserInfo("bob", "security");
        builder.addDerivedKey(false, 1000);
        byte[] salt = UsernameTokenUtil.generateSalt((boolean)false);
        builder.prepare(salt);
        byte[] derivedKey = builder.getDerivedKey(salt);
        Assertions.assertTrue((derivedKey.length == 20 ? 1 : 0) != 0);
        String tokenIdentifier = builder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecurityTokenReference strEncKey = new SecurityTokenReference(doc);
        strEncKey.setKeyIdentifier("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-username-token-profile-1.0#UsernameToken", tokenIdentifier, true);
        encrBuilder.setStrElem(strEncKey.getElement());
        Document encryptedDoc = encrBuilder.build(derivedKey);
        builder.prependToHeader();
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        Assertions.assertTrue((boolean)outputString.contains("wsse:Username"));
        Assertions.assertFalse((boolean)outputString.contains("wsse:Password"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Salt"));
        Assertions.assertTrue((boolean)outputString.contains("wsse11:Iteration"));
        Assertions.assertFalse((boolean)outputString.contains("testMethod"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        try {
            this.verify(encryptedDoc);
            Assertions.fail((String)"Failure expected on a key identifier");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        WSSecurityEngine newEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setCallbackHandler(this.callbackHandler);
        data.setDecCrypto(this.crypto);
        data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R4215));
        data.setAllowUsernameTokenNoPassword(true);
        WSSConfig config = WSSConfig.getNewInstance();
        newEngine.setWssConfig(config);
        newEngine.processSecurityHeader(encryptedDoc, data);
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        return this.verify(doc, true);
    }

    private WSHandlerResult verify(Document doc, boolean allowUsernameTokenDerivedKeys) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData requestData = new RequestData();
        requestData.setAllowUsernameTokenNoPassword(allowUsernameTokenDerivedKeys);
        requestData.setCallbackHandler(this.callbackHandler);
        requestData.setDecCrypto(this.crypto);
        requestData.setSigVerCrypto(this.crypto);
        return secEngine.processSecurityHeader(doc, requestData);
    }
}

