/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.time.Instant;
import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.apache.wss4j.common.bsp.BSPEnforcer;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.DateUtil;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.WSTimeSource;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecTimestamp;
import org.apache.wss4j.dom.message.token.Timestamp;
import org.apache.wss4j.dom.validate.NoOpValidator;
import org.apache.wss4j.dom.validate.Validator;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class TimestampTest {
    private static final Logger LOG = LoggerFactory.getLogger(TimestampTest.class);

    @Test
    public void testValidTimestamp() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecTimestamp timestamp = new WSSecTimestamp(secHeader);
        timestamp.setTimeToLive(300);
        Document createdDoc = timestamp.build();
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)createdDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult wsResult = this.verify(createdDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)wsResult.getActionResults().get(32)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Timestamp receivedTimestamp = (Timestamp)actionResult.get((Object)"timestamp");
        Assertions.assertNotNull((Object)receivedTimestamp);
        Timestamp clone = new Timestamp(receivedTimestamp.getElement(), new BSPEnforcer(true));
        Assertions.assertTrue((boolean)clone.equals((Object)receivedTimestamp));
        Assertions.assertTrue((clone.hashCode() == receivedTimestamp.hashCode() ? 1 : 0) != 0);
    }

    @Test
    public void testValidTimestampNoExpires() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecTimestamp timestamp = new WSSecTimestamp(secHeader);
        timestamp.setTimeToLive(0);
        Document createdDoc = timestamp.build();
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)createdDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult wsResult = this.verify(createdDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)wsResult.getActionResults().get(32)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Timestamp receivedTimestamp = (Timestamp)actionResult.get((Object)"timestamp");
        Assertions.assertNotNull((Object)receivedTimestamp);
    }

    @Test
    public void testInvalidTimestampNoExpires() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecTimestamp timestamp = new WSSecTimestamp(secHeader);
        timestamp.setTimeToLive(0);
        Document createdDoc = timestamp.build();
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)createdDoc);
            LOG.debug(outputString);
        }
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData requestData = new RequestData();
        requestData.setWssConfig(WSSConfig.getNewInstance());
        requestData.setRequireTimestampExpires(true);
        try {
            secEngine.processSecurityHeader(doc, requestData);
            Assertions.fail((String)"Failure expected on no Expires Element");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.SECURITY_ERROR ? 1 : 0) != 0);
        }
        requestData.setWssConfig(WSSConfig.getNewInstance());
        requestData.setRequireTimestampExpires(false);
        WSHandlerResult wsResult = secEngine.processSecurityHeader(doc, requestData);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)wsResult.getActionResults().get(32)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Timestamp receivedTimestamp = (Timestamp)actionResult.get((Object)"timestamp");
        Assertions.assertNotNull((Object)receivedTimestamp);
    }

    @Test
    public void testExpiredTimestamp() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecTimestamp timestamp = new WSSecTimestamp(secHeader);
        timestamp.setTimeToLive(-1);
        Document createdDoc = timestamp.build();
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)createdDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(createdDoc);
            Assertions.fail((String)"Expected failure on an expired timestamp");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.MESSAGE_EXPIRED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testOldTimestamp() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecTimestamp timestamp = new WSSecTimestamp(secHeader);
        Document createdDoc = timestamp.build();
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)createdDoc);
            LOG.debug(outputString);
        }
        RequestData requestData = new RequestData();
        requestData.setWssConfig(WSSConfig.getNewInstance());
        requestData.setTimeStampTTL(-1);
        try {
            this.verify(createdDoc, requestData);
            Assertions.fail((String)"The timestamp validation should have failed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.MESSAGE_EXPIRED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testNearFutureCreated() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(30L);
        elementCreated.appendChild(doc.createTextNode(DateUtil.getDateTimeFormatter((boolean)true).format(now)));
        timestampElement.appendChild(elementCreated);
        secHeader.getSecurityHeaderElement().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        RequestData requestData = new RequestData();
        requestData.setWssConfig(WSSConfig.getNewInstance());
        requestData.setTimeStampFutureTTL(0);
        try {
            this.verify(doc, requestData);
            Assertions.fail((String)"The timestamp validation should have failed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.MESSAGE_EXPIRED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testFutureCreated() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(120L);
        elementCreated.appendChild(doc.createTextNode(DateUtil.getDateTimeFormatter((boolean)true).format(now)));
        timestampElement.appendChild(elementCreated);
        secHeader.getSecurityHeaderElement().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc);
            Assertions.fail((String)"The timestamp validation should have failed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.MESSAGE_EXPIRED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testExpiresBeforeCreated() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        elementCreated.appendChild(doc.createTextNode(DateUtil.getDateTimeFormatter((boolean)true).format(now)));
        timestampElement.appendChild(elementCreated);
        Element elementExpires = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
        now = now.minusSeconds(300L);
        elementExpires.appendChild(doc.createTextNode(DateUtil.getDateTimeFormatter((boolean)true).format(now)));
        timestampElement.appendChild(elementExpires);
        secHeader.getSecurityHeaderElement().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc);
            Assertions.fail((String)"The timestamp validation should have failed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.MESSAGE_EXPIRED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testMultipleTimestamps() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecTimestamp timestamp = new WSSecTimestamp(secHeader);
        timestamp.setTimeToLive(300);
        Document createdDoc = timestamp.build();
        timestamp = new WSSecTimestamp(secHeader);
        timestamp.setTimeToLive(60);
        createdDoc = timestamp.build();
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)createdDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(createdDoc);
            Assertions.fail((String)"Expected failure on multiple timestamps");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        this.verify(createdDoc, Collections.singletonList(BSPRule.R3227));
    }

    @Test
    public void testMultipleCreated() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        elementCreated.appendChild(doc.createTextNode(DateUtil.getDateTimeFormatter((boolean)true).format(now)));
        timestampElement.appendChild(elementCreated);
        timestampElement.appendChild(elementCreated.cloneNode(true));
        secHeader.getSecurityHeaderElement().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc);
            Assertions.fail((String)"The timestamp validation should have failed on multiple Created elements");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        this.verify(doc, Collections.singletonList(BSPRule.R3203));
    }

    @Test
    public void testNoCreated() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        Element elementExpires = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(300L);
        elementExpires.appendChild(doc.createTextNode(DateUtil.getDateTimeFormatter((boolean)true).format(now)));
        timestampElement.appendChild(elementExpires);
        secHeader.getSecurityHeaderElement().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc);
            Assertions.fail((String)"The timestamp validation should have failed on no Created element");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        ArrayList<BSPRule> rules = new ArrayList<BSPRule>();
        rules.add(BSPRule.R3203);
        rules.add(BSPRule.R3221);
        this.verify(doc, rules);
    }

    @Test
    public void testMultipleExpires() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        elementCreated.appendChild(doc.createTextNode(DateUtil.getDateTimeFormatter((boolean)true).format(now)));
        timestampElement.appendChild(elementCreated);
        Element elementExpires = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
        now = now.plusSeconds(300L);
        elementExpires.appendChild(doc.createTextNode(DateUtil.getDateTimeFormatter((boolean)true).format(now)));
        timestampElement.appendChild(elementExpires);
        timestampElement.appendChild(elementExpires.cloneNode(true));
        secHeader.getSecurityHeaderElement().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc);
            Assertions.fail((String)"The timestamp validation should have failed on multiple Expires elements");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        this.verify(doc, Collections.singletonList(BSPRule.R3224));
    }

    @Test
    public void testExpiresInFrontOfCreated() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(300L);
        elementCreated.appendChild(doc.createTextNode(DateUtil.getDateTimeFormatter((boolean)true).format(now)));
        timestampElement.appendChild(elementCreated);
        Element elementExpires = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        now = ZonedDateTime.now(ZoneOffset.UTC);
        elementExpires.appendChild(doc.createTextNode(DateUtil.getDateTimeFormatter((boolean)true).format(now)));
        timestampElement.appendChild(elementExpires);
        secHeader.getSecurityHeaderElement().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc);
            Assertions.fail((String)"The timestamp validation should have failed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        this.verify(doc, Collections.singletonList(BSPRule.R3221));
    }

    @Test
    public void testCreatedSeconds() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        elementCreated.appendChild(doc.createTextNode("2011-02-08T13:13:84.535Z"));
        timestampElement.appendChild(elementCreated);
        secHeader.getSecurityHeaderElement().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        wssConfig.setValidator(WSConstants.TIMESTAMP, (Validator)new NoOpValidator());
        try {
            this.verify(doc, wssConfig, new ArrayList<BSPRule>());
            Assertions.fail((String)"The timestamp validation should have failed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCreatedValueType() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        elementCreated.appendChild(doc.createTextNode(DateUtil.getDateTimeFormatter((boolean)true).format(now)));
        elementCreated.setAttributeNS(null, "ValueType", "http://docs.oasis-open.org/wss/oasis-wss-saml-token-profile-1.0#SAMLAssertionID");
        timestampElement.appendChild(elementCreated);
        secHeader.getSecurityHeaderElement().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc);
            Assertions.fail((String)"The timestamp validation should have failed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        WSSConfig wssConfig = WSSConfig.getNewInstance();
        wssConfig.setValidator(WSConstants.TIMESTAMP, (Validator)new NoOpValidator());
        this.verify(doc, wssConfig, Collections.singletonList(BSPRule.R3225));
    }

    @Test
    public void testCustomElement() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        Element timestampElement = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Timestamp");
        Element elementCreated = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Created");
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC);
        elementCreated.appendChild(doc.createTextNode(DateUtil.getDateTimeFormatter((boolean)true).format(now)));
        timestampElement.appendChild(elementCreated);
        Element elementExpires = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Expires");
        now = now.plusSeconds(300L);
        elementExpires.appendChild(doc.createTextNode(DateUtil.getDateTimeFormatter((boolean)true).format(now)));
        timestampElement.appendChild(elementExpires);
        Element elementCustom = doc.createElementNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Custom");
        timestampElement.appendChild(elementCustom);
        secHeader.getSecurityHeaderElement().appendChild(timestampElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc);
            Assertions.fail((String)"The timestamp validation should have failed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        this.verify(doc, Collections.singletonList(BSPRule.R3222));
    }

    @Test
    public void testSpoofedTimestamp() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecTimestamp timestamp = new WSSecTimestamp(secHeader);
        timestamp.setTimeToLive(300);
        WSTimeSource spoofedTimeSource = new WSTimeSource(){

            public Instant now() {
                return Instant.now().minusSeconds(500L);
            }
        };
        timestamp.setWsTimeSource(spoofedTimeSource);
        Document createdDoc = timestamp.build();
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)createdDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(createdDoc);
            Assertions.fail((String)"Expected failure on an expired timestamp");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.MESSAGE_EXPIRED ? 1 : 0) != 0);
        }
    }

    @Test
    public void testTimestampNoMilliseconds() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecTimestamp timestamp = new WSSecTimestamp(secHeader);
        timestamp.setPrecisionInMilliSeconds(false);
        timestamp.setTimeToLive(300);
        Document createdDoc = timestamp.build();
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)createdDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult wsResult = this.verify(createdDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)wsResult.getActionResults().get(32)).get(0);
        Assertions.assertNotNull((Object)actionResult);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThaiLocaleVerification() throws Exception {
        Locale defaultLocale = Locale.getDefault();
        try {
            Locale.setDefault(new Locale("th", "TH"));
            Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
            WSSecHeader secHeader = new WSSecHeader(doc);
            secHeader.insertSecurityHeader();
            WSSecTimestamp timestamp = new WSSecTimestamp(secHeader);
            timestamp.setTimeToLive(300);
            Document createdDoc = timestamp.build();
            WSHandlerResult wsResult = this.verify(createdDoc);
            WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)wsResult.getActionResults().get(32)).get(0);
            Assertions.assertNotNull((Object)actionResult);
        }
        finally {
            Locale.setDefault(defaultLocale);
        }
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData requestData = new RequestData();
        requestData.setWssConfig(WSSConfig.getNewInstance());
        return secEngine.processSecurityHeader(doc, requestData);
    }

    private WSHandlerResult verify(Document doc, RequestData requestData) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        return secEngine.processSecurityHeader(doc, requestData);
    }

    private WSHandlerResult verify(Document doc, List<BSPRule> ignoredRules) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData requestData = new RequestData();
        requestData.setIgnoredBSPRules(ignoredRules);
        return secEngine.processSecurityHeader(doc, requestData);
    }

    private WSHandlerResult verify(Document doc, WSSConfig wssConfig, List<BSPRule> ignoredRules) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData requestData = new RequestData();
        requestData.setWssConfig(wssConfig);
        requestData.setIgnoredBSPRules(ignoredRules);
        return secEngine.processSecurityHeader(doc, requestData);
    }
}

