/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.io.IOException;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import javax.xml.namespace.QName;
import javax.xml.transform.TransformerException;
import org.apache.wss4j.common.util.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class TestMessageTransformer {
    private static final Logger LOG = LoggerFactory.getLogger(TestMessageTransformer.class);

    public static Element duplicateEncryptedDataInWsseHeader(Element saaj, boolean moveReferenceList) throws TransformerException, IOException {
        if (moveReferenceList) {
            TestMessageTransformer.moveReferenceList(saaj);
        }
        Element body = TestMessageTransformer.getFirstChildElement(saaj, new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body"), true);
        Element encData = TestMessageTransformer.getFirstChildElement(body, new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData"), true);
        Element newEncData = TestMessageTransformer.createNewEncryptedData(encData);
        Element sh = TestMessageTransformer.getFirstChildElement(saaj, new QName("http://schemas.xmlsoap.org/soap/envelope/", "Header"), true);
        Element wsseHeader = TestMessageTransformer.getFirstChildElement(sh, new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"), true);
        Node newWsseHeader = wsseHeader.cloneNode(false);
        Node cur = wsseHeader.getFirstChild();
        String newId = newEncData.getAttributeNS(null, "Id");
        while (cur != null) {
            cur = TestMessageTransformer.copyHeadersAndUpdateRefList(cur, newWsseHeader, newId);
        }
        newWsseHeader.appendChild(newEncData);
        if (!moveReferenceList) {
            TestMessageTransformer.updateEncryptedKeyRefList(newWsseHeader, newId);
        }
        Node parent = wsseHeader.getParentNode();
        parent.removeChild(wsseHeader);
        parent.appendChild(newWsseHeader);
        TestMessageTransformer.print(saaj.getOwnerDocument());
        return newEncData;
    }

    public static Element duplicateEncryptedDataInWsseWrapperHeader(Element saaj, boolean moveReferenceList) throws TransformerException, IOException {
        if (moveReferenceList) {
            TestMessageTransformer.moveReferenceList(saaj);
        }
        Element body = TestMessageTransformer.getFirstChildElement(saaj, new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body"), true);
        Element encData = TestMessageTransformer.getFirstChildElement(body, new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData"), true);
        Element newEncData = TestMessageTransformer.createNewEncryptedData(encData);
        Element sh = TestMessageTransformer.getFirstChildElement(saaj, new QName("http://schemas.xmlsoap.org/soap/envelope/", "Header"), true);
        Element signature = TestMessageTransformer.getFirstChildElement(sh, new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"), true);
        Node wsseHeader = signature.getParentNode();
        Node newWsseHeader = wsseHeader.cloneNode(false);
        Node cur = wsseHeader.getFirstChild();
        String newId = newEncData.getAttributeNS(null, "Id");
        while (!cur.isSameNode(signature)) {
            cur = TestMessageTransformer.copyHeadersAndUpdateRefList(cur, newWsseHeader, newId);
        }
        Element wrapper = encData.getOwnerDocument().createElementNS(null, "a");
        wrapper.appendChild(newEncData);
        newWsseHeader.appendChild(wrapper);
        while (cur != null) {
            cur = TestMessageTransformer.copyHeadersAndUpdateRefList(cur, newWsseHeader, newId);
        }
        if (!moveReferenceList) {
            TestMessageTransformer.updateEncryptedKeyRefList(newWsseHeader, newId);
        }
        Node parent = wsseHeader.getParentNode();
        parent.removeChild(wsseHeader);
        parent.appendChild(newWsseHeader);
        TestMessageTransformer.print(saaj.getOwnerDocument());
        return newEncData;
    }

    public static Element duplicateEncryptedDataInWrapperBody(Element saaj) throws TransformerException, IOException {
        Element body = TestMessageTransformer.getFirstChildElement(saaj, new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body"), true);
        Element encData = TestMessageTransformer.getFirstChildElement(body, new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData"), true);
        Element newEncData = TestMessageTransformer.createNewEncryptedData(encData);
        Element sh = TestMessageTransformer.getFirstChildElement(saaj, new QName("http://schemas.xmlsoap.org/soap/envelope/", "Header"), true);
        Element signature = TestMessageTransformer.getFirstChildElement(sh, new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"), true);
        Node wsseHeader = signature.getParentNode();
        Node newWsseHeader = wsseHeader.cloneNode(false);
        Node cur = wsseHeader.getFirstChild();
        String newId = newEncData.getAttributeNS(null, "Id");
        while (!cur.isSameNode(signature)) {
            cur = TestMessageTransformer.copyHeadersAndUpdateRefList(cur, newWsseHeader, newId);
        }
        Element wrapper = encData.getOwnerDocument().createElementNS(null, "a");
        wrapper.appendChild(newEncData);
        body.appendChild(wrapper);
        while (cur != null) {
            cur = TestMessageTransformer.copyHeadersAndUpdateRefList(cur, newWsseHeader, newId);
        }
        TestMessageTransformer.updateEncryptedKeyRefList(newWsseHeader, newId);
        Node parent = wsseHeader.getParentNode();
        parent.removeChild(wsseHeader);
        parent.appendChild(newWsseHeader);
        TestMessageTransformer.print(saaj.getOwnerDocument());
        return newEncData;
    }

    public static Element duplicateEncryptedDataAfterWrapperBody(Element saaj) throws TransformerException, IOException {
        Element body = TestMessageTransformer.getFirstChildElement(saaj, new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body"), true);
        Element encData = TestMessageTransformer.getFirstChildElement(body, new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData"), true);
        Element newEncData = TestMessageTransformer.createNewEncryptedData(encData);
        Element sh = TestMessageTransformer.getFirstChildElement(saaj, new QName("http://schemas.xmlsoap.org/soap/envelope/", "Header"), true);
        Element signature = TestMessageTransformer.getFirstChildElement(sh, new QName("http://www.w3.org/2000/09/xmldsig#", "Signature"), true);
        Node wsseHeader = signature.getParentNode();
        Node newWsseHeader = wsseHeader.cloneNode(false);
        Node cur = wsseHeader.getFirstChild();
        String newId = newEncData.getAttributeNS(null, "Id");
        while (!cur.isSameNode(signature)) {
            cur = TestMessageTransformer.copyHeadersAndUpdateRefList(cur, newWsseHeader, newId);
        }
        Element wrapper = encData.getOwnerDocument().createElementNS(null, "a");
        Node clonedBody = body.cloneNode(false);
        clonedBody.appendChild(newEncData);
        wrapper.appendChild(clonedBody);
        body.getParentNode().appendChild(wrapper);
        while (cur != null) {
            cur = TestMessageTransformer.copyHeadersAndUpdateRefList(cur, newWsseHeader, newId);
        }
        TestMessageTransformer.updateEncryptedKeyRefList(newWsseHeader, newId);
        Node parent = wsseHeader.getParentNode();
        parent.removeChild(wsseHeader);
        parent.appendChild(newWsseHeader);
        TestMessageTransformer.print(saaj.getOwnerDocument());
        return newEncData;
    }

    public static Element duplicateEncryptedDataInExternalWrapperElement(Element saaj, boolean moveReferenceList) throws TransformerException, IOException {
        if (moveReferenceList) {
            TestMessageTransformer.moveReferenceList(saaj);
        }
        Element body = TestMessageTransformer.getFirstChildElement(saaj, new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body"), true);
        Element encData = TestMessageTransformer.getFirstChildElement(body, new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData"), true);
        Element newEncData = TestMessageTransformer.createNewEncryptedData(encData);
        Element sh = TestMessageTransformer.getFirstChildElement(saaj, new QName("http://schemas.xmlsoap.org/soap/envelope/", "Header"), true);
        Element wsseHeader = TestMessageTransformer.getFirstChildElement(sh, new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"), true);
        Node newWsseHeader = wsseHeader.cloneNode(false);
        Node cur = wsseHeader.getFirstChild();
        String newId = newEncData.getAttributeNS(null, "Id");
        while (cur != null) {
            cur = TestMessageTransformer.copyHeadersAndUpdateRefList(cur, newWsseHeader, newId);
        }
        sh.removeChild(wsseHeader);
        sh.appendChild(newWsseHeader);
        if (!moveReferenceList) {
            TestMessageTransformer.updateEncryptedKeyRefList(newWsseHeader, newId);
        }
        Element wrapper = encData.getOwnerDocument().createElementNS(null, "a");
        wrapper.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "mustUnderstand", "0");
        wrapper.setAttributeNS("http://schemas.xmlsoap.org/soap/envelope/", "actor", "foo");
        wrapper.appendChild(newEncData);
        sh.appendChild(wrapper);
        TestMessageTransformer.print(saaj.getOwnerDocument());
        return newEncData;
    }

    public static Element addEncryptedDataWithEmbeddedEncryptedKeyInWsseHeader(Element saaj) throws TransformerException, IOException {
        TestMessageTransformer.moveReferenceList(saaj);
        Element body = TestMessageTransformer.getFirstChildElement(saaj, new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body"), true);
        Element encData = TestMessageTransformer.getFirstChildElement(body, new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedData"), true);
        Element newEncData = (Element)encData.cloneNode(true);
        String newId = newEncData.getAttributeNS(null, "Id") + "b";
        newEncData.setAttributeNS(null, "Id", newId);
        Element encKey = TestMessageTransformer.getFirstChildElement(saaj, new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey"), true);
        Element newEncKey = (Element)encKey.cloneNode(true);
        String newEcId = newEncKey.getAttributeNS(null, "Id") + "b";
        newEncKey.setAttributeNS(null, "Id", newEcId);
        Element keyInfo = TestMessageTransformer.getFirstChildElement(newEncData, new QName("http://www.w3.org/2000/09/xmldsig#", "KeyInfo"), true);
        Element str = TestMessageTransformer.getFirstChildElement(newEncData, new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "SecurityTokenReference"), true);
        keyInfo.replaceChild(newEncKey, str);
        Element wsseHeader = TestMessageTransformer.getFirstChildElement(saaj, new QName("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "Security"), true);
        Node newWsseHeader = wsseHeader.cloneNode(false);
        Node cur = wsseHeader.getFirstChild();
        while (cur != null) {
            cur = TestMessageTransformer.copyHeadersAndUpdateRefList(cur, newWsseHeader, newId);
        }
        newWsseHeader.appendChild(newEncData);
        Node parent = wsseHeader.getParentNode();
        parent.removeChild(wsseHeader);
        parent.appendChild(newWsseHeader);
        TestMessageTransformer.print(saaj.getOwnerDocument());
        return newEncData;
    }

    private static void moveReferenceList(Element saaj) {
        Element sh = TestMessageTransformer.getFirstChildElement(saaj, new QName("http://schemas.xmlsoap.org/soap/envelope/", "Header"), true);
        Element encKey = TestMessageTransformer.getFirstChildElement(sh, new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey"), true);
        Element refList = TestMessageTransformer.getFirstChildElement(encKey, new QName("http://www.w3.org/2001/04/xmlenc#", "ReferenceList"), true);
        Node wsseHeader = encKey.getParentNode();
        encKey.removeChild(refList);
        wsseHeader.appendChild(refList);
    }

    private static void updateEncryptedKeyRefList(Node wsseHeader, String newId) {
        Element encryptedKey = TestMessageTransformer.getFirstChildElement(wsseHeader, new QName("http://www.w3.org/2001/04/xmlenc#", "EncryptedKey"), true);
        Element ref = TestMessageTransformer.getFirstChildElement(encryptedKey, new QName("http://www.w3.org/2001/04/xmlenc#", "DataReference"), true);
        Element newRef = (Element)ref.cloneNode(true);
        newRef.setAttributeNS(null, "URI", "#" + newId);
        ref.getParentNode().appendChild(newRef);
    }

    private static void print(Document doc) throws TransformerException, IOException {
        if (LOG.isDebugEnabled()) {
            LOG.debug("After transformation....");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
    }

    private static Element createNewEncryptedData(Element encData) {
        Element newEncData = (Element)encData.cloneNode(true);
        String id = newEncData.getAttributeNS(null, "Id");
        String newId = id + "b";
        newEncData.setAttributeNS(null, "Id", newId);
        return newEncData;
    }

    private static Node copyHeadersAndUpdateRefList(Node cur, Node dest, String newId) {
        Element t;
        Node temp = cur.cloneNode(true);
        dest.appendChild(temp);
        if (newId != null && temp.getNodeType() == 1 && (t = (Element)temp).getLocalName().equals("ReferenceList")) {
            Element ref = TestMessageTransformer.getFirstChildElement(t, new QName("http://www.w3.org/2001/04/xmlenc#", "DataReference"), true);
            Element newRef = (Element)ref.cloneNode(true);
            newRef.setAttributeNS(null, "URI", "#" + newId);
            t.appendChild(newRef);
        }
        return cur.getNextSibling();
    }

    private static Element getFirstChildElement(Node node, QName nodeName, boolean recursive) {
        Element childElement = null;
        Iterator<Element> it = TestMessageTransformer.getChildElements(node, nodeName, recursive).iterator();
        if (it.hasNext()) {
            childElement = it.next();
        }
        return childElement;
    }

    private static List<Element> getChildElements(Node node, QName nodeName, boolean recursive) {
        LinkedList<Element> list = new LinkedList<Element>();
        NodeList nlist = node.getChildNodes();
        int len = nlist.getLength();
        for (int i = 0; i < len; ++i) {
            Node child = nlist.item(i);
            if (child.getNodeType() != 1) continue;
            TestMessageTransformer.search(list, (Element)child, nodeName, recursive);
        }
        return list;
    }

    private static void search(List<Element> list, Element baseElement, QName nodeName, boolean recursive) {
        if (nodeName == null) {
            list.add(baseElement);
        } else {
            QName qname = nodeName.getNamespaceURI().length() > 0 ? new QName(baseElement.getNamespaceURI(), baseElement.getLocalName()) : new QName(baseElement.getLocalName());
            if (qname.equals(nodeName)) {
                list.add(baseElement);
            }
        }
        if (recursive) {
            NodeList nlist = baseElement.getChildNodes();
            int len = nlist.getLength();
            for (int i = 0; i < len; ++i) {
                Node child = nlist.item(i);
                if (child.getNodeType() != 1) continue;
                TestMessageTransformer.search(list, (Element)child, nodeName, recursive);
            }
        }
    }
}

