/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.List;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.WSSecTimestamp;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SignatureWSS651Test {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureWSS651Test.class);
    private static final String SAMPLE_SOAP_MSG_WSU_NS = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\" xmlns:u=\"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd\" ><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>";
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private Crypto crypto;

    public SignatureWSS651Test() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance();
    }

    @Test
    public void testSignedTimestamp() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SAMPLE_SOAP_MSG_WSU_NS);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecTimestamp timestamp = new WSSecTimestamp(secHeader);
        timestamp.setTimeToLive(300);
        timestamp.build();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        WSEncryptionPart encP = new WSEncryptionPart("Timestamp", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "");
        builder.getParts().add(encP);
        builder.prepare(this.crypto);
        List referenceList = builder.addReferencesToSign(builder.getParts());
        builder.computeSignature(referenceList, false, null);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            LOG.debug(outputString);
        }
        this.verify(doc);
        Document doc2 = SOAPUtil.toSOAPPart((String)outputString);
        this.verify(doc2);
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        return this.secEngine.processSecurityHeader(doc, null, null, this.crypto);
    }
}

