/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.security.Provider;
import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.str.STRParser;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureProviderTest {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureProviderTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();

    public SignatureProviderTest() throws Exception {
        WSSConfig.init();
    }

    @Test
    public void testBouncyCastleSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(2);
        builder.setSignatureProvider((Provider)new BouncyCastleProvider());
        LOG.info("Before Signing IS....");
        Crypto crypto = CryptoFactory.getInstance();
        Document signedDoc = builder.build(crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message with IssuerSerial key identifier:");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        LOG.info("After Signing IS....");
        WSHandlerResult results = this.verify(signedDoc, crypto);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult.get((Object)"x509-certificate"));
        Assertions.assertNotNull((Object)actionResult.get((Object)"x509-reference-type"));
        STRParser.REFERENCE_TYPE referenceType = (STRParser.REFERENCE_TYPE)actionResult.get((Object)"x509-reference-type");
        Assertions.assertTrue((referenceType == STRParser.REFERENCE_TYPE.ISSUER_SERIAL ? 1 : 0) != 0);
    }

    private WSHandlerResult verify(Document doc, Crypto crypto) throws Exception {
        RequestData data = new RequestData();
        data.setWssConfig(WSSConfig.getNewInstance());
        data.setSigVerCrypto(crypto);
        data.setDecCrypto(crypto);
        data.setSignatureProvider((Provider)new BouncyCastleProvider());
        data.setCallbackHandler((CallbackHandler)new KeystoreCallbackHandler());
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)doc, null);
        return this.secEngine.processSecurityHeader(securityHeader, data);
    }
}

