/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.io.InputStream;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.crypto.dsig.XMLSignature;
import javax.xml.crypto.dsig.XMLSignatureFactory;
import javax.xml.crypto.dsig.dom.DOMValidateContext;
import javax.xml.crypto.dsig.spec.ExcC14NParameterSpec;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class SignaturePrefixListTest {
    private static final Logger LOG = LoggerFactory.getLogger(SignaturePrefixListTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private Crypto crypto;

    public SignaturePrefixListTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance();
    }

    @Test
    public void testDuplicatePrefixListValues() throws Exception {
        Document doc = null;
        try (InputStream inputStream = Loader.getResource((String)"org/apache/wss4j/dom/message/SignaturePrefixListMessage.xml").openStream();){
            DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
            factory.setNamespaceAware(true);
            DocumentBuilder builder = factory.newDocumentBuilder();
            doc = builder.parse(inputStream);
        }
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(2);
        Document signedDoc = builder.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(signedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Element receivedSignature = (Element)actionResult.get((Object)"token-element");
        Assertions.assertNotNull((Object)receivedSignature);
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("16c73ab6-b892-458f-abf5-2f875f74882e");
        DOMValidateContext context = new DOMValidateContext(this.crypto.getX509Certificates(cryptoType)[0].getPublicKey(), (Node)receivedSignature);
        XMLSignatureFactory signatureFactory = XMLSignatureFactory.getInstance("DOM", "ApacheXMLDSig");
        XMLSignature xmlSignature = signatureFactory.unmarshalXMLSignature(context);
        ExcC14NParameterSpec spec = (ExcC14NParameterSpec)xmlSignature.getSignedInfo().getCanonicalizationMethod().getParameterSpec();
        ArrayList<String> expectedPrefixes = new ArrayList<String>(Arrays.asList("S12", "ds", "eb", "ebbp", "ns5"));
        Assertions.assertEquals(expectedPrefixes, spec.getPrefixList());
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        return this.secEngine.processSecurityHeader(doc, null, null, this.crypto);
    }
}

