/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.io.InputStream;
import java.security.KeyStore;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.SOAPConstants;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.saml.SignedSamlTokenHOKTest;
import org.apache.wss4j.dom.saml.WSSecSignatureSAML;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignaturePartsTest {
    private static final Logger LOG = LoggerFactory.getLogger(SignaturePartsTest.class);
    private static final String SOAPMSG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:foo=\"urn:foo.bar\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <soapenv:Header>       <foo:foobar>baz</foo:foobar>   </soapenv:Header>   <soapenv:Body>      <ns1:testMethod xmlns:ns1=\"http://axis/service/security/test6/LogTestService8\"></ns1:testMethod>   </soapenv:Body></soapenv:Envelope>";
    private static final String SOAPMSG_MULTIPLE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:foo=\"urn:foo.bar\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <soapenv:Header>       <foo:foobar>baz</foo:foobar>   </soapenv:Header>   <soapenv:Body>      <ns1:testMethod xmlns:ns1=\"http://axis/service/security/test6/LogTestService8\">asf1</ns1:testMethod>      <ns1:testMethod xmlns:ns1=\"http://axis/service/security/test6/LogTestService8\">asf2</ns1:testMethod>   </soapenv:Body></soapenv:Envelope>";
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private Crypto crypto;

    public SignaturePartsTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance();
    }

    @Test
    public void testSOAPHeader() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        sign.getParts().add(encP);
        Document signedDoc = sign.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(signedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/soapenv:Envelope/soapenv:Header/foo:foobar", (Object)xpath);
        Assertions.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Object)wsDataRef.getAlgorithm());
        Assertions.assertNotNull((Object)wsDataRef.getDigestValue());
        Assertions.assertTrue((wsDataRef.getDigestValue().length > 0 ? 1 : 0) != 0);
        QName expectedQName = new QName("urn:foo.bar", "foobar");
        Assertions.assertEquals((Object)expectedQName, (Object)wsDataRef.getName());
        Assertions.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#sha1", (Object)wsDataRef.getDigestAlgorithm());
        String sigMethod = (String)actionResult.get((Object)"signature-method");
        Assertions.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Object)sigMethod);
        String c14nMethod = (String)actionResult.get((Object)"canonicalization-method");
        Assertions.assertEquals((Object)"http://www.w3.org/2001/10/xml-exc-c14n#", (Object)c14nMethod);
        List transformAlgorithms = wsDataRef.getTransformAlgorithms();
        Assertions.assertTrue((transformAlgorithms.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)"http://www.w3.org/2001/10/xml-exc-c14n#".equals(transformAlgorithms.get(0)));
    }

    @Test
    public void testOptionalSOAPHeaderPresent() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        encP.setRequired(false);
        sign.getParts().add(encP);
        String soapNamespace = WSSecurityUtil.getSOAPNamespace((Element)doc.getDocumentElement());
        encP = new WSEncryptionPart("Body", soapNamespace, "Content");
        sign.getParts().add(encP);
        Document signedDoc = sign.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        this.verify(signedDoc);
    }

    @Test
    public void testOptionalSOAPHeaderNotPresent() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        encP.setRequired(false);
        sign.getParts().add(encP);
        String soapNamespace = WSSecurityUtil.getSOAPNamespace((Element)doc.getDocumentElement());
        encP = new WSEncryptionPart("Body", soapNamespace, "Content");
        sign.getParts().add(encP);
        Document signedDoc = sign.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        this.verify(signedDoc);
    }

    @Test
    public void testRequiredSOAPHeaderNotPresent() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        sign.getParts().add(encP);
        String soapNamespace = WSSecurityUtil.getSOAPNamespace((Element)doc.getDocumentElement());
        encP = new WSEncryptionPart("Body", soapNamespace, "Content");
        sign.getParts().add(encP);
        try {
            sign.build(this.crypto);
            Assertions.fail((String)"Failure expected on not signing a required element");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_SIGNATURE ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSOAPHeaderSTRTransform() throws Exception {
        Merlin issuerCrypto = new Merlin();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ClassLoader loader = Loader.getClassLoader(SignedSamlTokenHOKTest.class);
        InputStream input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40_server.jks");
        keyStore.load(input, "security".toCharArray());
        input.close();
        issuerCrypto.setKeyStore(keyStore);
        Crypto userCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        samlCallback.setIssuer("www.example.com");
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        samlAssertion.signAssertion("wss40_server", "security", (Crypto)issuerCrypto, false);
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML(secHeader);
        wsSign.setKeyIdentifierType(1);
        wsSign.setUserInfo("wss40", "security");
        WSEncryptionPart encP = new WSEncryptionPart("STRTransform", "", "Element");
        wsSign.getParts().add(encP);
        Document signedDoc = wsSign.build(userCrypto, samlAssertion, null, null, null);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed SAML message (key holder):");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Merlin trustCrypto = new Merlin();
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40CA.jks");
        trustStore.load(input, "security".toCharArray());
        input.close();
        trustCrypto.setTrustStore(trustStore);
        WSHandlerResult results = this.secEngine.processSecurityHeader(doc, null, null, (Crypto)trustCrypto);
        WSSecurityEngineResult stUnsignedActionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(16)).get(0);
        SamlAssertionWrapper receivedSamlAssertion = (SamlAssertionWrapper)stUnsignedActionResult.get((Object)"saml-assertion");
        Assertions.assertNotNull((Object)receivedSamlAssertion);
        Assertions.assertTrue((boolean)receivedSamlAssertion.isSigned());
        WSSecurityEngineResult signActionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)signActionResult);
        Assertions.assertFalse((boolean)signActionResult.isEmpty());
        List refs = (List)signActionResult.get((Object)"data-ref-uris");
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/soapenv:Envelope/soapenv:Header/wsse:Security/saml1:Assertion", (Object)xpath);
    }

    @Test
    public void testBadLocalname() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("foobar2", "urn:foo.bar", "");
        sign.getParts().add(encP);
        try {
            sign.build(this.crypto);
            Assertions.fail((String)"Failure expected on a bad localname");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_SIGNATURE ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBadNamespace() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar2", "");
        sign.getParts().add(encP);
        try {
            sign.build(this.crypto);
            Assertions.fail((String)"Failure expected on a bad namespace");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_SIGNATURE ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSOAPHeaderAndBody() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "");
        sign.getParts().add(encP);
        WSEncryptionPart encP2 = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        sign.getParts().add(encP2);
        Document signedDoc = sign.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(signedDoc);
        QName fooName = new QName("urn:foo.bar", "foobar");
        QName bodyName = new QName(soapConstants.getEnvelopeURI(), "Body");
        QName headerName = new QName(soapConstants.getEnvelopeURI(), "Header");
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertTrue((refs != null && !refs.isEmpty() ? 1 : 0) != 0);
        boolean foundFoo = false;
        boolean foundBody = false;
        boolean foundHeader = false;
        for (WSDataRef ref : refs) {
            if (fooName.equals(ref.getName())) {
                foundFoo = true;
                continue;
            }
            if (bodyName.equals(ref.getName())) {
                foundBody = true;
                continue;
            }
            if (!headerName.equals(ref.getName())) continue;
            foundHeader = true;
        }
        Assertions.assertTrue((foundFoo && foundBody ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)foundHeader);
    }

    @Test
    public void testSignaturePartDOMElement() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        WSEncryptionPart encP = new WSEncryptionPart("Incorrect Localname", "Incorrect N/S", "");
        Element bodyElement = WSSecurityUtil.findBodyElement((Document)doc);
        Assertions.assertTrue((bodyElement != null && "Body".equals(bodyElement.getLocalName()) ? 1 : 0) != 0);
        encP.setElement(bodyElement);
        sign.getParts().add(encP);
        Document signedDoc = sign.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(signedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        QName bodyName = new QName(soapConstants.getEnvelopeURI(), "Body");
        Assertions.assertEquals((Object)bodyName, (Object)wsDataRef.getName());
    }

    @Test
    public void testMultipleElements() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG_MULTIPLE);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("testMethod", "http://axis/service/security/test6/LogTestService8", "");
        sign.getParts().add(encP);
        Document signedDoc = sign.build(this.crypto);
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(signedDoc);
    }

    @Test
    public void testSignedKeyInfo() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        sign.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("KeyInfo", "http://www.w3.org/2000/09/xmldsig#", "");
        sign.getParts().add(encP);
        Document signedDoc = sign.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(signedDoc);
        this.verifySignedKeyInfoResults(results);
    }

    @Test
    public void testSignedKeyInfoAction() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("16c73ab6-b892-458f-abf5-2f875f74882e");
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("signaturePropFile", "crypto.properties");
        config.put("password", "security");
        config.put("signatureParts", "{}{http://www.w3.org/2000/09/xmldsig#}KeyInfo");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(2)));
        handler.send(doc, reqData, actions, true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message:");
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(doc);
        ArrayList<Integer> receivedActions = new ArrayList<Integer>();
        receivedActions.add(2);
        Assertions.assertTrue((boolean)handler.checkResults(results.getResults(), receivedActions));
        this.verifySignedKeyInfoResults(results);
    }

    private void verifySignedKeyInfoResults(WSHandlerResult results) {
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertTrue((boolean)xpath.matches("/(soapenv|SOAP-ENV):Envelope/(soapenv|SOAP-ENV):Header/wsse:Security/ds:Signature/ds:KeyInfo"));
        Assertions.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Object)wsDataRef.getAlgorithm());
        Assertions.assertNotNull((Object)wsDataRef.getDigestValue());
        Assertions.assertTrue((wsDataRef.getDigestValue().length > 0 ? 1 : 0) != 0);
        QName expectedQName = new QName("http://www.w3.org/2000/09/xmldsig#", "KeyInfo");
        Assertions.assertEquals((Object)expectedQName, (Object)wsDataRef.getName());
        Assertions.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#sha1", (Object)wsDataRef.getDigestAlgorithm());
        String sigMethod = (String)actionResult.get((Object)"signature-method");
        Assertions.assertEquals((Object)"http://www.w3.org/2000/09/xmldsig#rsa-sha1", (Object)sigMethod);
        String c14nMethod = (String)actionResult.get((Object)"canonicalization-method");
        Assertions.assertEquals((Object)"http://www.w3.org/2001/10/xml-exc-c14n#", (Object)c14nMethod);
        List transformAlgorithms = wsDataRef.getTransformAlgorithms();
        Assertions.assertTrue((transformAlgorithms.size() == 1 ? 1 : 0) != 0);
        Assertions.assertTrue((boolean)"http://www.w3.org/2001/10/xml-exc-c14n#".equals(transformAlgorithms.get(0)));
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        WSHandlerResult results = this.secEngine.processSecurityHeader(doc, null, null, this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verfied and decrypted message:");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        return results;
    }
}

