/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.security.Principal;
import java.security.PublicKey;
import java.security.interfaces.DSAPublicKey;
import java.security.interfaces.ECPublicKey;
import java.security.interfaces.RSAPublicKey;
import java.util.Collections;
import java.util.List;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.principal.PublicKeyPrincipal;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SignatureKeyValueTest {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureKeyValueTest.class);
    private Crypto crypto;

    public SignatureKeyValueTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance((String)"wss40.properties");
    }

    @Test
    public void testRSAKeyValue() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("wss40", "security");
        builder.setKeyIdentifierType(13);
        Document signedDoc = builder.build(this.crypto);
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("RSAKeyValue"));
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setSigVerCrypto(this.crypto);
        data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R5417));
        WSHandlerResult results = secEngine.processSecurityHeader(signedDoc, data);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        Assertions.assertTrue((boolean)(principal instanceof PublicKeyPrincipal));
        PublicKey publicKey = ((PublicKeyPrincipal)principal).getPublicKey();
        Assertions.assertTrue((boolean)(publicKey instanceof RSAPublicKey));
    }

    @Test
    public void testBadRSAKeyValue() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("wss86", "security");
        builder.setKeyIdentifierType(13);
        Document signedDoc = builder.build(CryptoFactory.getInstance((String)"wss86.properties"));
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("RSAKeyValue"));
        try {
            WSSecurityEngine secEngine = new WSSecurityEngine();
            RequestData data = new RequestData();
            data.setSigVerCrypto(this.crypto);
            data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R5417));
            secEngine.processSecurityHeader(signedDoc, data);
            Assertions.fail((String)"Failure expected on bad public key");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_AUTHENTICATION ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDSAKeyValue() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("wss40DSA", "security");
        builder.setKeyIdentifierType(13);
        Document signedDoc = builder.build(this.crypto);
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("DSAKeyValue"));
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setSigVerCrypto(this.crypto);
        data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R5417));
        WSHandlerResult results = secEngine.processSecurityHeader(signedDoc, data);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        Assertions.assertTrue((boolean)(principal instanceof PublicKeyPrincipal));
        PublicKey publicKey = ((PublicKeyPrincipal)principal).getPublicKey();
        Assertions.assertTrue((boolean)(publicKey instanceof DSAPublicKey));
    }

    @Test
    public void testECKeyValue() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("wss40ec", "security");
        builder.setKeyIdentifierType(13);
        Document signedDoc = builder.build(this.crypto);
        String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
        LOG.debug(outputString);
        Assertions.assertTrue((boolean)outputString.contains("ECKeyValue"));
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setSigVerCrypto(this.crypto);
        data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R5417));
        WSHandlerResult results = secEngine.processSecurityHeader(signedDoc, data);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Principal principal = (Principal)actionResult.get((Object)"principal");
        Assertions.assertTrue((boolean)(principal instanceof PublicKeyPrincipal));
        PublicKey publicKey = ((PublicKeyPrincipal)principal).getPublicKey();
        Assertions.assertTrue((boolean)(publicKey instanceof ECPublicKey));
    }
}

