/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SignatureEncryptionTest {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureEncryptionTest.class);
    private static final String SOAPMSG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"http://blah.com\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>";
    public static final String SAMPLE_SOAP12_FAULT_MSG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><s:Envelope xmlns:s=\"http://www.w3.org/2003/05/soap-envelope\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><s:Body><Fault xmlns=\"http://www.w3.org/2003/05/soap-envelope\"><Code><Value>Receiver</Value></Code><Reason><Text xml:lang=\"en\">Error Message.</Text></Reason></Fault></s:Body></s:Envelope>";
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");

    public SignatureEncryptionTest() throws Exception {
        WSSConfig.init();
    }

    @Test
    public void testEncryptionSigning() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        WSSecSignature sign = new WSSecSignature(secHeader);
        encrypt.setUserInfo("wss40");
        sign.setUserInfo("wss40", "security");
        LOG.info("Before Encryption....");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Encryption....");
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        Document encryptedSignedDoc = sign.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedSignedDoc);
            LOG.debug(outputString);
        }
        this.verify(encryptedSignedDoc);
    }

    @Test
    public void testEncryptionElementSigning() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        WSSecSignature sign = new WSSecSignature(secHeader);
        encrypt.setUserInfo("wss40");
        sign.setUserInfo("wss40", "security");
        LOG.info("Before Encryption....");
        WSEncryptionPart part = new WSEncryptionPart("add", "http://ws.apache.org/counter/counter_port_type", "Element");
        encrypt.getParts().add(part);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Encryption....");
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        WSEncryptionPart signPart = new WSEncryptionPart("EncryptedData", "http://www.w3.org/2001/04/xmlenc#", "Element");
        sign.getParts().add(signPart);
        Document encryptedSignedDoc = sign.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedSignedDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(encryptedSignedDoc);
        List sigSecEngResults = (List)results.getActionResults().get(2);
        List encSecEngResults = (List)results.getActionResults().get(4);
        Assertions.assertEquals((int)1, (int)sigSecEngResults.size());
        Assertions.assertEquals((int)1, (int)encSecEngResults.size());
        List sigDataRefs = (List)((WSSecurityEngineResult)sigSecEngResults.get(0)).get((Object)"data-ref-uris");
        List encDataRefs = (List)((WSSecurityEngineResult)encSecEngResults.get(0)).get((Object)"data-ref-uris");
        Assertions.assertNotNull((Object)sigDataRefs);
        Assertions.assertNotNull((Object)encDataRefs);
        Assertions.assertEquals((int)1, (int)sigDataRefs.size());
        Assertions.assertEquals((int)1, (int)encDataRefs.size());
        Assertions.assertNull((Object)((WSDataRef)sigDataRefs.get(0)).getProtectedElement().getAttributeNodeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "Id"));
        Assertions.assertTrue((boolean)((WSDataRef)sigDataRefs.get(0)).getWsuId().contains(((WSDataRef)encDataRefs.get(0)).getWsuId()));
    }

    @Test
    public void testSigningEncryption() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        WSSecSignature sign = new WSSecSignature(secHeader);
        encrypt.setUserInfo("wss40");
        sign.setUserInfo("wss40", "security");
        LOG.info("Before Encryption....");
        sign.build(this.crypto);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedSignedDoc = encrypt.build(this.crypto, symmetricKey);
        LOG.info("After Encryption....");
        this.verify(encryptedSignedDoc);
    }

    @Test
    public void testWSS198() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        WSSecSignature sign = new WSSecSignature(secHeader);
        encrypt.setUserInfo("wss40");
        sign.setUserInfo("wss40", "security");
        LOG.info("Before Encryption....");
        WSEncryptionPart encP = new WSEncryptionPart("add", "http://ws.apache.org/counter/counter_port_type", "");
        encrypt.getParts().add(encP);
        sign.build(this.crypto);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedSignedDoc = encrypt.build(this.crypto, symmetricKey);
        LOG.info("WSS198");
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedSignedDoc);
            LOG.debug(outputString);
        }
        this.verify(encryptedSignedDoc);
    }

    @Test
    public void testSigningEncryptionIS3DES() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("wss40");
        encrypt.setKeyIdentifierType(2);
        encrypt.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setUserInfo("wss40", "security");
        sign.setKeyIdentifierType(2);
        LOG.info("Before Sign/Encryption....");
        sign.build(this.crypto);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedSignedDoc = encrypt.build(this.crypto, symmetricKey);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed and encrypted message with IssuerSerial key identifier (both), 3DES:");
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedSignedDoc);
            LOG.debug(outputString);
        }
        LOG.info("After Sign/Encryption....");
        this.verify(encryptedSignedDoc);
    }

    @Test
    public void testEncryptedKeySignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        LOG.info("Before Sign/Encryption....");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncryptedKey encrKey = new WSSecEncryptedKey(secHeader);
        encrKey.setKeyIdentifierType(2);
        encrKey.setUserInfo("wss40", "security");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes192-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        encrKey.prepare(this.crypto, symmetricKey);
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setEncKeyId(encrKey.getId());
        encrypt.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        encrypt.setEncryptSymmKey(false);
        encrypt.setEncryptedKeyElement(encrKey.getEncryptedKeyElement());
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setKeyIdentifierType(9);
        sign.setCustomTokenId(encrKey.getId());
        sign.setSecretKey(symmetricKey.getEncoded());
        sign.setCustomTokenValueType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
        sign.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sign.build(this.crypto);
        Document encryptedSignedDoc = encrypt.build(this.crypto, symmetricKey);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed and encrypted message with IssuerSerial key identifier (both), 3DES:");
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedSignedDoc);
            LOG.debug(outputString);
        }
        LOG.info("After Sign/Encryption....");
        this.verify(encryptedSignedDoc);
    }

    @Test
    public void testEncryptionSigningHandler() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<Object, Object> messageContext = new TreeMap<Object, Object>();
        messageContext.put("passwordCallbackRef", new KeystoreCallbackHandler());
        messageContext.put("encryptionPropRefId", "" + this.crypto.hashCode());
        messageContext.put("signaturePropRefId", "" + this.crypto.hashCode());
        messageContext.put("" + this.crypto.hashCode(), this.crypto);
        reqData.setMsgContext(messageContext);
        reqData.setUsername("wss40");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> handlerActions = new ArrayList<HandlerAction>();
        HandlerAction action = new HandlerAction(Integer.valueOf(4));
        handlerActions.add(action);
        action = new HandlerAction(Integer.valueOf(2));
        handlerActions.add(action);
        handler.send(doc, reqData, handlerActions, true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        ArrayList<Integer> receivingActions = new ArrayList<Integer>();
        receivingActions.add(4);
        receivingActions.add(2);
        messageContext.put("decryptionPropRefId", "" + this.crypto.hashCode());
        messageContext.put("signatureVerificationPropRefId", "" + this.crypto.hashCode());
        handler.receive(receivingActions, reqData);
        WSSecurityEngine newEngine = new WSSecurityEngine();
        newEngine.processSecurityHeader(doc, reqData);
    }

    @Test
    public void testSigningEncryptionHandler() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<Object, Object> messageContext = new TreeMap<Object, Object>();
        messageContext.put("passwordCallbackRef", new KeystoreCallbackHandler());
        messageContext.put("encryptionPropRefId", "" + this.crypto.hashCode());
        messageContext.put("signaturePropRefId", "" + this.crypto.hashCode());
        messageContext.put("" + this.crypto.hashCode(), this.crypto);
        reqData.setMsgContext(messageContext);
        reqData.setUsername("wss40");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> handlerActions = new ArrayList<HandlerAction>();
        HandlerAction action = new HandlerAction(Integer.valueOf(2));
        handlerActions.add(action);
        action = new HandlerAction(Integer.valueOf(4));
        handlerActions.add(action);
        handler.send(doc, reqData, handlerActions, true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        ArrayList<Integer> receivingActions = new ArrayList<Integer>();
        receivingActions.add(2);
        receivingActions.add(4);
        messageContext.put("decryptionPropRefId", "" + this.crypto.hashCode());
        messageContext.put("signatureVerificationPropRefId", "" + this.crypto.hashCode());
        handler.receive(receivingActions, reqData);
        WSSecurityEngine newEngine = new WSSecurityEngine();
        newEngine.processSecurityHeader(doc, reqData);
    }

    @Test
    public void testSigningEncryptionSOAP12Fault() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        WSSecSignature sign = new WSSecSignature(secHeader);
        encrypt.setUserInfo("wss40");
        sign.setUserInfo("wss40", "security");
        LOG.info("Before Encryption....");
        sign.build(this.crypto);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedSignedDoc = encrypt.build(this.crypto, symmetricKey);
        LOG.info("After Encryption....");
        this.verify(encryptedSignedDoc);
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        WSHandlerResult resultList = this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, this.crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        return resultList;
    }
}

