/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.Collections;
import java.util.regex.Pattern;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureCertConstraintsTest {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureCertConstraintsTest.class);
    private Crypto crypto;
    private Crypto cryptoCA;

    public SignatureCertConstraintsTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance((String)"wss40.properties");
        this.cryptoCA = CryptoFactory.getInstance((String)"wss40CA.properties");
    }

    @Test
    public void testBSTSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("wss40", "security");
        builder.setKeyIdentifierType(1);
        Document signedDoc = builder.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message with BST key identifier:");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)signedDoc, null);
        String certConstraint = ".*CN=Colm.*O=Apache.*";
        this.verify(securityHeader, this.cryptoCA, certConstraint);
        certConstraint = ".*CN=Colm2.*O=Apache.*";
        try {
            this.verify(securityHeader, this.cryptoCA, certConstraint);
            Assertions.fail((String)"Failure expected on a bad cert constraint");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_AUTHENTICATION ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBSTSignaturePKIPath() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("wss40", "security");
        builder.setKeyIdentifierType(1);
        builder.setUseSingleCertificate(false);
        Document signedDoc = builder.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message with BST key identifier:");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)signedDoc, null);
        String certConstraint = ".*CN=Colm.*O=Apache.*";
        this.verify(securityHeader, this.cryptoCA, certConstraint);
        certConstraint = ".*CN=Colm2.*O=Apache.*";
        try {
            this.verify(securityHeader, this.cryptoCA, certConstraint);
            Assertions.fail((String)"Failure expected on a bad cert constraint");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_AUTHENTICATION ? 1 : 0) != 0);
        }
    }

    private WSHandlerResult verify(Element securityHeader, Crypto sigCrypto, String certConstraint) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setSigVerCrypto(sigCrypto);
        if (certConstraint != null) {
            Pattern subjectDNPattern = Pattern.compile(certConstraint.trim());
            data.setSubjectCertConstraints(Collections.singletonList(subjectDNPattern));
        }
        return secEngine.processSecurityHeader(securityHeader, data);
    }
}

