/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.ArrayList;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.SignatureActionToken;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.AlgorithmSuite;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.dom.common.SecretKeyCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureAlgorithmSuiteTest {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureAlgorithmSuiteTest.class);
    private Crypto crypto;

    public SignatureAlgorithmSuiteTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance();
    }

    @Test
    public void testSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(2);
        builder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        Document signedDoc = builder.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)signedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        this.verify(securityHeader, algorithmSuite, this.crypto);
        algorithmSuite.setMinimumAsymmetricKeyLength(1024);
        try {
            this.verify(securityHeader, algorithmSuite, this.crypto);
            Assertions.fail((String)"Expected failure as 512-bit keys are not allowed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSignatureMethodDSA() throws Exception {
        Crypto dsaCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("wss40DSA", "security");
        builder.setKeyIdentifierType(2);
        builder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        Document signedDoc = builder.build(dsaCrypto);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)signedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        try {
            this.verify(securityHeader, algorithmSuite, dsaCrypto);
            Assertions.fail((String)"Expected failure as DSA is not allowed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        algorithmSuite.addSignatureMethod("http://www.w3.org/2000/09/xmldsig#dsa-sha1");
        this.verify(securityHeader, algorithmSuite, dsaCrypto);
    }

    @Test
    public void testSymmetricKey() throws Exception {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        SecretKey key = keyGen.generateKey();
        byte[] keyData = key.getEncoded();
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setKeyIdentifierType(10);
        builder.setSecretKey(keyData);
        builder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        Document signedDoc = builder.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        byte[] encodedBytes = KeyUtils.generateDigest((byte[])keyData);
        String identifier = XMLUtils.encodeToString((byte[])encodedBytes);
        SecretKeyCallbackHandler secretKeyCallbackHandler = new SecretKeyCallbackHandler();
        secretKeyCallbackHandler.addSecretKey(identifier, keyData);
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)signedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        SignatureActionToken actionToken = new SignatureActionToken();
        actionToken.setCrypto(this.crypto);
        data.setSignatureToken(actionToken);
        data.setCallbackHandler((CallbackHandler)secretKeyCallbackHandler);
        data.setAlgorithmSuite(algorithmSuite);
        try {
            secEngine.processSecurityHeader(securityHeader, data);
            Assertions.fail((String)"Expected failure as HMAC-SHA1 is not allowed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        algorithmSuite.addSignatureMethod("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        secEngine.processSecurityHeader(securityHeader, data);
        algorithmSuite.setMinimumSymmetricKeyLength(256);
        try {
            secEngine.processSecurityHeader(securityHeader, data);
            Assertions.fail((String)"Expected failure as a 128 bit key is not allowed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        algorithmSuite.setMinimumSymmetricKeyLength(64);
        algorithmSuite.setMaximumSymmetricKeyLength(120);
        try {
            secEngine.processSecurityHeader(securityHeader, data);
            Assertions.fail((String)"Expected failure as a 128 bit key is not allowed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
    }

    @Test
    public void testC14nMethod() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(2);
        builder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        builder.setSigCanonicalization("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        Document signedDoc = builder.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)signedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        try {
            this.verify(securityHeader, algorithmSuite, this.crypto);
            Assertions.fail((String)"Expected failure as C14n algorithm is not allowed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        algorithmSuite.addC14nAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#WithComments");
        this.verify(securityHeader, algorithmSuite, this.crypto);
    }

    @Test
    public void testDigestMethod() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(2);
        builder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        builder.setDigestAlgo("http://www.w3.org/2001/04/xmlenc#sha256");
        Document signedDoc = builder.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)signedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        try {
            this.verify(securityHeader, algorithmSuite, this.crypto);
            Assertions.fail((String)"Expected failure as Digest algorithm is not allowed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        algorithmSuite.addDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        this.verify(securityHeader, algorithmSuite, this.crypto);
    }

    private AlgorithmSuite createAlgorithmSuite() {
        AlgorithmSuite algorithmSuite = new AlgorithmSuite();
        algorithmSuite.addSignatureMethod("http://www.w3.org/2000/09/xmldsig#rsa-sha1");
        algorithmSuite.setMinimumAsymmetricKeyLength(512);
        algorithmSuite.addC14nAlgorithm("http://www.w3.org/2001/10/xml-exc-c14n#");
        algorithmSuite.addDigestAlgorithm("http://www.w3.org/2000/09/xmldsig#sha1");
        return algorithmSuite;
    }

    private WSHandlerResult verify(Element securityHeader, AlgorithmSuite algorithmSuite, Crypto sigVerCrypto) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setSigVerCrypto(sigVerCrypto);
        data.setAlgorithmSuite(algorithmSuite);
        ArrayList<BSPRule> ignoredRules = new ArrayList<BSPRule>();
        ignoredRules.add(BSPRule.R5404);
        ignoredRules.add(BSPRule.R5406);
        data.setIgnoredBSPRules(ignoredRules);
        return secEngine.processSecurityHeader(securityHeader, data);
    }
}

