/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.io.InputStream;
import java.security.KeyStore;
import java.util.List;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.crypto.MerlinAKI;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SignatureAKITest {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureAKITest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();

    public SignatureAKITest() throws Exception {
        WSSConfig.init();
    }

    @Test
    public void testSignatureAKI() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("wss40", "security");
        builder.setKeyIdentifierType(1);
        Crypto signingCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        Document signedDoc = builder.build(signingCrypto);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        Crypto caCrypto = CryptoFactory.getInstance((String)"wss40CAAKI.properties");
        WSHandlerResult results = this.verify(signedDoc, caCrypto);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult.get((Object)"x509-certificate"));
        Assertions.assertNotNull((Object)actionResult.get((Object)"x509-reference-type"));
    }

    @Test
    public void testSignatureAKIDuplicate() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("wss40", "security");
        builder.setKeyIdentifierType(1);
        Crypto signingCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        Document signedDoc = builder.build(signingCrypto);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        MerlinAKI caCrypto = new MerlinAKI();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ClassLoader loader = Loader.getClassLoader(SignatureAKITest.class);
        InputStream input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40CADupl.jks");
        keyStore.load(input, "security".toCharArray());
        input.close();
        caCrypto.setKeyStore(keyStore);
        WSHandlerResult results = this.verify(signedDoc, (Crypto)caCrypto);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult.get((Object)"x509-certificate"));
        Assertions.assertNotNull((Object)actionResult.get((Object)"x509-reference-type"));
    }

    private WSHandlerResult verify(Document doc, Crypto crypto) throws Exception {
        return this.secEngine.processSecurityHeader(doc, null, null, crypto);
    }
}

