/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.List;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.common.SecretKeyCallbackHandler;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecDKEncrypt;
import org.apache.wss4j.dom.message.WSSecDKSign;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSecurityContextToken;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.token.SecurityContextToken;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SecurityContextTokenTest {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityContextTokenTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private SecretKeyCallbackHandler callbackHandler = new SecretKeyCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");

    @Test
    public void testBuild() {
        try {
            Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
            WSSecHeader secHeader = new WSSecHeader(doc);
            secHeader.insertSecurityHeader();
            WSSecSecurityContextToken sctBuilder = new WSSecSecurityContextToken(secHeader, null);
            sctBuilder.prepare(this.crypto);
            sctBuilder.prependSCTElementToHeader();
            String out = XMLUtils.prettyDocumentToString((Document)doc);
            if (LOG.isDebugEnabled()) {
                LOG.debug(out);
            }
            Assertions.assertTrue((out.indexOf("SecurityContextToken") > 0 ? 1 : 0) != 0, (String)"SecurityContextToken missing");
            Assertions.assertTrue((out.indexOf("Identifier") > 0 ? 1 : 0) != 0, (String)"wsc:Identifier missing");
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSCTDKTEncrypt() {
        try {
            Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
            WSSecHeader secHeader = new WSSecHeader(doc);
            secHeader.insertSecurityHeader();
            WSSecSecurityContextToken sctBuilder = new WSSecSecurityContextToken(secHeader, null);
            sctBuilder.prepare(this.crypto);
            byte[] tempSecret = WSSecurityUtil.generateNonce((int)16);
            this.callbackHandler.addSecretKey(sctBuilder.getIdentifier(), tempSecret);
            String tokenId = sctBuilder.getSctId();
            WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
            encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            encrBuilder.setTokenIdentifier(tokenId);
            encrBuilder.build(tempSecret);
            sctBuilder.prependSCTElementToHeader();
            if (LOG.isDebugEnabled()) {
                String out = XMLUtils.prettyDocumentToString((Document)doc);
                LOG.debug(out);
            }
            WSHandlerResult results = this.verify(doc);
            WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(1024)).get(0);
            SecurityContextToken receivedToken = (SecurityContextToken)actionResult.get((Object)"security-context-token");
            Assertions.assertNotNull((Object)receivedToken);
            Assertions.assertTrue((boolean)"http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct".equals(receivedToken.getTokenType()));
            SecurityContextToken clone = new SecurityContextToken(receivedToken.getElement());
            Assertions.assertTrue((boolean)clone.equals((Object)receivedToken));
            Assertions.assertTrue((clone.hashCode() == receivedToken.hashCode() ? 1 : 0) != 0);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSCTKDKTSign() {
        try {
            Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
            WSSecHeader secHeader = new WSSecHeader(doc);
            secHeader.insertSecurityHeader();
            WSSecSecurityContextToken sctBuilder = new WSSecSecurityContextToken(secHeader, null);
            sctBuilder.setWscVersion(2);
            sctBuilder.prepare(this.crypto);
            byte[] tempSecret = WSSecurityUtil.generateNonce((int)16);
            this.callbackHandler.addSecretKey(sctBuilder.getIdentifier(), tempSecret);
            String tokenId = sctBuilder.getSctId();
            WSSecDKSign sigBuilder = new WSSecDKSign(secHeader);
            sigBuilder.setTokenIdentifier(tokenId);
            sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
            sigBuilder.build(tempSecret);
            sctBuilder.prependSCTElementToHeader();
            if (LOG.isDebugEnabled()) {
                String out = XMLUtils.prettyDocumentToString((Document)doc);
                LOG.debug(out);
            }
            WSHandlerResult results = this.verify(doc);
            WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(1024)).get(0);
            SecurityContextToken receivedToken = (SecurityContextToken)actionResult.get((Object)"security-context-token");
            Assertions.assertNotNull((Object)receivedToken);
            Assertions.assertTrue((boolean)"http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512/sct".equals(receivedToken.getTokenType()));
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSCTKDKTSignAbsolute() {
        try {
            Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
            WSSecHeader secHeader = new WSSecHeader(doc);
            secHeader.insertSecurityHeader();
            WSSecSecurityContextToken sctBuilder = new WSSecSecurityContextToken(secHeader, null);
            sctBuilder.prepare(this.crypto);
            byte[] tempSecret = WSSecurityUtil.generateNonce((int)16);
            this.callbackHandler.addSecretKey(sctBuilder.getIdentifier(), tempSecret);
            WSSecDKSign sigBuilder = new WSSecDKSign(secHeader);
            sigBuilder.setTokenIdentifier(sctBuilder.getIdentifier());
            sigBuilder.setTokenIdDirectId(true);
            sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
            sigBuilder.build(tempSecret);
            sctBuilder.prependSCTElementToHeader();
            if (LOG.isDebugEnabled()) {
                LOG.debug("DKT Absolute");
                String outputString = XMLUtils.prettyDocumentToString((Document)doc);
                LOG.debug(outputString);
            }
            this.verify(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSCTKDKTSignEncrypt() {
        try {
            Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
            WSSecHeader secHeader = new WSSecHeader(doc);
            secHeader.insertSecurityHeader();
            WSSecSecurityContextToken sctBuilder = new WSSecSecurityContextToken(secHeader, null);
            sctBuilder.prepare(this.crypto);
            byte[] tempSecret = WSSecurityUtil.generateNonce((int)16);
            this.callbackHandler.addSecretKey(sctBuilder.getIdentifier(), tempSecret);
            String tokenId = sctBuilder.getSctId();
            WSSecDKSign sigBuilder = new WSSecDKSign(secHeader);
            sigBuilder.setTokenIdentifier(tokenId);
            sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
            sigBuilder.build(tempSecret);
            WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
            encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            encrBuilder.setTokenIdentifier(tokenId);
            encrBuilder.build(tempSecret);
            sctBuilder.prependSCTElementToHeader();
            if (LOG.isDebugEnabled()) {
                String out = XMLUtils.prettyDocumentToString((Document)doc);
                LOG.debug(out);
            }
            this.verify(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSCTKDKTEncryptSign() {
        try {
            Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
            WSSecHeader secHeader = new WSSecHeader(doc);
            secHeader.insertSecurityHeader();
            WSSecSecurityContextToken sctBuilder = new WSSecSecurityContextToken(secHeader, null);
            sctBuilder.prepare(this.crypto);
            byte[] tempSecret = WSSecurityUtil.generateNonce((int)16);
            this.callbackHandler.addSecretKey(sctBuilder.getIdentifier(), tempSecret);
            String tokenId = sctBuilder.getSctId();
            WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
            encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            encrBuilder.setTokenIdentifier(tokenId);
            encrBuilder.build(tempSecret);
            WSSecDKSign sigBuilder = new WSSecDKSign(secHeader);
            sigBuilder.setTokenIdentifier(tokenId);
            sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
            sigBuilder.build(tempSecret);
            sctBuilder.prependSCTElementToHeader();
            if (LOG.isDebugEnabled()) {
                String out = XMLUtils.prettyDocumentToString((Document)doc);
                LOG.debug(out);
            }
            this.verify(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    @Test
    public void testSCTSign() {
        try {
            Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
            WSSecHeader secHeader = new WSSecHeader(doc);
            secHeader.insertSecurityHeader();
            WSSecSecurityContextToken sctBuilder = new WSSecSecurityContextToken(secHeader, null);
            sctBuilder.prepare(this.crypto);
            byte[] tempSecret = WSSecurityUtil.generateNonce((int)16);
            this.callbackHandler.addSecretKey(sctBuilder.getIdentifier(), tempSecret);
            String tokenId = sctBuilder.getSctId();
            WSSecSignature builder = new WSSecSignature(secHeader);
            builder.setSecretKey(tempSecret);
            builder.setKeyIdentifierType(9);
            builder.setCustomTokenValueType("http://schemas.xmlsoap.org/ws/2005/02/sc/sct");
            builder.setCustomTokenId(tokenId);
            builder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
            builder.build(this.crypto);
            sctBuilder.prependSCTElementToHeader();
            if (LOG.isDebugEnabled()) {
                LOG.debug("SCT sign");
                String outputString = XMLUtils.prettyDocumentToString((Document)doc);
                LOG.debug(outputString);
            }
            this.verify(doc);
        }
        catch (Exception e) {
            e.printStackTrace();
            Assertions.fail((String)e.getMessage());
        }
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        WSHandlerResult results = this.secEngine.processSecurityHeader(doc, null, (CallbackHandler)this.callbackHandler, this.crypto);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        return results;
    }
}

