/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.SOAPConstants;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.WSSecTimestamp;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class STRSignatureTest {
    private static final Logger LOG = LoggerFactory.getLogger(STRSignatureTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private Crypto crypto;

    public STRSignatureTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance((String)"wss40.properties");
    }

    @Test
    public void testX509SignatureDirectSTR() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("wss40", "security");
        WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
        builder.getParts().add(encP);
        encP = new WSEncryptionPart("STRTransform", soapConstants.getEnvelopeURI(), "Content");
        builder.getParts().add(encP);
        builder.setKeyIdentifierType(1);
        LOG.info("Before Signing STR DirectReference....");
        Document signedDoc = builder.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message with STR DirectReference key identifier:");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        LOG.info("After Signing STR DirectReference....");
        this.verify(signedDoc);
    }

    @Test
    public void testWSS96() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("wss40", "security");
        WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
        builder.getParts().add(encP);
        encP = new WSEncryptionPart("STRTransform", soapConstants.getEnvelopeURI(), "Content");
        builder.getParts().add(encP);
        WSSecTimestamp timestamp = new WSSecTimestamp(secHeader);
        timestamp.setTimeToLive(600);
        timestamp.build();
        builder.getParts().add(new WSEncryptionPart(timestamp.getId()));
        builder.setKeyIdentifierType(1);
        LOG.info("Before Signing STR DirectReference....");
        Document signedDoc = builder.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message with STR DirectReference key identifier:");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        LOG.info("After Signing STR DirectReference....");
        this.verify(signedDoc);
    }

    @Test
    public void testX509SignatureISSTR() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("wss40", "security");
        WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
        builder.getParts().add(encP);
        encP = new WSEncryptionPart("STRTransform", soapConstants.getEnvelopeURI(), "Content");
        builder.getParts().add(encP);
        builder.setKeyIdentifierType(2);
        LOG.info("Before Signing STR IS....");
        Document signedDoc = builder.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message with STR IssuerSerial key identifier:");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        LOG.info("After Signing STR IS....");
        this.verify(signedDoc);
    }

    @Test
    public void testX509SignatureSKISTR() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("wss40", "security");
        WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
        builder.getParts().add(encP);
        encP = new WSEncryptionPart("STRTransform", soapConstants.getEnvelopeURI(), "Content");
        builder.getParts().add(encP);
        builder.setKeyIdentifierType(4);
        LOG.info("Before Signing STR SKI....");
        Document signedDoc = builder.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message with STR SKI key identifier:");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        LOG.info("After Signing STR SKI....");
        this.verify(signedDoc);
    }

    private void verify(Document doc) throws Exception {
        this.secEngine.processSecurityHeader(doc, null, null, this.crypto);
    }
}

