/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.Collections;
import java.util.Properties;
import java.util.TreeMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.JasyptPasswordEncryptor;
import org.apache.wss4j.common.crypto.PasswordEncryptor;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class PasswordEncryptorTest {
    private static final Logger LOG = LoggerFactory.getLogger(PasswordEncryptorTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private PasswordEncryptor passwordEncryptor = new JasyptPasswordEncryptor("this-is-a-secret");
    private Crypto crypto;

    public PasswordEncryptorTest() throws Exception {
        WSSConfig.init();
        Properties properties = CryptoFactory.getProperties((String)"crypto_enc.properties", (ClassLoader)Loader.getClassLoader(CryptoFactory.class));
        this.crypto = CryptoFactory.getInstance((Properties)properties, (ClassLoader)Loader.getClassLoader(CryptoFactory.class), (PasswordEncryptor)this.passwordEncryptor);
    }

    @Test
    public void testEncryptedPassword() throws Exception {
        String encryptedPassword = this.passwordEncryptor.encrypt("security");
        Assertions.assertNotNull((Object)encryptedPassword);
    }

    @Test
    public void testSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(2);
        Document signedDoc = builder.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        this.verify(signedDoc);
    }

    @Test
    public void testSignatureWSHandler() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("16c73ab6-b892-458f-abf5-2f875f74882e");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signaturePropFile", "crypto_enc.properties");
        config.put("passwordCallbackRef", this.callbackHandler);
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(2));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc);
    }

    @Test
    public void testDecryption() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(2);
        builder.setKeyEncAlgo("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(this.crypto, symmetricKey);
        String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(encryptedDoc);
    }

    @Test
    public void testDecryptionWSHandler() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("16c73ab6-b892-458f-abf5-2f875f74882e");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("encryptionPropFile", "crypto_enc.properties");
        config.put("passwordCallbackRef", this.callbackHandler);
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(4));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc);
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        return this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, this.crypto);
    }
}

