/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.time.ZoneOffset;
import java.time.ZonedDateTime;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.SAMLUtil;
import org.apache.wss4j.common.saml.SamlAssertionWrapper;
import org.apache.wss4j.common.util.DateUtil;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SAML1CallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.message.WSSecTimestamp;
import org.apache.wss4j.dom.message.WSSecUsernameToken;
import org.apache.wss4j.dom.saml.WSSecSignatureSAML;
import org.apache.wss4j.dom.util.SignatureUtils;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class ModifiedRequestTest {
    private static final Logger LOG = LoggerFactory.getLogger(ModifiedRequestTest.class);
    private static final String SOAPMSG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"http://blah.com\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>";
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto;

    public ModifiedRequestTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance();
    }

    @Test
    public void testMovedElement() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        LOG.info("Before Signing....");
        WSEncryptionPart encP = new WSEncryptionPart("value", "http://blah.com", "");
        builder.getParts().add(encP);
        Document signedDoc = builder.build(this.crypto);
        Element secHeaderElement = secHeader.getSecurityHeaderElement();
        Element envelopeElement = signedDoc.getDocumentElement();
        Node valueNode = envelopeElement.getElementsByTagNameNS("http://blah.com", "value").item(0);
        Node clonedValueNode = valueNode.cloneNode(true);
        secHeaderElement.appendChild(clonedValueNode);
        valueNode.getFirstChild().setNodeValue("250");
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc);
            Assertions.fail((String)"Failure expected on multiple elements with the same wsu:Id");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
            Assertions.assertTrue((boolean)ex.getMessage().startsWith("javax.xml.crypto.URIReferenceException: org.apache.xml.security.utils.resolver.ResourceResolverException: "));
        }
    }

    @Test
    public void testMovedElementChangedId() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        LOG.info("Before Signing....");
        WSEncryptionPart encP = new WSEncryptionPart("value", "http://blah.com", "");
        builder.getParts().add(encP);
        Document signedDoc = builder.build(this.crypto);
        Element secHeaderElement = secHeader.getSecurityHeaderElement();
        Element envelopeElement = signedDoc.getDocumentElement();
        Node valueNode = envelopeElement.getElementsByTagNameNS("http://blah.com", "value").item(0);
        Node clonedValueNode = valueNode.cloneNode(true);
        secHeaderElement.appendChild(clonedValueNode);
        valueNode.getFirstChild().setNodeValue("250");
        ((Element)valueNode).setAttributeNS("http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "wsu:Id", "id-250");
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(signedDoc);
        envelopeElement = signedDoc.getDocumentElement();
        Node bodyNode = envelopeElement.getElementsByTagNameNS("http://schemas.xmlsoap.org/soap/envelope/", "Body").item(0);
        valueNode = ((Element)bodyNode).getElementsByTagNameNS("http://blah.com", "value").item(0);
        List signedResults = (List)results.getActionResults().get(2);
        try {
            SignatureUtils.verifySignedElement((Element)((Element)valueNode), (List)signedResults);
            Assertions.fail((String)"Failure expected on the required element not being signed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
        }
    }

    @Test
    public void testDuplicatedSignedSAMLAssertion() throws Exception {
        SAML1CallbackHandler callbackHandler = new SAML1CallbackHandler();
        callbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        callbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:1.0:cm:sender-vouches");
        callbackHandler.setIssuer("www.example.com");
        SAMLCallback samlCallback = new SAMLCallback();
        SAMLUtil.doSAMLCallback((CallbackHandler)callbackHandler, (SAMLCallback)samlCallback);
        SamlAssertionWrapper samlAssertion = new SamlAssertionWrapper(samlCallback);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignatureSAML wsSign = new WSSecSignatureSAML(secHeader);
        wsSign.setKeyIdentifierType(1);
        Document signedDoc = wsSign.build(null, samlAssertion, this.crypto, "16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        Element assertionElement = (Element)samlAssertion.getElement().cloneNode(true);
        assertionElement.removeChild(assertionElement.getFirstChild());
        secHeader.getSecurityHeaderElement().appendChild(assertionElement);
        if (LOG.isDebugEnabled()) {
            LOG.debug("SAML 1.1 Authn Assertion (sender vouches):");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc);
            Assertions.fail((String)"Failure expected on duplicate tokens");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().contains("Multiple security tokens with the same Id have been detected"));
        }
    }

    @Test
    public void testDuplicatedSignedUsernameToken() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecUsernameToken usernameToken = new WSSecUsernameToken(secHeader);
        usernameToken.setUserInfo("wss86", "security");
        usernameToken.build();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        WSEncryptionPart encP = new WSEncryptionPart("UsernameToken", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-secext-1.0.xsd", "");
        builder.getParts().add(encP);
        builder.prepare(this.crypto);
        List referenceList = builder.addReferencesToSign(builder.getParts());
        builder.computeSignature(referenceList, false, null);
        secHeader.getSecurityHeaderElement().appendChild(usernameToken.getUsernameTokenElement().cloneNode(true));
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed Timestamp");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        try {
            this.verify(doc);
            Assertions.fail((String)"Failure expected on duplicate tokens");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((boolean)ex.getMessage().contains("Multiple security tokens with the same Id have been detected"));
        }
    }

    @Test
    public void testModifiedEncryptedDataStructure() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        Crypto wssCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(wssCrypto, symmetricKey);
        Element body = WSSecurityUtil.findBodyElement((Document)doc);
        Element encryptionMethod = XMLUtils.findElement((Node)body, (String)"EncryptionMethod", (String)"http://www.w3.org/2001/04/xmlenc#");
        encryptionMethod.setAttributeNS(null, "Algorithm", "http://new-algorithm");
        String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        WSSecurityEngine newEngine = new WSSecurityEngine();
        try {
            newEngine.processSecurityHeader(doc, null, (CallbackHandler)new KeystoreCallbackHandler(), wssCrypto);
            Assertions.fail((String)"Failure expected on a modified EncryptedData structure");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
    }

    @Test
    public void testModifiedEncryptedDataCipherValue() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        Crypto wssCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(wssCrypto, symmetricKey);
        Element body = WSSecurityUtil.findBodyElement((Document)doc);
        Element cipherValue = XMLUtils.findElement((Node)body, (String)"CipherValue", (String)"http://www.w3.org/2001/04/xmlenc#");
        String cipherText = cipherValue.getTextContent();
        StringBuilder stringBuilder = new StringBuilder(cipherText);
        int index = stringBuilder.length() / 2;
        char ch = stringBuilder.charAt(index);
        ch = ch != 'A' ? (char)'A' : 'B';
        stringBuilder.setCharAt(index, ch);
        cipherValue.setTextContent(stringBuilder.toString());
        String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        WSSecurityEngine newEngine = new WSSecurityEngine();
        try {
            newEngine.processSecurityHeader(doc, null, (CallbackHandler)new KeystoreCallbackHandler(), wssCrypto);
            Assertions.fail((String)"Failure expected on a modified EncryptedData CipherValue");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
        }
    }

    @Test
    public void testModifiedSecurityHeaderEncryptedDataCipherValue() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        Crypto wssCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        WSSecTimestamp timestamp = new WSSecTimestamp(secHeader);
        timestamp.setTimeToLive(300);
        timestamp.build();
        WSEncryptionPart encP = new WSEncryptionPart("Timestamp", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "");
        builder.getParts().add(encP);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(wssCrypto, symmetricKey);
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)encryptedDoc, (String)"");
        Element encryptedTimestamp = XMLUtils.findElement((Node)securityHeader, (String)"EncryptedData", (String)"http://www.w3.org/2001/04/xmlenc#");
        Element cipherValue = XMLUtils.findElement((Node)encryptedTimestamp, (String)"CipherValue", (String)"http://www.w3.org/2001/04/xmlenc#");
        String cipherText = cipherValue.getTextContent();
        StringBuilder stringBuilder = new StringBuilder(cipherText);
        int index = stringBuilder.length() / 2;
        char ch = stringBuilder.charAt(index);
        ch = ch != 'A' ? (char)'A' : 'B';
        stringBuilder.setCharAt(index, ch);
        cipherValue.setTextContent(stringBuilder.toString());
        String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        WSSecurityEngine newEngine = new WSSecurityEngine();
        try {
            newEngine.processSecurityHeader(doc, null, (CallbackHandler)new KeystoreCallbackHandler(), wssCrypto);
            Assertions.fail((String)"Failure expected on a modified EncryptedData CipherValue");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
        }
    }

    @Test
    public void testModifiedEncryptedKeyCipherValue() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        Crypto wssCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(wssCrypto, symmetricKey);
        Element encryptedKey = XMLUtils.findElement((Node)doc.getDocumentElement(), (String)"EncryptedKey", (String)"http://www.w3.org/2001/04/xmlenc#");
        Element cipherValue = XMLUtils.findElement((Node)encryptedKey, (String)"CipherValue", (String)"http://www.w3.org/2001/04/xmlenc#");
        String cipherText = cipherValue.getTextContent();
        StringBuilder stringBuilder = new StringBuilder(cipherText);
        int index = stringBuilder.length() / 2;
        char ch = stringBuilder.charAt(index);
        ch = ch != 'A' ? (char)'A' : 'B';
        stringBuilder.setCharAt(index, ch);
        cipherValue.setTextContent(stringBuilder.toString());
        String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        WSSecurityEngine newEngine = new WSSecurityEngine();
        try {
            newEngine.processSecurityHeader(doc, null, (CallbackHandler)new KeystoreCallbackHandler(), wssCrypto);
            Assertions.fail((String)"Failure expected on a modified EncryptedData CipherValue");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
        }
    }

    @Test
    public void testModifiedSignatureReference() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        WSSecTimestamp timestamp = new WSSecTimestamp(secHeader);
        timestamp.setTimeToLive(300);
        timestamp.build();
        WSEncryptionPart encP = new WSEncryptionPart("Timestamp", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "");
        builder.getParts().add(encP);
        Document signedDoc = builder.build(this.crypto);
        Element timestampElement = timestamp.getElement();
        Element createdValue = XMLUtils.findElement((Node)timestampElement, (String)"Created", (String)"http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd");
        ZonedDateTime now = ZonedDateTime.now(ZoneOffset.UTC).plusSeconds(5L);
        createdValue.setTextContent(DateUtil.getDateTimeFormatter((boolean)true).format(now));
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc);
            Assertions.fail((String)"Failure expected on a modified Signature Reference");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
        }
    }

    @Test
    public void testUntrustedSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("wss40", "security");
        Crypto wss40Crypto = CryptoFactory.getInstance((String)"wss40.properties");
        Document signedDoc = builder.build(wss40Crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc);
            Assertions.fail((String)"Failure expected on an untrusted Certificate");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
        }
    }

    @Test
    public void testModifiedSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        Document signedDoc = builder.build(this.crypto);
        Element signatureElement = builder.getSignatureElement();
        Node firstChild = signatureElement.getFirstChild();
        while (!(firstChild instanceof Element) && firstChild != null) {
            firstChild = signatureElement.getNextSibling();
        }
        ((Element)firstChild).setAttributeNS(null, "Id", "xyz");
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        try {
            this.verify(signedDoc);
            Assertions.fail((String)"Failure expected on a modified Signature element");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILED_CHECK ? 1 : 0) != 0);
        }
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        return this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, this.crypto);
    }
}

