/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.dom.SOAPConstants;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SecretKeyCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.str.STRParser;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class EncryptionTest {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptionTest.class);
    private static final QName SOAP_BODY = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body");
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler keystoreCallbackHandler = new KeystoreCallbackHandler();
    private SecretKeyCallbackHandler secretKeyCallbackHandler = new SecretKeyCallbackHandler();
    private byte[] keyData;
    private SecretKey key;
    private Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");

    @BeforeEach
    public void setUp() throws Exception {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        this.key = keyGen.generateKey();
        this.keyData = this.key.getEncoded();
        this.secEngine.setWssConfig(WSSConfig.getNewInstance());
    }

    @Test
    public void testEncryptionDecryptionRSA15() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        LOG.info("Before Encryption Triple DES....");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(this.crypto, symmetricKey);
        LOG.info("After Encryption Triple DES....");
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message, RSA-15 keytransport, 3DES:");
            LOG.debug(outputString);
        }
        Assertions.assertFalse((boolean)outputString.contains("counter_port_type"));
        this.verify(encryptedDoc, this.keystoreCallbackHandler, SOAP_BODY);
        builder.getParts().clear();
        doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(2);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        WSEncryptionPart encP = new WSEncryptionPart("add", "http://ws.apache.org/counter/counter_port_type", "Element");
        builder.getParts().add(encP);
        LOG.info("Before Encryption AES 128/RSA-15....");
        keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        symmetricKey = keyGen.generateKey();
        encryptedDoc = builder.build(this.crypto, symmetricKey);
        LOG.info("After Encryption AES 128/RSA-15....");
        outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message, RSA-15 keytransport, AES 128:");
            LOG.debug(outputString);
        }
        Assertions.assertFalse((boolean)outputString.contains("counter_port_type"));
        WSHandlerResult results = this.verify(encryptedDoc, this.keystoreCallbackHandler, new QName("http://ws.apache.org/counter/counter_port_type", "add"));
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(4)).get(0);
        Assertions.assertNotNull((Object)actionResult.get((Object)"x509-certificate"));
        Assertions.assertNotNull((Object)actionResult.get((Object)"x509-reference-type"));
        STRParser.REFERENCE_TYPE referenceType = (STRParser.REFERENCE_TYPE)actionResult.get((Object)"x509-reference-type");
        Assertions.assertTrue((referenceType == STRParser.REFERENCE_TYPE.ISSUER_SERIAL ? 1 : 0) != 0);
    }

    @Test
    public void testEncryptionDecryptionOAEP() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(3);
        builder.setKeyEncAlgo("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        LOG.info("Before Encryption Triple DES/RSA-OAEP....");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(this.crypto, symmetricKey);
        LOG.info("After Encryption Triple DES/RSA-OAEP....");
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message, RSA-OAEP keytransport, 3DES:");
            LOG.debug(outputString);
        }
        Assertions.assertFalse((boolean)outputString.contains("counter_port_type"));
        WSSecurityEngine newEngine = new WSSecurityEngine();
        WSHandlerResult results = newEngine.processSecurityHeader(encryptedDoc, null, this.keystoreCallbackHandler, this.crypto);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(4)).get(0);
        Assertions.assertNotNull((Object)actionResult.get((Object)"x509-certificate"));
        Assertions.assertNotNull((Object)actionResult.get((Object)"x509-reference-type"));
        STRParser.REFERENCE_TYPE referenceType = (STRParser.REFERENCE_TYPE)actionResult.get((Object)"x509-reference-type");
        Assertions.assertTrue((referenceType == STRParser.REFERENCE_TYPE.KEY_IDENTIFIER ? 1 : 0) != 0);
    }

    @Test
    public void testEncryptionDecryptionPublicKey() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setKeyIdentifierType(13);
        builder.setKeyEncAlgo("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        X509Certificate[] certs = this.crypto.getX509Certificates(cryptoType);
        Assertions.assertNotNull((Object)certs);
        builder.setUseThisPublicKey(certs[0].getPublicKey());
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(this.crypto, symmetricKey);
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        Assertions.assertFalse((boolean)outputString.contains("counter_port_type"));
        WSSecurityEngine newEngine = new WSSecurityEngine();
        WSHandlerResult results = newEngine.processSecurityHeader(encryptedDoc, null, this.keystoreCallbackHandler, this.crypto);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(4)).get(0);
        Assertions.assertNotNull((Object)actionResult.get((Object)"public-key"));
    }

    @Test
    public void testEncryptionEncryption() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        Crypto encCrypto = CryptoFactory.getInstance();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e");
        LOG.info("Before Encryption....");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = encrypt.build(encCrypto, symmetricKey);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After the first encryption:");
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        Document encryptedEncryptedDoc = encrypt.build(encCrypto, symmetricKey);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After the second encryption:");
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedEncryptedDoc);
            LOG.debug(outputString);
        }
        LOG.info("After Encryption....");
        this.verify(encryptedEncryptedDoc, encCrypto, this.keystoreCallbackHandler);
    }

    @Test
    public void testX509EncryptionThumb() throws Exception {
        Crypto encCrypto = CryptoFactory.getInstance();
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(8);
        LOG.info("Before Encrypting ThumbprintSHA1....");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(encCrypto, symmetricKey);
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message with THUMBPRINT_IDENTIFIER:");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("#ThumbprintSHA1"));
        LOG.info("After Encrypting ThumbprintSHA1....");
        WSHandlerResult results = this.verify(encryptedDoc, encCrypto, this.keystoreCallbackHandler);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(4)).get(0);
        Assertions.assertNotNull((Object)actionResult.get((Object)"x509-certificate"));
        Assertions.assertNotNull((Object)actionResult.get((Object)"x509-reference-type"));
        STRParser.REFERENCE_TYPE referenceType = (STRParser.REFERENCE_TYPE)actionResult.get((Object)"x509-reference-type");
        Assertions.assertTrue((referenceType == STRParser.REFERENCE_TYPE.THUMBPRINT_SHA1 ? 1 : 0) != 0);
    }

    @Test
    public void testX509EncryptionSHA1() throws Exception {
        Crypto encCrypto = CryptoFactory.getInstance();
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(10);
        LOG.info("Before Encrypting EncryptedKeySHA1....");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(encCrypto, symmetricKey);
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message with ENCRYPTED_KEY_SHA1_IDENTIFIER:");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("#EncryptedKeySHA1"));
        LOG.info("After Encrypting EncryptedKeySHA1....");
        this.verify(encryptedDoc, encCrypto, this.keystoreCallbackHandler);
    }

    @Test
    public void testEncryptionSHA1Symmetric() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setKeyIdentifierType(10);
        builder.setEncryptSymmKey(false);
        LOG.info("Before Encrypting EncryptedKeySHA1....");
        Document encryptedDoc = builder.build(this.crypto, this.key);
        byte[] encodedBytes = KeyUtils.generateDigest((byte[])this.keyData);
        String identifier = XMLUtils.encodeToString((byte[])encodedBytes);
        this.secretKeyCallbackHandler.addSecretKey(identifier, this.keyData);
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message with ENCRYPTED_KEY_SHA1_IDENTIFIER:");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("#EncryptedKeySHA1"));
        LOG.info("After Encrypting EncryptedKeySHA1....");
        this.verify(encryptedDoc, null, this.secretKeyCallbackHandler);
    }

    @Test
    public void testEncryptionSHA1SymmetricBytesHandler() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, Object> messageContext = new TreeMap<String, Object>();
        messageContext.put("encryptSymmetricEncryptionKey", "false");
        messageContext.put("encryptionKeyIdentifier", "EncryptedKeySHA1");
        this.secretKeyCallbackHandler.setOutboundSecret(this.keyData);
        messageContext.put("passwordCallbackRef", this.secretKeyCallbackHandler);
        reqData.setMsgContext(messageContext);
        reqData.setUsername("");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(4));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc, null, this.secretKeyCallbackHandler);
    }

    @Test
    public void testEncryptionDecryptionRSA15STR() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        LOG.info("Before Encryption Triple DES....");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        builder.prepare(this.crypto, symmetricKey);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
        builder.getParts().add(encP);
        Element refs = builder.encrypt(symmetricKey);
        builder.addExternalRefElement(refs);
        builder.prependToHeader();
        builder.prependBSTElementToHeader();
        Document encryptedDoc = doc;
        LOG.info("After Encryption Triple DES....");
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message, RSA-15 keytransport, 3DES:");
            LOG.debug(outputString);
        }
        Assertions.assertFalse((boolean)outputString.contains("counter_port_type"));
        WSHandlerResult results = this.verify(encryptedDoc, this.crypto, this.keystoreCallbackHandler);
        outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        Assertions.assertTrue((boolean)outputString.contains("counter_port_type"));
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(4)).get(0);
        Assertions.assertNotNull((Object)actionResult.get((Object)"x509-certificate"));
        Assertions.assertNotNull((Object)actionResult.get((Object)"x509-reference-type"));
        STRParser.REFERENCE_TYPE referenceType = (STRParser.REFERENCE_TYPE)actionResult.get((Object)"x509-reference-type");
        Assertions.assertTrue((referenceType == STRParser.REFERENCE_TYPE.DIRECT_REF ? 1 : 0) != 0);
    }

    @Test
    public void testBadAttribute() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        builder.prepare(this.crypto, symmetricKey);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
        parts.add(encP);
        Element refs = builder.encrypt(symmetricKey);
        builder.addExternalRefElement(refs);
        Element encryptedKeyElement = builder.getEncryptedKeyElement();
        encryptedKeyElement.setAttributeNS(null, "Type", "SomeType");
        WSSecurityUtil.prependChildElement((Element)secHeader.getSecurityHeaderElement(), (Element)encryptedKeyElement);
        builder.prependBSTElementToHeader();
        Document encryptedDoc = doc;
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        WSSecurityEngine newEngine = new WSSecurityEngine();
        try {
            newEngine.processSecurityHeader(encryptedDoc, null, this.keystoreCallbackHandler, this.crypto);
            Assertions.fail((String)"Failure expected on a bad attribute type");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        RequestData data = new RequestData();
        data.setCallbackHandler(this.keystoreCallbackHandler);
        data.setDecCrypto(this.crypto);
        data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R3209));
        newEngine.processSecurityHeader(encryptedDoc, data);
    }

    @Test
    public void testEmbeddedEncryptedKey() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(4);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        builder.prepare(this.crypto, symmetricKey);
        builder.setEmbedEncryptedKey(true);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        ArrayList<WSEncryptionPart> parts = new ArrayList<WSEncryptionPart>();
        WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "Content");
        parts.add(encP);
        builder.encrypt(symmetricKey);
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc, this.crypto, this.keystoreCallbackHandler);
    }

    @Test
    public void testEncryptionDecryptionOAEPSHA256() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyEncAlgo("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        builder.setDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        LOG.info("Before Encryption Triple DES/RSA-OAEP....");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(this.crypto, symmetricKey);
        LOG.info("After Encryption Triple DES/RSA-OAEP....");
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message, RSA-OAEP keytransport, 3DES:");
            LOG.debug(outputString);
        }
        Assertions.assertFalse((boolean)outputString.contains("counter_port_type"));
        WSSecurityEngine newEngine = new WSSecurityEngine();
        WSHandlerResult results = newEngine.processSecurityHeader(encryptedDoc, null, this.keystoreCallbackHandler, this.crypto);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(4)).get(0);
        Assertions.assertNotNull((Object)actionResult);
    }

    @Test
    public void testEncryptionWithRegexpCert() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("regexp");
        builder.setKeyIdentifierType(2);
        builder.setKeyEncAlgo("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        LOG.info("Before Encryption Triple DES/RSA-OAEP....");
        Crypto regexpCrypto = CryptoFactory.getInstance((String)"regexp.properties");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(regexpCrypto, symmetricKey);
        LOG.info("After Encryption Triple DES/RSA-OAEP....");
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message, RSA-OAEP keytransport, 3DES:");
            LOG.debug(outputString);
        }
        Assertions.assertFalse((boolean)outputString.contains("counter_port_type"));
        WSSecurityEngine newEngine = new WSSecurityEngine();
        newEngine.processSecurityHeader(encryptedDoc, null, this.keystoreCallbackHandler, regexpCrypto);
    }

    private WSHandlerResult verify(Document doc, Crypto decCrypto, CallbackHandler handler) throws Exception {
        WSHandlerResult results = this.secEngine.processSecurityHeader(doc, null, handler, decCrypto);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        return results;
    }

    private WSHandlerResult verify(Document doc, CallbackHandler handler, QName expectedEncryptedElement) throws Exception {
        WSHandlerResult results = this.secEngine.processSecurityHeader(doc, null, handler, null, this.crypto);
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        Assertions.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        boolean encrypted = false;
        for (WSSecurityEngineResult result : results.getResults()) {
            Integer action = (Integer)result.get((Object)"action");
            Assertions.assertNotNull((Object)action);
            if ((action & 4) == 0) continue;
            List refs = (List)result.get((Object)"data-ref-uris");
            Assertions.assertNotNull((Object)refs);
            encrypted = true;
            for (WSDataRef ref : refs) {
                Assertions.assertNotNull((Object)ref.getName());
                Assertions.assertEquals((Object)expectedEncryptedElement, (Object)ref.getName());
                Assertions.assertNotNull((Object)ref.getProtectedElement());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("WSDataRef element: ");
                LOG.debug(DOM2Writer.nodeToString((Node)ref.getProtectedElement()));
            }
        }
        Assertions.assertTrue((boolean)encrypted);
        return results;
    }
}

