/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.SOAPConstants;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EncryptionPartsTest {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptionPartsTest.class);
    private static final String SOAPMSG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:foo=\"urn:foo.bar\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <soapenv:Header>       <foo:bar1>baz1</foo:bar1>       <foo:foobar>baz</foo:foobar>       <foo:bar2>baz2</foo:bar2>       <foo:with-attributes some-attribute=\"3\">baz</foo:with-attributes>   </soapenv:Header>   <soapenv:Body>      <ns1:testMethod xmlns:ns1=\"http://axis/service/security/test6/LogTestService8\"></ns1:testMethod>   </soapenv:Body></soapenv:Envelope>";
    private static final String SOAPMSG_MULTIPLE = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><soapenv:Envelope xmlns:foo=\"urn:foo.bar\" xmlns:soapenv=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\">   <soapenv:Header>       <foo:foobar>baz</foo:foobar>   </soapenv:Header>   <soapenv:Body>      <ns1:testMethod xmlns:ns1=\"http://axis/service/security/test6/LogTestService8\">asf1</ns1:testMethod>      <ns1:testMethod xmlns:ns1=\"http://axis/service/security/test6/LogTestService8\">asf2</ns1:testMethod>   </soapenv:Body></soapenv:Envelope>";
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance();

    public EncryptionPartsTest() throws Exception {
        WSSConfig.init();
    }

    @Test
    public void testSOAPHeader() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        encrypt.getParts().add(encP);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(encryptedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(4)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", (Object)actionResult.get((Object)"encrypted-key-transport-method"));
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/soapenv:Envelope/soapenv:Header/foo:foobar", (Object)xpath);
        Assertions.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#aes128-cbc", (Object)wsDataRef.getAlgorithm());
        QName expectedQName = new QName("urn:foo.bar", "foobar");
        Assertions.assertEquals((Object)expectedQName, (Object)wsDataRef.getName());
        Element encryptedElement = wsDataRef.getEncryptedElement();
        Assertions.assertNotNull((Object)encryptedElement);
        Assertions.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#", (Object)encryptedElement.getNamespaceURI());
    }

    @Test
    public void testOptionalSOAPHeaderPresent() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        encP.setRequired(false);
        encrypt.getParts().add(encP);
        String soapNamespace = WSSecurityUtil.getSOAPNamespace((Element)doc.getDocumentElement());
        encP = new WSEncryptionPart("Body", soapNamespace, "Content");
        encrypt.getParts().add(encP);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        this.verify(encryptedDoc);
    }

    @Test
    public void testOptionalSOAPHeaderNotPresent() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        encP.setRequired(false);
        encrypt.getParts().add(encP);
        String soapNamespace = WSSecurityUtil.getSOAPNamespace((Element)doc.getDocumentElement());
        encP = new WSEncryptionPart("Body", soapNamespace, "Content");
        encrypt.getParts().add(encP);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        this.verify(encryptedDoc);
    }

    @Test
    public void testRequiredSOAPHeaderNotPresent() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        encrypt.getParts().add(encP);
        String soapNamespace = WSSecurityUtil.getSOAPNamespace((Element)doc.getDocumentElement());
        encP = new WSEncryptionPart("Body", soapNamespace, "Content");
        encrypt.getParts().add(encP);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        try {
            encrypt.build(this.crypto, symmetricKey);
            Assertions.fail((String)"Failure expected on not encrypting a required element");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSOAPEncryptedHeader() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar", "Header");
        encrypt.getParts().add(encP);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
        String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("wsse11:EncryptedHeader"));
        Assertions.assertFalse((boolean)outputString.contains("foo:foobar"));
        WSHandlerResult results = this.verify(encryptedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(4)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", (Object)actionResult.get((Object)"encrypted-key-transport-method"));
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/soapenv:Envelope/soapenv:Header/foo:foobar", (Object)xpath);
    }

    @Test
    public void testSOAPEncryptedHeaderWithAttributes() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("with-attributes", "urn:foo.bar", "Header");
        encrypt.getParts().add(encP);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
        String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("wsse11:EncryptedHeader"));
        Assertions.assertFalse((boolean)outputString.contains("foo:with-attributes"));
        WSHandlerResult results = this.verify(encryptedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(4)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertEquals((Object)"http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p", (Object)actionResult.get((Object)"encrypted-key-transport-method"));
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        String xpath = wsDataRef.getXpath();
        Assertions.assertEquals((Object)"/soapenv:Envelope/soapenv:Header/foo:with-attributes", (Object)xpath);
    }

    @Test
    public void testBadLocalname() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("foobar2", "urn:foo.bar", "");
        encrypt.getParts().add(encP);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        try {
            encrypt.build(this.crypto, symmetricKey);
            Assertions.fail((String)"Failure expected on a bad localname");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
    }

    @Test
    public void testBadNamespace() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("foobar", "urn:foo.bar2", "");
        encrypt.getParts().add(encP);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        try {
            encrypt.build(this.crypto, symmetricKey);
            Assertions.fail((String)"Failure expected on a bad namespace");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
    }

    @Test
    public void testSOAPHeaderAndBody() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart(soapConstants.getBodyQName().getLocalPart(), soapConstants.getEnvelopeURI(), "");
        encrypt.getParts().add(encP);
        WSEncryptionPart encP2 = new WSEncryptionPart("foobar", "urn:foo.bar", "");
        encrypt.getParts().add(encP2);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(encryptedDoc);
        QName fooName = new QName("urn:foo.bar", "foobar");
        QName bodyName = new QName(soapConstants.getEnvelopeURI(), "Body");
        QName headerName = new QName(soapConstants.getEnvelopeURI(), "Header");
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(4)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        Assertions.assertTrue((refs != null && !refs.isEmpty() ? 1 : 0) != 0);
        boolean foundFoo = false;
        boolean foundBody = false;
        boolean foundHeader = false;
        for (WSDataRef ref : refs) {
            if (fooName.equals(ref.getName())) {
                foundFoo = true;
                continue;
            }
            if (bodyName.equals(ref.getName())) {
                foundBody = true;
                continue;
            }
            if (!headerName.equals(ref.getName())) continue;
            foundHeader = true;
        }
        Assertions.assertTrue((foundFoo && foundBody ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)foundHeader);
    }

    @Test
    public void testEncryptionPartDOMElement() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG);
        SOAPConstants soapConstants = WSSecurityUtil.getSOAPConstants((Element)doc.getDocumentElement());
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("Incorrect Localname", "Incorrect N/S", "");
        Element bodyElement = WSSecurityUtil.findBodyElement((Document)doc);
        Assertions.assertTrue((bodyElement != null && "Body".equals(bodyElement.getLocalName()) ? 1 : 0) != 0);
        encP.setElement(bodyElement);
        encrypt.getParts().add(encP);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
        String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        Assertions.assertTrue((!outputString.contains("testMethod") ? 1 : 0) != 0);
        WSHandlerResult results = this.verify(encryptedDoc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(4)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        List refs = (List)actionResult.get((Object)"data-ref-uris");
        WSDataRef wsDataRef = (WSDataRef)refs.get(0);
        QName bodyName = new QName(soapConstants.getEnvelopeURI(), "Body");
        Assertions.assertEquals((Object)bodyName, (Object)wsDataRef.getName());
    }

    @Test
    public void testMultipleElements() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)SOAPMSG_MULTIPLE);
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
        encrypt.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        encrypt.setKeyIdentifierType(2);
        WSEncryptionPart encP = new WSEncryptionPart("testMethod", "http://axis/service/security/test6/LogTestService8", "");
        encrypt.getParts().add(encP);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
        String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        Assertions.assertFalse((boolean)outputString.contains("testMethod"));
        this.verify(encryptedDoc);
        outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        Assertions.assertTrue((boolean)outputString.contains("asf1"));
        Assertions.assertTrue((boolean)outputString.contains("asf2"));
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        WSHandlerResult results = this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, null, this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verified and decrypted message:");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        return results;
    }
}

