/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.ArrayList;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.namespace.QName;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.util.DOM2Writer;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSDataRef;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;

public class EncryptionGCMTest {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptionGCMTest.class);
    private static final QName SOAP_BODY = new QName("http://schemas.xmlsoap.org/soap/envelope/", "Body");
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler keystoreCallbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto;
    private boolean isIBMJdK = System.getProperty("java.vendor").contains("IBM");

    public EncryptionGCMTest() throws Exception {
        this.crypto = CryptoFactory.getInstance((String)"wss40.properties");
    }

    @BeforeEach
    public void setUp() throws Exception {
        this.secEngine.setWssConfig(WSSConfig.getNewInstance());
    }

    @Test
    public void testAES128GCM() throws Exception {
        Assumptions.assumeFalse((boolean)this.isIBMJdK);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2009/xmlenc11#aes128-gcm");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2009/xmlenc11#aes128-gcm");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(this.crypto, symmetricKey);
        String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message:");
            LOG.debug(outputString);
        }
        Assertions.assertFalse((boolean)outputString.contains("counter_port_type"));
        this.verify(encryptedDoc, this.keystoreCallbackHandler, SOAP_BODY);
    }

    @Test
    public void testAES256GCM() throws Exception {
        Assumptions.assumeFalse((boolean)this.isIBMJdK);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2009/xmlenc11#aes256-gcm");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2009/xmlenc11#aes256-gcm");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(this.crypto, symmetricKey);
        String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message:");
            LOG.debug(outputString);
        }
        Assertions.assertFalse((boolean)outputString.contains("counter_port_type"));
        this.verify(encryptedDoc, this.keystoreCallbackHandler, SOAP_BODY);
    }

    @Test
    public void testAES192GCM_RSAOAEP_SHA256_MGFSHA256() throws Exception {
        Assumptions.assumeFalse((boolean)this.isIBMJdK);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2009/xmlenc11#aes192-gcm");
        builder.setKeyEncAlgo("http://www.w3.org/2009/xmlenc11#rsa-oaep");
        builder.setDigestAlgorithm("http://www.w3.org/2001/04/xmlenc#sha256");
        builder.setMGFAlgorithm("http://www.w3.org/2009/xmlenc11#mgf1sha256");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2009/xmlenc11#aes192-gcm");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(this.crypto, symmetricKey);
        String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message:");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((outputString.indexOf("http://www.w3.org/2009/xmlenc11#rsa-oaep") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((outputString.indexOf("http://www.w3.org/2001/04/xmlenc#sha256") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((outputString.indexOf("http://www.w3.org/2009/xmlenc11#aes192-gcm") > 0 ? 1 : 0) != 0);
        Assertions.assertTrue((outputString.indexOf("http://www.w3.org/2009/xmlenc11#mgf1sha256") > 0 ? 1 : 0) != 0);
        Assertions.assertFalse((boolean)outputString.contains("counter_port_type"));
        this.verify(encryptedDoc, this.keystoreCallbackHandler, SOAP_BODY);
    }

    private void verify(Document doc, CallbackHandler handler, QName expectedEncryptedElement) throws Exception {
        RequestData requestData = new RequestData();
        ArrayList<BSPRule> bspRules = new ArrayList<BSPRule>();
        bspRules.add(BSPRule.R5621);
        bspRules.add(BSPRule.R5620);
        requestData.setIgnoredBSPRules(bspRules);
        requestData.setCallbackHandler(handler);
        requestData.setDecCrypto(this.crypto);
        WSHandlerResult results = this.secEngine.processSecurityHeader(doc, requestData);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        Assertions.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        boolean encrypted = false;
        for (WSSecurityEngineResult result : results.getResults()) {
            Integer action = (Integer)result.get((Object)"action");
            Assertions.assertNotNull((Object)action);
            if ((action & 4) == 0) continue;
            List refs = (List)result.get((Object)"data-ref-uris");
            Assertions.assertNotNull((Object)refs);
            encrypted = true;
            for (WSDataRef ref : refs) {
                Assertions.assertNotNull((Object)ref.getName());
                Assertions.assertEquals((Object)expectedEncryptedElement, (Object)ref.getName());
                Assertions.assertNotNull((Object)ref.getProtectedElement());
                if (!LOG.isDebugEnabled()) continue;
                LOG.debug("WSDataRef element: ");
                LOG.debug(DOM2Writer.nodeToString((Node)ref.getProtectedElement()));
            }
        }
        Assertions.assertTrue((boolean)encrypted);
    }
}

