/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.Collections;
import java.util.TreeMap;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.EncryptionActionToken;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Disabled;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class EncryptionCRLTest {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptionCRLTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler keystoreCallbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance((String)"wss40All.properties");

    @BeforeEach
    public void setUp() throws Exception {
        this.secEngine.setWssConfig(WSSConfig.getNewInstance());
    }

    @Test
    public void testEncryptionWithOutRevocationCheck() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        EncryptionActionToken actionToken = new EncryptionActionToken();
        actionToken.setUser("wss40rev");
        actionToken.setKeyIdentifierId(1);
        actionToken.setSymmetricAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        actionToken.setCrypto(this.crypto);
        reqData.setEncryptionToken(actionToken);
        TreeMap<String, CallbackHandler> messageContext = new TreeMap<String, CallbackHandler>();
        messageContext.put("passwordCallbackRef", this.keystoreCallbackHandler);
        reqData.setMsgContext(messageContext);
        reqData.setUsername("wss40rev");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        handler.send(doc, reqData, Collections.singletonList(new HandlerAction(Integer.valueOf(4))), true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc, this.crypto, this.keystoreCallbackHandler);
    }

    @Test
    @Disabled
    public void testEncryptionWithRevocationCheck() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        EncryptionActionToken actionToken = new EncryptionActionToken();
        actionToken.setUser("wss40rev");
        actionToken.setKeyIdentifierId(1);
        actionToken.setSymmetricAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        actionToken.setCrypto(this.crypto);
        reqData.setEncryptionToken(actionToken);
        TreeMap<String, CallbackHandler> messageContext = new TreeMap<String, CallbackHandler>();
        messageContext.put("passwordCallbackRef", this.keystoreCallbackHandler);
        reqData.setMsgContext(messageContext);
        reqData.setUsername("wss40rev");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        handler.setOption("enableRevocation", "true");
        try {
            handler.send(doc, reqData, Collections.singletonList(new HandlerAction(Integer.valueOf(4))), true);
            Assertions.fail((String)"Failure expected on a revoked certificate");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
    }

    private void verify(Document doc, Crypto decCrypto, CallbackHandler handler) throws Exception {
        this.secEngine.processSecurityHeader(doc, null, handler, decCrypto);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
    }
}

