/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.AlgorithmSuite;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SecretKeyCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class EncryptionAlgorithmSuiteTest {
    private static final Logger LOG = LoggerFactory.getLogger(EncryptionAlgorithmSuiteTest.class);
    private Crypto crypto;

    public EncryptionAlgorithmSuiteTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance((String)"wss40.properties");
    }

    @Test
    public void testEncryption() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(this.crypto, symmetricKey);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)encryptedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        this.verify(securityHeader, algorithmSuite, this.crypto);
        algorithmSuite.setMinimumAsymmetricKeyLength(1024);
        try {
            this.verify(securityHeader, algorithmSuite, this.crypto);
            Assertions.fail((String)"Expected failure as 512-bit keys are not allowed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
    }

    @Test
    public void testEncryptionKeyTransportRSA15() throws Exception {
        Crypto wssCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        builder.setKeyEncAlgo("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(this.crypto, symmetricKey);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)encryptedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        try {
            this.verify(securityHeader, algorithmSuite, wssCrypto);
            Assertions.fail((String)"Expected failure as RSA 15 is not allowed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        algorithmSuite.addKeyWrapAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        this.verify(securityHeader, algorithmSuite, wssCrypto);
    }

    @Test
    public void testEncryptionKeyTransportRSA15NoAlgorithmSuite() throws Exception {
        Crypto wssCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        builder.setKeyEncAlgo("http://www.w3.org/2001/04/xmlenc#rsa-1_5");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(this.crypto, symmetricKey);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)encryptedDoc, null);
        try {
            this.verify(securityHeader, null, wssCrypto);
            Assertions.fail((String)"Expected failure as RSA 15 is not allowed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setDecCrypto(wssCrypto);
        data.setAllowRSA15KeyTransportAlgorithm(true);
        data.setCallbackHandler((CallbackHandler)new KeystoreCallbackHandler());
        secEngine.processSecurityHeader(securityHeader, data);
    }

    @Test
    public void testEncryptionMethodAES128() throws Exception {
        Crypto wssCrypto = CryptoFactory.getInstance((String)"wss40.properties");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setUserInfo("wss40");
        builder.setKeyIdentifierType(1);
        builder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        Document encryptedDoc = builder.build(this.crypto, symmetricKey);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)encryptedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        try {
            this.verify(securityHeader, algorithmSuite, wssCrypto);
            Assertions.fail((String)"Expected failure as AES 128 is not allowed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        algorithmSuite.addEncryptionMethod("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        this.verify(securityHeader, algorithmSuite, wssCrypto);
    }

    @Test
    public void testSymmetricEncryption() throws Exception {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        SecretKey key = keyGen.generateKey();
        byte[] keyData = key.getEncoded();
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncrypt builder = new WSSecEncrypt(secHeader);
        builder.setKeyIdentifierType(10);
        builder.setEncryptSymmKey(false);
        Document encryptedDoc = builder.build(this.crypto, key);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
            LOG.debug(outputString);
        }
        byte[] encodedBytes = KeyUtils.generateDigest((byte[])keyData);
        String identifier = XMLUtils.encodeToString((byte[])encodedBytes);
        SecretKeyCallbackHandler secretKeyCallbackHandler = new SecretKeyCallbackHandler();
        secretKeyCallbackHandler.addSecretKey(identifier, keyData);
        Element securityHeader = WSSecurityUtil.getSecurityHeader((Document)encryptedDoc, null);
        AlgorithmSuite algorithmSuite = this.createAlgorithmSuite();
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setDecCrypto(this.crypto);
        data.setCallbackHandler((CallbackHandler)secretKeyCallbackHandler);
        data.setAlgorithmSuite(algorithmSuite);
        algorithmSuite.addEncryptionMethod("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        secEngine.processSecurityHeader(securityHeader, data);
        algorithmSuite.setMinimumSymmetricKeyLength(256);
        try {
            secEngine.processSecurityHeader(securityHeader, data);
            Assertions.fail((String)"Expected failure as a 128 bit key is not allowed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        algorithmSuite.setMinimumSymmetricKeyLength(64);
        algorithmSuite.setMaximumSymmetricKeyLength(120);
        try {
            secEngine.processSecurityHeader(securityHeader, data);
            Assertions.fail((String)"Expected failure as a 128 bit key is not allowed");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
    }

    private AlgorithmSuite createAlgorithmSuite() {
        AlgorithmSuite algorithmSuite = new AlgorithmSuite();
        algorithmSuite.setMinimumAsymmetricKeyLength(512);
        algorithmSuite.addKeyWrapAlgorithm("http://www.w3.org/2001/04/xmlenc#rsa-oaep-mgf1p");
        algorithmSuite.addEncryptionMethod("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        return algorithmSuite;
    }

    private WSHandlerResult verify(Element securityHeader, AlgorithmSuite algorithmSuite, Crypto decCrypto) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        RequestData data = new RequestData();
        data.setDecCrypto(decCrypto);
        data.setAlgorithmSuite(algorithmSuite);
        data.setCallbackHandler((CallbackHandler)new KeystoreCallbackHandler());
        return secEngine.processSecurityHeader(securityHeader, data);
    }
}

