/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.token.SecurityTokenReference;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecDKEncrypt;
import org.apache.wss4j.dom.message.WSSecDKSign;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class DerivedKeyTest {
    private static final Logger LOG = LoggerFactory.getLogger(DerivedKeyTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");

    public DerivedKeyTest() throws Exception {
        WSSConfig.init();
    }

    @Test
    public void testEncryptionDecryptionTRIPLEDES() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey(secHeader);
        encrKeyBuilder.setUserInfo("wss40");
        encrKeyBuilder.setKeyIdentifierType(8);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        encrKeyBuilder.prepare(this.crypto, symmetricKey);
        byte[] ek = symmetricKey.getEncoded();
        String tokenIdentifier = encrKeyBuilder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#tripledes-cbc");
        encrBuilder.setTokenIdentifier(tokenIdentifier);
        Document encryptedDoc = encrBuilder.build(ek);
        encrKeyBuilder.prependToHeader();
        encrKeyBuilder.prependBSTElementToHeader();
        String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message: 3DES  + DerivedKeys");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("http://www.w3.org/2001/04/xmlenc#tripledes-cbc"));
        this.verify(doc);
    }

    @Test
    public void testEncryptionDecryptionAES128() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey(secHeader);
        encrKeyBuilder.setUserInfo("wss40");
        encrKeyBuilder.setKeyIdentifierType(8);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        encrKeyBuilder.prepare(this.crypto, symmetricKey);
        byte[] ek = symmetricKey.getEncoded();
        String tokenIdentifier = encrKeyBuilder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setTokenIdentifier(tokenIdentifier);
        Document encryptedDoc = encrBuilder.build(ek);
        encrKeyBuilder.prependToHeader();
        encrKeyBuilder.prependBSTElementToHeader();
        String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message: AES  + DerivedKeys");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("http://www.w3.org/2001/04/xmlenc#aes128-cbc"));
        this.verify(doc);
    }

    @Test
    public void testEncryptionDecryptionAES256() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey(secHeader);
        encrKeyBuilder.setUserInfo("wss40");
        encrKeyBuilder.setKeyIdentifierType(8);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        encrKeyBuilder.prepare(this.crypto, symmetricKey);
        byte[] ek = symmetricKey.getEncoded();
        String tokenIdentifier = encrKeyBuilder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        encrBuilder.setTokenIdentifier(tokenIdentifier);
        Document encryptedDoc = encrBuilder.build(ek);
        encrKeyBuilder.prependToHeader();
        encrKeyBuilder.prependBSTElementToHeader();
        String outputString = XMLUtils.prettyDocumentToString((Document)encryptedDoc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message: AES  + DerivedKeys");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("http://www.w3.org/2001/04/xmlenc#aes256-cbc"));
        this.verify(doc);
    }

    @Test
    public void testSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey(secHeader);
        encrKeyBuilder.setUserInfo("wss40");
        encrKeyBuilder.setKeyIdentifierType(8);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        encrKeyBuilder.prepare(this.crypto, symmetricKey);
        byte[] ek = symmetricKey.getEncoded();
        String tokenIdentifier = encrKeyBuilder.getId();
        WSSecDKSign sigBuilder = new WSSecDKSign(secHeader);
        sigBuilder.setTokenIdentifier(tokenIdentifier);
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sigBuilder.build(ek);
        encrKeyBuilder.prependToHeader();
        encrKeyBuilder.prependBSTElementToHeader();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message: 3DES  + DerivedKeys");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(doc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        Assertions.assertNotNull((Object)actionResult.get((Object)"secret"));
    }

    @Test
    public void testSignatureThumbprintSHA1() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        SecurityTokenReference secToken = new SecurityTokenReference(doc);
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        X509Certificate[] certs = this.crypto.getX509Certificates(cryptoType);
        secToken.setKeyIdentifierThumb(certs[0]);
        WSSecDKSign sigBuilder = new WSSecDKSign(secHeader);
        PrivateKey key = this.crypto.getPrivateKey("wss40", "security");
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sigBuilder.setStrElem(secToken.getElement());
        sigBuilder.build(key.getEncoded());
        sigBuilder.prependDKElementToHeader();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message: ThumbprintSHA1 + DerivedKeys");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(doc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        Assertions.assertNotNull((Object)actionResult.get((Object)"secret"));
    }

    @Test
    public void testSignatureSKI() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        SecurityTokenReference secToken = new SecurityTokenReference(doc);
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        X509Certificate[] certs = this.crypto.getX509Certificates(cryptoType);
        secToken.setKeyIdentifierSKI(certs[0], this.crypto);
        WSSecDKSign sigBuilder = new WSSecDKSign(secHeader);
        PrivateKey key = this.crypto.getPrivateKey("wss40", "security");
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        sigBuilder.setStrElem(secToken.getElement());
        sigBuilder.build(key.getEncoded());
        sigBuilder.prependDKElementToHeader();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message: SKI + DerivedKeys");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(doc);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)results.getActionResults().get(2)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Assertions.assertFalse((boolean)actionResult.isEmpty());
        Assertions.assertNotNull((Object)actionResult.get((Object)"secret"));
    }

    @Test
    public void testSignatureEncrypt() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey(secHeader);
        encrKeyBuilder.setUserInfo("wss40");
        encrKeyBuilder.setKeyIdentifierType(8);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        encrKeyBuilder.prepare(this.crypto, symmetricKey);
        byte[] ek = symmetricKey.getEncoded();
        String tokenIdentifier = encrKeyBuilder.getId();
        WSSecDKSign sigBuilder = new WSSecDKSign(secHeader);
        sigBuilder.setTokenIdentifier(tokenIdentifier);
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        LOG.info("Before HMAC-SHA1 signature");
        sigBuilder.build(ek);
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setTokenIdentifier(tokenIdentifier);
        Document signedEncryptedDoc = encrBuilder.build(ek);
        encrKeyBuilder.prependToHeader();
        encrKeyBuilder.prependBSTElementToHeader();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message: 3DES  + DerivedKeys");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedEncryptedDoc);
            LOG.debug(outputString);
        }
        this.verify(signedEncryptedDoc);
    }

    @Test
    public void testEncryptSignature() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecEncryptedKey encrKeyBuilder = new WSSecEncryptedKey(secHeader);
        encrKeyBuilder.setUserInfo("wss40");
        encrKeyBuilder.setKeyIdentifierType(8);
        KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        SecretKey symmetricKey = keyGen.generateKey();
        encrKeyBuilder.prepare(this.crypto, symmetricKey);
        byte[] ek = symmetricKey.getEncoded();
        String tokenIdentifier = encrKeyBuilder.getId();
        WSSecDKEncrypt encrBuilder = new WSSecDKEncrypt(secHeader);
        encrBuilder.setSymmetricEncAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        encrBuilder.setTokenIdentifier(tokenIdentifier);
        encrBuilder.build(ek);
        WSSecDKSign sigBuilder = new WSSecDKSign(secHeader);
        sigBuilder.setTokenIdentifier(tokenIdentifier);
        sigBuilder.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        LOG.info("Before HMAC-SHA1 signature");
        Document encryptedSignedDoc = sigBuilder.build(ek);
        encrKeyBuilder.prependToHeader();
        encrKeyBuilder.prependBSTElementToHeader();
        if (LOG.isDebugEnabled()) {
            LOG.debug("Encrypted message: 3DES  + DerivedKeys");
            String outputString = XMLUtils.prettyDocumentToString((Document)encryptedSignedDoc);
            LOG.debug(outputString);
        }
        this.verify(encryptedSignedDoc);
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        WSHandlerResult results = this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, this.crypto);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        return results;
    }
}

