/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SecretKeyCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class DerivedKeyActionTest {
    private static final Logger LOG = LoggerFactory.getLogger(DerivedKeyActionTest.class);
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");

    public DerivedKeyActionTest() throws Exception {
        WSSConfig.init();
    }

    @Test
    public void testSignatureThumbprintSHA1() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signaturePropFile", "wss40.properties");
        config.put("passwordCallbackRef", this.callbackHandler);
        config.put("derivedTokenKeyIdentifier", "Thumbprint");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(32768));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc);
    }

    @Test
    public void testSignatureThumbprintSHA1OldNamespace() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signaturePropFile", "wss40.properties");
        config.put("passwordCallbackRef", this.callbackHandler);
        config.put("derivedTokenKeyIdentifier", "Thumbprint");
        config.put("use200512Namespace", "false");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(32768));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)outputString.contains("http://schemas.xmlsoap.org/ws/2005/02/sc"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc);
    }

    @Test
    public void testSignatureThumbprintSHA1StrongDigest() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signaturePropFile", "wss40.properties");
        config.put("passwordCallbackRef", this.callbackHandler);
        config.put("signatureDigestAlgorithm", "http://www.w3.org/2001/04/xmlenc#sha256");
        config.put("derivedTokenKeyIdentifier", "Thumbprint");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(32768));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc);
    }

    @Test
    public void testSignatureThumbprintDifferentKeyLength() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signaturePropFile", "wss40.properties");
        config.put("passwordCallbackRef", this.callbackHandler);
        config.put("derivedTokenKeyIdentifier", "Thumbprint");
        config.put("derivedSignatureKeyLength", "16");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(32768));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc);
    }

    @Test
    public void testSignatureSKI() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signaturePropFile", "wss40.properties");
        config.put("passwordCallbackRef", this.callbackHandler);
        config.put("derivedTokenKeyIdentifier", "SKIKeyIdentifier");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(32768));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc);
    }

    @Test
    public void testSignatureX509() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signaturePropFile", "wss40.properties");
        config.put("passwordCallbackRef", this.callbackHandler);
        config.put("derivedTokenReference", "DirectReference");
        config.put("derivedTokenKeyIdentifier", "X509KeyIdentifier");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(32768));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc);
    }

    @Test
    public void testSignatureEncryptedKeyThumbprintSHA1() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signaturePropFile", "wss40.properties");
        config.put("passwordCallbackRef", this.callbackHandler);
        config.put("derivedTokenReference", "EncryptedKey");
        config.put("derivedTokenKeyIdentifier", "Thumbprint");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(32768));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc);
    }

    @Test
    public void testSignatureSCT() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        SecretKeyCallbackHandler secretKeyCallbackHandler = new SecretKeyCallbackHandler();
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        SecretKey key = keyGen.generateKey();
        byte[] keyData = key.getEncoded();
        secretKeyCallbackHandler.setOutboundSecret(keyData);
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("passwordCallbackRef", secretKeyCallbackHandler);
        config.put("derivedTokenReference", "SecurityContextToken");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(32768));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc, secretKeyCallbackHandler);
    }

    @Test
    public void testEncryptionThumbprintSHA1() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("encryptionPropFile", "wss40.properties");
        config.put("passwordCallbackRef", this.callbackHandler);
        config.put("derivedTokenReference", "EncryptedKey");
        config.put("derivedTokenKeyIdentifier", "Thumbprint");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(65536));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc);
    }

    @Test
    public void testEncryptionThumbprintAES256() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("encryptionPropFile", "wss40.properties");
        config.put("passwordCallbackRef", this.callbackHandler);
        config.put("derivedTokenReference", "EncryptedKey");
        config.put("derivedTokenKeyIdentifier", "Thumbprint");
        config.put("encryptionSymAlgorithm", "http://www.w3.org/2001/04/xmlenc#aes256-cbc");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(65536));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512"));
        Assertions.assertTrue((boolean)outputString.contains("http://www.w3.org/2001/04/xmlenc#aes256-cbc"));
        Assertions.assertFalse((boolean)outputString.contains("http://www.w3.org/2001/04/xmlenc#aes128-cbc"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc);
    }

    @Test
    public void testEncryptionSCT() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        SecretKeyCallbackHandler secretKeyCallbackHandler = new SecretKeyCallbackHandler();
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        SecretKey key = keyGen.generateKey();
        byte[] keyData = key.getEncoded();
        secretKeyCallbackHandler.setOutboundSecret(keyData);
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("passwordCallbackRef", secretKeyCallbackHandler);
        config.put("derivedTokenReference", "SecurityContextToken");
        config.put("derivedTokenKeyIdentifier", "Thumbprint");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(65536));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc, secretKeyCallbackHandler);
    }

    @Test
    public void testSignatureEncryptionThumbprintSHA1() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signaturePropFile", "wss40.properties");
        config.put("encryptionPropFile", "wss40.properties");
        config.put("passwordCallbackRef", this.callbackHandler);
        config.put("derivedTokenReference", "EncryptedKey");
        config.put("derivedTokenKeyIdentifier", "Thumbprint");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(32768)));
        actions.add(new HandlerAction(Integer.valueOf(65536)));
        handler.send(doc, reqData, actions, true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc);
    }

    @Test
    public void testEncryptionSignatureThumbprintSHA1() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signaturePropFile", "wss40.properties");
        config.put("encryptionPropFile", "wss40.properties");
        config.put("passwordCallbackRef", this.callbackHandler);
        config.put("derivedTokenReference", "EncryptedKey");
        config.put("derivedTokenKeyIdentifier", "Thumbprint");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(65536)));
        actions.add(new HandlerAction(Integer.valueOf(32768)));
        handler.send(doc, reqData, actions, true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc);
    }

    @Test
    public void testSignatureEncryptionSecurityContextToken() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        SecretKeyCallbackHandler secretKeyCallbackHandler = new SecretKeyCallbackHandler();
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        SecretKey key = keyGen.generateKey();
        byte[] keyData = key.getEncoded();
        secretKeyCallbackHandler.setOutboundSecret(keyData);
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("passwordCallbackRef", secretKeyCallbackHandler);
        config.put("derivedTokenReference", "SecurityContextToken");
        config.put("derivedTokenKeyIdentifier", "Thumbprint");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(32768)));
        actions.add(new HandlerAction(Integer.valueOf(65536)));
        handler.send(doc, reqData, actions, true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc, secretKeyCallbackHandler);
    }

    @Test
    public void testEncryptionSignatureSecurityContextToken() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        SecretKeyCallbackHandler secretKeyCallbackHandler = new SecretKeyCallbackHandler();
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        SecretKey key = keyGen.generateKey();
        byte[] keyData = key.getEncoded();
        secretKeyCallbackHandler.setOutboundSecret(keyData);
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("passwordCallbackRef", secretKeyCallbackHandler);
        config.put("derivedTokenReference", "SecurityContextToken");
        config.put("derivedTokenKeyIdentifier", "Thumbprint");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(65536)));
        actions.add(new HandlerAction(Integer.valueOf(32768)));
        handler.send(doc, reqData, actions, true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((boolean)outputString.contains("http://docs.oasis-open.org/ws-sx/ws-secureconversation/200512"));
        if (LOG.isDebugEnabled()) {
            LOG.debug(outputString);
        }
        this.verify(doc, secretKeyCallbackHandler);
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        return this.verify(doc, this.callbackHandler);
    }

    private WSHandlerResult verify(Document doc, CallbackHandler cbHandler) throws Exception {
        WSSecurityEngine secEngine = new WSSecurityEngine();
        WSHandlerResult results = secEngine.processSecurityHeader(doc, null, cbHandler, this.crypto);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        Assertions.assertTrue((outputString.indexOf("counter_port_type") > 0 ? 1 : 0) != 0);
        return results;
    }
}

