/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.message;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.Attachment;
import org.apache.wss4j.common.ext.AttachmentRequestCallback;
import org.apache.wss4j.common.ext.AttachmentResultCallback;

public class AttachmentCallbackHandler
implements CallbackHandler {
    private final List<Attachment> originalRequestAttachments;
    private Map<String, Attachment> attachmentMap = new HashMap<String, Attachment>();
    private List<Attachment> responseAttachments = new ArrayList<Attachment>();

    public AttachmentCallbackHandler() {
        this.originalRequestAttachments = Collections.emptyList();
    }

    public AttachmentCallbackHandler(List<Attachment> attachments) {
        this.originalRequestAttachments = attachments;
        if (attachments != null) {
            for (Attachment attachment : attachments) {
                this.attachmentMap.put(attachment.getId(), attachment);
            }
        }
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof AttachmentRequestCallback) {
                AttachmentRequestCallback attachmentRequestCallback = (AttachmentRequestCallback)callback;
                List<Attachment> attachments = this.getAttachmentsToAdd(attachmentRequestCallback.getAttachmentId());
                if (attachments.isEmpty()) {
                    throw new RuntimeException("wrong attachment requested");
                }
                attachmentRequestCallback.setAttachments(attachments);
                continue;
            }
            if (callback instanceof AttachmentResultCallback) {
                AttachmentResultCallback attachmentResultCallback = (AttachmentResultCallback)callback;
                this.responseAttachments.add(attachmentResultCallback.getAttachment());
                this.attachmentMap.put(attachmentResultCallback.getAttachment().getId(), attachmentResultCallback.getAttachment());
                continue;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
        }
    }

    public List<Attachment> getResponseAttachments() {
        return this.responseAttachments;
    }

    private List<Attachment> getAttachmentsToAdd(String id) {
        ArrayList<Attachment> attachments = new ArrayList<Attachment>();
        if (this.attachmentMap.containsKey(id)) {
            attachments.add(this.attachmentMap.get(id));
        } else if (this.originalRequestAttachments != null) {
            attachments.addAll(this.originalRequestAttachments);
        }
        return attachments;
    }
}

