/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.TreeMap;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class UseReqSigCertTest {
    private static final Logger LOG = LoggerFactory.getLogger(UseReqSigCertTest.class);

    public UseReqSigCertTest() throws Exception {
        WSSConfig.init();
    }

    @Test
    public void testIncludedCertificate() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signaturePropFile", "wss40.properties");
        config.put("signatureKeyIdentifier", "DirectReference");
        config.put("passwordCallbackRef", new KeystoreCallbackHandler());
        config.put("signatureParts", "{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(2)));
        actions.add(new HandlerAction(Integer.valueOf(32)));
        handler.send(doc, reqData, actions, true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message:");
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.processRequest(doc);
        ArrayList<WSHandlerResult> handlerResults = new ArrayList<WSHandlerResult>();
        handlerResults.add(0, results);
        this.sendResponse(handlerResults);
    }

    @Test
    public void testIssuerSerial() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signaturePropFile", "wss40.properties");
        config.put("signatureKeyIdentifier", "IssuerSerial");
        config.put("passwordCallbackRef", new KeystoreCallbackHandler());
        config.put("signatureParts", "{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(2)));
        actions.add(new HandlerAction(Integer.valueOf(32)));
        handler.send(doc, reqData, actions, true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message:");
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.processRequest(doc);
        ArrayList<WSHandlerResult> handlerResults = new ArrayList<WSHandlerResult>();
        handlerResults.add(0, results);
        this.sendResponse(handlerResults);
    }

    @Test
    public void testSKIKeyIdentifier() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        reqData.setUsername("wss40");
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("signaturePropFile", "wss40.properties");
        config.put("signatureKeyIdentifier", "SKIKeyIdentifier");
        config.put("passwordCallbackRef", new KeystoreCallbackHandler());
        config.put("signatureParts", "{}{http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd}Timestamp");
        reqData.setMsgContext(config);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(2)));
        actions.add(new HandlerAction(Integer.valueOf(32)));
        handler.send(doc, reqData, actions, true);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message:");
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.processRequest(doc);
        ArrayList<WSHandlerResult> handlerResults = new ArrayList<WSHandlerResult>();
        handlerResults.add(0, results);
        this.sendResponse(handlerResults);
    }

    private WSHandlerResult processRequest(Document doc) throws WSSecurityException {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, String> config = new TreeMap<String, String>();
        config.put("signatureVerificationPropFile", "wss40.properties");
        reqData.setMsgContext(config);
        CustomHandler handler = new CustomHandler();
        ArrayList<Integer> receivedActions = new ArrayList<Integer>();
        receivedActions.add(2);
        receivedActions.add(32);
        handler.receive(receivedActions, reqData);
        WSSecurityEngine securityEngine = new WSSecurityEngine();
        return securityEngine.processSecurityHeader(doc, reqData);
    }

    private void sendResponse(List<WSHandlerResult> handlerResults) throws Exception {
        RequestData reqData = new RequestData();
        TreeMap<String, Object> config = new TreeMap<String, Object>();
        config.put("encryptionUser", "useReqSigCert");
        config.put("RECV_RESULTS", handlerResults);
        reqData.setMsgContext(config);
        ArrayList<Integer> actions = new ArrayList<Integer>();
        actions.add(4);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(4));
        handler.send(doc, reqData, Collections.singletonList(action), true);
    }
}

