/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.bsp.BSPRule;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SAML2CallbackHandler;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.token.SignatureConfirmation;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class SignatureConfirmationTest {
    private static final Logger LOG = LoggerFactory.getLogger(SignatureConfirmationTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto = CryptoFactory.getInstance();

    @Test
    public void testRequestSavedSignature() throws Exception {
        Set savedSignatures;
        RequestData reqData = new RequestData();
        Map msgContext = new TreeMap<String, String>();
        msgContext.put("enableSignatureConfirmation", "true");
        msgContext.put("signaturePropFile", "crypto.properties");
        msgContext.put("password", "security");
        reqData.setMsgContext(msgContext);
        reqData.setUsername("16c73ab6-b892-458f-abf5-2f875f74882e");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(2));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        Assertions.assertTrue(((savedSignatures = (Set)(msgContext = (Map)reqData.getMsgContext()).get("_sendSignatureValues_")) != null && savedSignatures.size() == 1 ? 1 : 0) != 0);
        Integer signatureValue = (Integer)savedSignatures.iterator().next();
        Assertions.assertTrue((signatureValue != null && signatureValue != 0 ? 1 : 0) != 0);
    }

    @Test
    public void testRequestNotSavedSignature() throws Exception {
        RequestData reqData = new RequestData();
        Map msgContext = new TreeMap<String, String>();
        msgContext.put("enableSignatureConfirmation", "false");
        msgContext.put("signaturePropFile", "crypto.properties");
        msgContext.put("password", "security");
        reqData.setMsgContext(msgContext);
        reqData.setUsername("16c73ab6-b892-458f-abf5-2f875f74882e");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(2));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        msgContext = (Map)reqData.getMsgContext();
        Set savedSignatures = (Set)msgContext.get("_sendSignatureValues_");
        Assertions.assertNull((Object)savedSignatures);
    }

    @Test
    public void testSignatureConfirmationResponse() throws Exception {
        Set savedSignatures;
        RequestData reqData = new RequestData();
        Map msgContext = new TreeMap<String, String>();
        msgContext.put("enableSignatureConfirmation", "true");
        msgContext.put("signaturePropFile", "crypto.properties");
        msgContext.put("password", "security");
        reqData.setMsgContext(msgContext);
        reqData.setUsername("16c73ab6-b892-458f-abf5-2f875f74882e");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(2));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        Assertions.assertTrue(((savedSignatures = (Set)(msgContext = (Map)reqData.getMsgContext()).get("_sendSignatureValues_")) != null && savedSignatures.size() == 1 ? 1 : 0) != 0);
        Integer signatureValue = (Integer)savedSignatures.iterator().next();
        Assertions.assertTrue((signatureValue != null && signatureValue != 0 ? 1 : 0) != 0);
        WSHandlerResult results = this.verify(doc);
        doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        msgContext = (Map)reqData.getMsgContext();
        ArrayList<WSHandlerResult> receivedResults = new ArrayList<WSHandlerResult>();
        receivedResults.add(results);
        msgContext.put("RECV_RESULTS", receivedResults);
        action = new HandlerAction(Integer.valueOf(0));
        handler.send(doc, reqData, Collections.singletonList(action), false);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signature Confirmation response....");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("SignatureConfirmation"));
        Assertions.assertTrue((boolean)outputString.contains("Value"));
    }

    @Test
    public void testSignatureConfirmationProcessing() throws Exception {
        RequestData reqData = new RequestData();
        Map msgContext = new TreeMap<String, String>();
        msgContext.put("enableSignatureConfirmation", "true");
        msgContext.put("signaturePropFile", "crypto.properties");
        msgContext.put("password", "security");
        reqData.setMsgContext(msgContext);
        reqData.setUsername("16c73ab6-b892-458f-abf5-2f875f74882e");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(2));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(doc);
        doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        msgContext = (Map)reqData.getMsgContext();
        ArrayList<WSHandlerResult> receivedResults = new ArrayList<WSHandlerResult>();
        receivedResults.add(results);
        msgContext.put("RECV_RESULTS", receivedResults);
        handler.send(doc, reqData, Collections.singletonList(action), false);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signature Confirmation response....");
            LOG.debug(outputString);
        }
        results = this.verify(doc);
        WSSecurityEngineResult scResult = (WSSecurityEngineResult)((List)results.getActionResults().get(128)).get(0);
        Assertions.assertNotNull((Object)scResult);
        Assertions.assertNotNull((Object)scResult.get((Object)"signature-confirmation"));
        handler.signatureConfirmation(reqData, results);
    }

    @Test
    public void testWsuId() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        byte[] randomBytes = WSSecurityUtil.generateNonce((int)20);
        SignatureConfirmation sigConf = new SignatureConfirmation(doc, randomBytes);
        Element sigConfElement = sigConf.getElement();
        secHeader.getSecurityHeaderElement().appendChild(sigConfElement);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSSecurityEngine newEngine = new WSSecurityEngine();
        try {
            newEngine.processSecurityHeader(doc, null, this.callbackHandler, this.crypto);
            Assertions.fail((String)"Failure expected on a request with no wsu:Id");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.INVALID_SECURITY ? 1 : 0) != 0);
        }
        RequestData data = new RequestData();
        data.setCallbackHandler(this.callbackHandler);
        data.setSigVerCrypto(this.crypto);
        data.setIgnoredBSPRules(Collections.singletonList(BSPRule.R5441));
        newEngine.processSecurityHeader(doc, data);
    }

    @Test
    public void testSignatureResponseForUnsignedRequest() throws Exception {
        RequestData reqData = new RequestData();
        Map msgContext = new TreeMap<String, String>();
        msgContext.put("enableSignatureConfirmation", "true");
        msgContext.put("signaturePropFile", "crypto.properties");
        msgContext.put("password", "security");
        reqData.setMsgContext(msgContext);
        reqData.setUsername("16c73ab6-b892-458f-abf5-2f875f74882e");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(0));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(doc);
        doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        msgContext = (Map)reqData.getMsgContext();
        ArrayList<WSHandlerResult> receivedResults = new ArrayList<WSHandlerResult>();
        receivedResults.add(results);
        msgContext.put("RECV_RESULTS", receivedResults);
        action = new HandlerAction(Integer.valueOf(0));
        handler.send(doc, reqData, Collections.singletonList(action), false);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signature Confirmation response....");
            LOG.debug(outputString);
        }
        Assertions.assertTrue((boolean)outputString.contains("SignatureConfirmation"));
        Assertions.assertFalse((boolean)outputString.contains("Value"));
    }

    @Test
    public void testSAMLSignatureConfirmationProcessing() throws Exception {
        RequestData reqData = new RequestData();
        SAML2CallbackHandler samlCallbackHandler = new SAML2CallbackHandler();
        samlCallbackHandler.setConfirmationMethod("urn:oasis:names:tc:SAML:2.0:cm:bearer");
        samlCallbackHandler.setStatement(AbstractSAMLCallbackHandler.Statement.AUTHN);
        samlCallbackHandler.setIssuer("www.example.com");
        samlCallbackHandler.setSignAssertion(true);
        samlCallbackHandler.setIssuerCrypto(this.crypto);
        samlCallbackHandler.setIssuerName("16c73ab6-b892-458f-abf5-2f875f74882e");
        samlCallbackHandler.setIssuerPassword("security");
        Map msgContext = new TreeMap<String, Object>();
        msgContext.put("enableSignatureConfirmation", "true");
        msgContext.put("samlCallbackRef", samlCallbackHandler);
        reqData.setMsgContext(msgContext);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        HandlerAction action = new HandlerAction(Integer.valueOf(8));
        handler.send(doc, reqData, Collections.singletonList(action), true);
        if (LOG.isDebugEnabled()) {
            LOG.debug("After Signing....");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSHandlerResult results = this.verify(doc);
        doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        msgContext = (Map)reqData.getMsgContext();
        ArrayList<WSHandlerResult> receivedResults = new ArrayList<WSHandlerResult>();
        receivedResults.add(results);
        msgContext.put("RECV_RESULTS", receivedResults);
        handler.send(doc, reqData, Collections.singletonList(new HandlerAction(Integer.valueOf(0))), false);
        String outputString = XMLUtils.prettyDocumentToString((Document)doc);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signature Confirmation response....");
            LOG.debug(outputString);
        }
        results = this.verify(doc);
        WSSecurityEngineResult scResult = (WSSecurityEngineResult)((List)results.getActionResults().get(128)).get(0);
        Assertions.assertNotNull((Object)scResult);
        Assertions.assertNotNull((Object)scResult.get((Object)"signature-confirmation"));
        handler.signatureConfirmation(reqData, results);
    }

    private WSHandlerResult verify(Document doc) throws Exception {
        WSHandlerResult results = this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verfied and decrypted message:");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        return results;
    }
}

