/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.handler;

import java.util.ArrayList;
import java.util.Collections;
import java.util.TreeMap;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import org.apache.wss4j.common.EncryptionActionToken;
import org.apache.wss4j.common.SecurityActionToken;
import org.apache.wss4j.common.SignatureActionToken;
import org.apache.wss4j.common.WSEncryptionPart;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.dom.common.CombinedCallbackHandler;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.common.SecretKeyCallbackHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.xml.security.stax.impl.util.IDGenerator;
import org.apache.xml.security.utils.XMLUtils;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SecurityActionTokenTest {
    private static final Logger LOG = LoggerFactory.getLogger(SecurityActionTokenTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private Crypto crypto;
    private byte[] keyData;

    @BeforeEach
    public void setUp() throws Exception {
        KeyGenerator keyGen = KeyGenerator.getInstance("AES");
        keyGen.init(128);
        SecretKey key = keyGen.generateKey();
        this.keyData = key.getEncoded();
    }

    public SecurityActionTokenTest() throws WSSecurityException {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance((String)"wss40.properties");
    }

    @Test
    public void testAsymmetricSignature() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, KeystoreCallbackHandler> messageContext = new TreeMap<String, KeystoreCallbackHandler>();
        messageContext.put("passwordCallbackRef", new KeystoreCallbackHandler());
        reqData.setMsgContext(messageContext);
        SignatureActionToken actionToken = new SignatureActionToken();
        actionToken.setUser("wss40");
        actionToken.setCryptoProperties("wss40.properties");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(2), (SecurityActionToken)actionToken));
        handler.send(doc, reqData, actions, true);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        this.verify(doc, null);
    }

    @Test
    public void testSymmetricSignature() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, KeystoreCallbackHandler> messageContext = new TreeMap<String, KeystoreCallbackHandler>();
        messageContext.put("passwordCallbackRef", new KeystoreCallbackHandler());
        reqData.setMsgContext(messageContext);
        SignatureActionToken actionToken = new SignatureActionToken();
        actionToken.setKeyIdentifierId(10);
        actionToken.setKey(this.keyData);
        actionToken.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(2), (SecurityActionToken)actionToken));
        handler.send(doc, reqData, actions, true);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        SecretKeyCallbackHandler secretKeyCallbackHandler = new SecretKeyCallbackHandler();
        byte[] encodedBytes = KeyUtils.generateDigest((byte[])this.keyData);
        String identifier = XMLUtils.encodeToString((byte[])encodedBytes);
        secretKeyCallbackHandler.addSecretKey(identifier, this.keyData);
        this.verify(doc, secretKeyCallbackHandler);
    }

    @Test
    public void testAsymmetricDoubleSignature() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, KeystoreCallbackHandler> messageContext = new TreeMap<String, KeystoreCallbackHandler>();
        messageContext.put("passwordCallbackRef", new KeystoreCallbackHandler());
        reqData.setMsgContext(messageContext);
        SignatureActionToken actionToken = new SignatureActionToken();
        actionToken.setUser("wss40");
        actionToken.setCryptoProperties("wss40.properties");
        actionToken.setKeyIdentifierId(1);
        SignatureActionToken actionToken2 = new SignatureActionToken();
        actionToken2.setUser("16c73ab6-b892-458f-abf5-2f875f74882e");
        actionToken2.setCryptoProperties("crypto.properties");
        actionToken2.setIncludeToken(false);
        WSEncryptionPart encP = new WSEncryptionPart("Timestamp", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "");
        actionToken2.setParts(Collections.singletonList(encP));
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(2), (SecurityActionToken)actionToken));
        actions.add(new HandlerAction(Integer.valueOf(2), (SecurityActionToken)actionToken2));
        actions.add(new HandlerAction(Integer.valueOf(32), null));
        handler.send(doc, reqData, actions, true);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
    }

    @Test
    public void testMixedDoubleSignature() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, KeystoreCallbackHandler> messageContext = new TreeMap<String, KeystoreCallbackHandler>();
        messageContext.put("passwordCallbackRef", new KeystoreCallbackHandler());
        reqData.setMsgContext(messageContext);
        SignatureActionToken actionToken = new SignatureActionToken();
        actionToken.setUser("wss40");
        actionToken.setCryptoProperties("wss40.properties");
        actionToken.setKeyIdentifierId(1);
        SignatureActionToken actionToken2 = new SignatureActionToken();
        actionToken2.setKeyIdentifierId(10);
        actionToken2.setKey(this.keyData);
        actionToken2.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        WSEncryptionPart encP = new WSEncryptionPart("Timestamp", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "");
        actionToken2.setParts(Collections.singletonList(encP));
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(2), (SecurityActionToken)actionToken));
        actions.add(new HandlerAction(Integer.valueOf(2), (SecurityActionToken)actionToken2));
        actions.add(new HandlerAction(Integer.valueOf(32), null));
        handler.send(doc, reqData, actions, true);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        SecretKeyCallbackHandler secretKeyCallbackHandler = new SecretKeyCallbackHandler();
        byte[] encodedBytes = KeyUtils.generateDigest((byte[])this.keyData);
        String identifier = XMLUtils.encodeToString((byte[])encodedBytes);
        secretKeyCallbackHandler.addSecretKey(identifier, this.keyData);
        this.verify(doc, secretKeyCallbackHandler);
    }

    @Test
    public void testAsymmetricEncryption() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, KeystoreCallbackHandler> messageContext = new TreeMap<String, KeystoreCallbackHandler>();
        messageContext.put("passwordCallbackRef", new KeystoreCallbackHandler());
        reqData.setMsgContext(messageContext);
        EncryptionActionToken actionToken = new EncryptionActionToken();
        actionToken.setUser("wss40");
        actionToken.setCryptoProperties("wss40.properties");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(4), (SecurityActionToken)actionToken));
        handler.send(doc, reqData, actions, true);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        this.verify(doc, new KeystoreCallbackHandler());
    }

    @Test
    public void testAsymmetricEncryptionIncludeToken() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, KeystoreCallbackHandler> messageContext = new TreeMap<String, KeystoreCallbackHandler>();
        messageContext.put("passwordCallbackRef", new KeystoreCallbackHandler());
        reqData.setMsgContext(messageContext);
        EncryptionActionToken actionToken = new EncryptionActionToken();
        actionToken.setUser("wss40");
        actionToken.setCryptoProperties("wss40.properties");
        actionToken.setIncludeToken(true);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(4), (SecurityActionToken)actionToken));
        handler.send(doc, reqData, actions, true);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        this.verify(doc, new KeystoreCallbackHandler());
    }

    @Test
    public void testSymmetricEncryption() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, KeystoreCallbackHandler> messageContext = new TreeMap<String, KeystoreCallbackHandler>();
        messageContext.put("passwordCallbackRef", new KeystoreCallbackHandler());
        reqData.setMsgContext(messageContext);
        EncryptionActionToken actionToken = new EncryptionActionToken();
        actionToken.setKeyIdentifierId(10);
        actionToken.setKey(this.keyData);
        actionToken.setSymmetricAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        actionToken.setEncSymmetricEncryptionKey(false);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(4), (SecurityActionToken)actionToken));
        handler.send(doc, reqData, actions, true);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        SecretKeyCallbackHandler secretKeyCallbackHandler = new SecretKeyCallbackHandler();
        byte[] encodedBytes = KeyUtils.generateDigest((byte[])this.keyData);
        String identifier = XMLUtils.encodeToString((byte[])encodedBytes);
        secretKeyCallbackHandler.addSecretKey(identifier, this.keyData);
        this.verify(doc, secretKeyCallbackHandler);
    }

    @Test
    public void testAsymmetricDoubleEncryption() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, KeystoreCallbackHandler> messageContext = new TreeMap<String, KeystoreCallbackHandler>();
        messageContext.put("passwordCallbackRef", new KeystoreCallbackHandler());
        reqData.setMsgContext(messageContext);
        EncryptionActionToken actionToken = new EncryptionActionToken();
        actionToken.setUser("wss40");
        actionToken.setCryptoProperties("wss40.properties");
        EncryptionActionToken actionToken2 = new EncryptionActionToken();
        actionToken2.setUser("16c73ab6-b892-458f-abf5-2f875f74882e");
        actionToken2.setCryptoProperties("crypto.properties");
        WSEncryptionPart encP = new WSEncryptionPart("Timestamp", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "");
        actionToken2.setParts(Collections.singletonList(encP));
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(4), (SecurityActionToken)actionToken));
        actions.add(new HandlerAction(Integer.valueOf(32), null));
        actions.add(new HandlerAction(Integer.valueOf(4), (SecurityActionToken)actionToken2));
        handler.send(doc, reqData, actions, true);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
    }

    @Test
    public void testMixedDoubleEncryption() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, KeystoreCallbackHandler> messageContext = new TreeMap<String, KeystoreCallbackHandler>();
        messageContext.put("passwordCallbackRef", new KeystoreCallbackHandler());
        reqData.setMsgContext(messageContext);
        EncryptionActionToken actionToken = new EncryptionActionToken();
        actionToken.setUser("wss40");
        actionToken.setCryptoProperties("wss40.properties");
        EncryptionActionToken actionToken2 = new EncryptionActionToken();
        actionToken2.setKeyIdentifierId(10);
        actionToken2.setKey(this.keyData);
        actionToken2.setSymmetricAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        actionToken2.setEncSymmetricEncryptionKey(false);
        WSEncryptionPart encP = new WSEncryptionPart("Timestamp", "http://docs.oasis-open.org/wss/2004/01/oasis-200401-wss-wssecurity-utility-1.0.xsd", "");
        actionToken2.setParts(Collections.singletonList(encP));
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(4), (SecurityActionToken)actionToken));
        actions.add(new HandlerAction(Integer.valueOf(32), null));
        actions.add(new HandlerAction(Integer.valueOf(4), (SecurityActionToken)actionToken2));
        handler.send(doc, reqData, actions, true);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        SecretKeyCallbackHandler secretKeyCallbackHandler = new SecretKeyCallbackHandler();
        byte[] encodedBytes = KeyUtils.generateDigest((byte[])this.keyData);
        String identifier = XMLUtils.encodeToString((byte[])encodedBytes);
        secretKeyCallbackHandler.addSecretKey(identifier, this.keyData);
        CombinedCallbackHandler combinedCallbackHandler = new CombinedCallbackHandler(secretKeyCallbackHandler, new KeystoreCallbackHandler());
        this.verify(doc, combinedCallbackHandler);
    }

    @Test
    public void testAsymmetricSignatureEncryption() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, KeystoreCallbackHandler> messageContext = new TreeMap<String, KeystoreCallbackHandler>();
        messageContext.put("passwordCallbackRef", new KeystoreCallbackHandler());
        reqData.setMsgContext(messageContext);
        SignatureActionToken actionToken = new SignatureActionToken();
        actionToken.setUser("wss40");
        actionToken.setCryptoProperties("wss40.properties");
        actionToken.setKeyIdentifierId(1);
        EncryptionActionToken actionToken2 = new EncryptionActionToken();
        actionToken2.setUser("wss40");
        actionToken2.setCryptoProperties("wss40.properties");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(2), (SecurityActionToken)actionToken));
        actions.add(new HandlerAction(Integer.valueOf(4), (SecurityActionToken)actionToken2));
        handler.send(doc, reqData, actions, true);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        this.verify(doc, new KeystoreCallbackHandler());
    }

    @Test
    public void testSymmetricSignatureEncryption() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, KeystoreCallbackHandler> messageContext = new TreeMap<String, KeystoreCallbackHandler>();
        messageContext.put("passwordCallbackRef", new KeystoreCallbackHandler());
        reqData.setMsgContext(messageContext);
        EncryptionActionToken actionToken = new EncryptionActionToken();
        actionToken.setKey(this.keyData);
        actionToken.setSymmetricAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        actionToken.setKeyIdentifierId(4);
        actionToken.setUser("wss40");
        actionToken.setCryptoProperties("wss40.properties");
        actionToken.setTokenId(IDGenerator.generateID((String)"EK-"));
        SignatureActionToken actionToken2 = new SignatureActionToken();
        actionToken2.setKeyIdentifierId(9);
        actionToken2.setKey(this.keyData);
        actionToken2.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        actionToken2.setTokenType("http://docs.oasis-open.org/wss/oasis-wss-soap-message-security-1.1#EncryptedKey");
        actionToken2.setTokenId(actionToken.getTokenId());
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(2), (SecurityActionToken)actionToken2));
        actions.add(new HandlerAction(Integer.valueOf(4), (SecurityActionToken)actionToken));
        handler.send(doc, reqData, actions, true);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        this.verify(doc, new KeystoreCallbackHandler());
    }

    @Test
    public void testSymmetricSignatureEncryptionResponse() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, KeystoreCallbackHandler> messageContext = new TreeMap<String, KeystoreCallbackHandler>();
        messageContext.put("passwordCallbackRef", new KeystoreCallbackHandler());
        reqData.setMsgContext(messageContext);
        EncryptionActionToken actionToken = new EncryptionActionToken();
        actionToken.setKey(this.keyData);
        actionToken.setSymmetricAlgorithm("http://www.w3.org/2001/04/xmlenc#aes128-cbc");
        actionToken.setKeyIdentifierId(10);
        actionToken.setEncSymmetricEncryptionKey(false);
        SignatureActionToken actionToken2 = new SignatureActionToken();
        actionToken2.setKeyIdentifierId(10);
        actionToken2.setKey(this.keyData);
        actionToken2.setSignatureAlgorithm("http://www.w3.org/2000/09/xmldsig#hmac-sha1");
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(2), (SecurityActionToken)actionToken2));
        actions.add(new HandlerAction(Integer.valueOf(4), (SecurityActionToken)actionToken));
        handler.send(doc, reqData, actions, true);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        SecretKeyCallbackHandler secretKeyCallbackHandler = new SecretKeyCallbackHandler();
        byte[] encodedBytes = KeyUtils.generateDigest((byte[])this.keyData);
        String identifier = XMLUtils.encodeToString((byte[])encodedBytes);
        secretKeyCallbackHandler.addSecretKey(identifier, this.keyData);
        this.verify(doc, secretKeyCallbackHandler);
    }

    private WSHandlerResult verify(Document doc, CallbackHandler callbackHandler) throws Exception {
        return this.secEngine.processSecurityHeader(doc, null, callbackHandler, this.crypto);
    }
}

