/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.handler;

import java.util.ArrayList;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class ResultsOrderTest {
    @Test
    public void testOrder() throws Exception {
        CustomHandler handler = new CustomHandler();
        ArrayList<WSSecurityEngineResult> results = new ArrayList<WSSecurityEngineResult>();
        results.add(new WSSecurityEngineResult(1));
        results.add(new WSSecurityEngineResult(32));
        results.add(new WSSecurityEngineResult(128));
        results.add(new WSSecurityEngineResult(2));
        ArrayList<Integer> actions = new ArrayList<Integer>();
        actions.add(1);
        actions.add(32);
        actions.add(2);
        Assertions.assertTrue((boolean)handler.checkResults(results, actions));
        Assertions.assertTrue((boolean)handler.checkResultsAnyOrder(results, actions));
    }

    @Test
    public void testReverseOrder() throws Exception {
        CustomHandler handler = new CustomHandler();
        ArrayList<WSSecurityEngineResult> results = new ArrayList<WSSecurityEngineResult>();
        results.add(new WSSecurityEngineResult(2));
        results.add(new WSSecurityEngineResult(128));
        results.add(new WSSecurityEngineResult(32));
        results.add(new WSSecurityEngineResult(1));
        ArrayList<Integer> actions = new ArrayList<Integer>();
        actions.add(1);
        actions.add(32);
        actions.add(2);
        Assertions.assertFalse((boolean)handler.checkResults(results, actions));
        Assertions.assertTrue((boolean)handler.checkResultsAnyOrder(results, actions));
        Assertions.assertTrue((results.size() == 4 && actions.size() == 3 ? 1 : 0) != 0);
    }

    @Test
    public void testMixedOrder() throws Exception {
        CustomHandler handler = new CustomHandler();
        ArrayList<WSSecurityEngineResult> results = new ArrayList<WSSecurityEngineResult>();
        results.add(new WSSecurityEngineResult(32));
        results.add(new WSSecurityEngineResult(2));
        results.add(new WSSecurityEngineResult(128));
        results.add(new WSSecurityEngineResult(1));
        ArrayList<Integer> actions = new ArrayList<Integer>();
        actions.add(1);
        actions.add(32);
        actions.add(2);
        Assertions.assertFalse((boolean)handler.checkResults(results, actions));
        Assertions.assertTrue((boolean)handler.checkResultsAnyOrder(results, actions));
        Assertions.assertFalse((boolean)actions.isEmpty());
    }

    @Test
    public void testMixedOrder2() throws Exception {
        CustomHandler handler = new CustomHandler();
        ArrayList<WSSecurityEngineResult> results = new ArrayList<WSSecurityEngineResult>();
        results.add(new WSSecurityEngineResult(32));
        results.add(new WSSecurityEngineResult(2));
        results.add(new WSSecurityEngineResult(128));
        results.add(new WSSecurityEngineResult(1));
        ArrayList<Integer> actions = new ArrayList<Integer>();
        actions.add(2);
        actions.add(1);
        actions.add(32);
        Assertions.assertFalse((boolean)handler.checkResults(results, actions));
        Assertions.assertTrue((boolean)handler.checkResultsAnyOrder(results, actions));
    }

    @Test
    public void testMissingResult() throws Exception {
        CustomHandler handler = new CustomHandler();
        ArrayList<WSSecurityEngineResult> results = new ArrayList<WSSecurityEngineResult>();
        results.add(new WSSecurityEngineResult(1));
        results.add(new WSSecurityEngineResult(32));
        results.add(new WSSecurityEngineResult(128));
        ArrayList<Integer> actions = new ArrayList<Integer>();
        actions.add(32);
        actions.add(1);
        actions.add(2);
        Assertions.assertFalse((boolean)handler.checkResults(results, actions));
        Assertions.assertFalse((boolean)handler.checkResultsAnyOrder(results, actions));
    }

    @Test
    public void testMissingAction() throws Exception {
        CustomHandler handler = new CustomHandler();
        ArrayList<WSSecurityEngineResult> results = new ArrayList<WSSecurityEngineResult>();
        results.add(new WSSecurityEngineResult(1));
        results.add(new WSSecurityEngineResult(32));
        results.add(new WSSecurityEngineResult(2));
        results.add(new WSSecurityEngineResult(128));
        ArrayList<Integer> actions = new ArrayList<Integer>();
        actions.add(32);
        actions.add(1);
        Assertions.assertFalse((boolean)handler.checkResults(results, actions));
        Assertions.assertFalse((boolean)handler.checkResultsAnyOrder(results, actions));
    }

    @Test
    public void testNoResult() throws Exception {
        CustomHandler handler = new CustomHandler();
        ArrayList<WSSecurityEngineResult> results = new ArrayList<WSSecurityEngineResult>();
        ArrayList<Integer> actions = new ArrayList<Integer>();
        actions.add(32);
        Assertions.assertFalse((boolean)handler.checkResults(results, actions));
        Assertions.assertFalse((boolean)handler.checkResultsAnyOrder(results, actions));
    }

    @Test
    public void testNoAction() throws Exception {
        CustomHandler handler = new CustomHandler();
        ArrayList<WSSecurityEngineResult> results = new ArrayList<WSSecurityEngineResult>();
        results.add(new WSSecurityEngineResult(32));
        ArrayList<Integer> actions = new ArrayList<Integer>();
        Assertions.assertFalse((boolean)handler.checkResults(results, actions));
        Assertions.assertFalse((boolean)handler.checkResultsAnyOrder(results, actions));
    }

    @Test
    public void testMultipleIdenticalResults() throws Exception {
        CustomHandler handler = new CustomHandler();
        ArrayList<WSSecurityEngineResult> results = new ArrayList<WSSecurityEngineResult>();
        results.add(new WSSecurityEngineResult(4));
        results.add(new WSSecurityEngineResult(1));
        results.add(new WSSecurityEngineResult(4));
        ArrayList<Integer> actions = new ArrayList<Integer>();
        actions.add(4);
        actions.add(1);
        actions.add(1);
        Assertions.assertFalse((boolean)handler.checkResults(results, actions));
        Assertions.assertFalse((boolean)handler.checkResultsAnyOrder(results, actions));
    }
}

