/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.handler;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.TreeMap;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecTimestamp;
import org.apache.wss4j.dom.message.token.Timestamp;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class CustomTokenTest {
    private static final Logger LOG = LoggerFactory.getLogger(CustomTokenTest.class);

    @Test
    public void testCustomTokenTimestamp() throws Exception {
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        Document timestampDoc = dbf.newDocumentBuilder().newDocument();
        WSSecTimestamp timestamp = new WSSecTimestamp(timestampDoc);
        timestamp.setTimeToLive(300);
        timestamp.prepare();
        Element timestampElement = timestamp.getElement();
        WSSConfig cfg = WSSConfig.getNewInstance();
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        TreeMap<String, CustomCallbackHandler> messageContext = new TreeMap<String, CustomCallbackHandler>();
        messageContext.put("passwordCallbackRef", new CustomCallbackHandler(timestampElement));
        reqData.setMsgContext(messageContext);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        ArrayList<HandlerAction> actions = new ArrayList<HandlerAction>();
        actions.add(new HandlerAction(Integer.valueOf(16384), null));
        handler.send(doc, reqData, actions, true);
        if (LOG.isDebugEnabled()) {
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
        WSSecurityEngine secEngine = new WSSecurityEngine();
        WSHandlerResult wsResults = secEngine.processSecurityHeader(doc, null, null, null);
        WSSecurityEngineResult actionResult = (WSSecurityEngineResult)((List)wsResults.getActionResults().get(32)).get(0);
        Assertions.assertNotNull((Object)actionResult);
        Timestamp receivedTimestamp = (Timestamp)actionResult.get((Object)"timestamp");
        Assertions.assertNotNull((Object)receivedTimestamp);
    }

    private static class CustomCallbackHandler
    implements CallbackHandler {
        private final Element customElement;

        public CustomCallbackHandler(Element customElement) {
            this.customElement = customElement;
        }

        @Override
        public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
            for (Callback callback : callbacks) {
                WSPasswordCallback passwordCallback;
                if (!(callback instanceof WSPasswordCallback) || (passwordCallback = (WSPasswordCallback)callback).getUsage() != 7) continue;
                passwordCallback.setCustomToken(this.customElement);
                return;
            }
        }
    }
}

