/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.handler;

import java.util.Collections;
import java.util.List;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.common.util.XMLUtils;
import org.apache.wss4j.dom.WSConstants;
import org.apache.wss4j.dom.common.CustomAction;
import org.apache.wss4j.dom.common.CustomHandler;
import org.apache.wss4j.dom.common.CustomProcessor;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.engine.WSSecurityEngineResult;
import org.apache.wss4j.dom.handler.HandlerAction;
import org.apache.wss4j.dom.handler.RequestData;
import org.apache.wss4j.dom.handler.WSHandlerResult;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.wss4j.dom.util.WSSecurityUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class CustomActionProcessorTest {
    private static final Logger LOG = LoggerFactory.getLogger(CustomActionProcessorTest.class);
    private Crypto crypto;

    public CustomActionProcessorTest() throws Exception {
        WSSConfig.init();
        this.crypto = CryptoFactory.getInstance();
    }

    @Test
    public void testCustomUserProcessor() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(2);
        LOG.info("Before Signing IS....");
        Document signedDoc = builder.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message with IssuerSerial key identifier:");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        LOG.info("After Signing IS....");
        WSSConfig cfg = WSSConfig.getNewInstance();
        String p = "org.apache.wss4j.dom.common.CustomProcessor";
        cfg.setProcessor(WSConstants.SIGNATURE, CustomProcessor.class);
        WSSecurityEngine engine = new WSSecurityEngine();
        engine.setWssConfig(cfg);
        WSHandlerResult results = engine.processSecurityHeader(doc, null, null, this.crypto);
        boolean found = false;
        for (WSSecurityEngineResult result : results.getResults()) {
            Object obj = result.get((Object)"foo");
            if (obj == null || !obj.getClass().getName().equals(p)) continue;
            found = true;
        }
        Assertions.assertTrue((boolean)found, (String)"Unable to find result from CustomProcessor");
    }

    @Test
    public void testCustomUserProcessorObject() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("16c73ab6-b892-458f-abf5-2f875f74882e", "security");
        builder.setKeyIdentifierType(2);
        LOG.info("Before Signing IS....");
        Document signedDoc = builder.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Signed message with IssuerSerial key identifier:");
            String outputString = XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        LOG.info("After Signing IS....");
        WSSConfig cfg = WSSConfig.getNewInstance();
        cfg.setProcessor(WSConstants.SIGNATURE, CustomProcessor.class);
        WSSecurityEngine engine = new WSSecurityEngine();
        engine.setWssConfig(cfg);
        WSHandlerResult results = engine.processSecurityHeader(doc, null, null, this.crypto);
        boolean found = false;
        for (WSSecurityEngineResult result : results.getResults()) {
            Object obj = result.get((Object)"foo");
            if (obj == null || !obj.getClass().getName().equals(CustomProcessor.class.getName())) continue;
            found = true;
        }
        Assertions.assertTrue((boolean)found, (String)"Unable to find result from CustomProcessor");
    }

    @Test
    public void testCustomAction() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        int action = -559026176;
        cfg.setAction(-559026176, CustomAction.class);
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        reqData.setMsgContext((Object)"bread");
        Assertions.assertEquals((Object)reqData.getMsgContext(), (Object)"bread");
        handler.send(doc, reqData, Collections.singletonList(new HandlerAction(Integer.valueOf(-559026176))), true);
        Assertions.assertEquals((Object)reqData.getMsgContext(), (Object)"crumb");
    }

    @Test
    public void testCustomActionObject() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        int action = -559026176;
        cfg.setAction(-559026176, CustomAction.class);
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        reqData.setMsgContext((Object)"bread");
        Assertions.assertEquals((Object)reqData.getMsgContext(), (Object)"bread");
        handler.send(doc, reqData, Collections.singletonList(new HandlerAction(Integer.valueOf(-559026176))), true);
        Assertions.assertEquals((Object)reqData.getMsgContext(), (Object)"crumb");
    }

    @Test
    public void testDecodeCustomAction() throws Exception {
        WSSConfig cfg = WSSConfig.getNewInstance();
        int customAction = -559026176;
        String actionString = "Timestamp " + Integer.valueOf(-559026176).toString();
        try {
            WSSecurityUtil.decodeHandlerAction((String)actionString, (WSSConfig)cfg);
            Assertions.fail((String)"Failure expected on unknown action");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
        try {
            String badActionString = "Timestamp NewCustomAction";
            WSSecurityUtil.decodeHandlerAction((String)badActionString, (WSSConfig)cfg);
            Assertions.fail((String)"Failure expected on unknown action");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
        cfg.setAction(-559026176, CustomAction.class);
        List actionList = WSSecurityUtil.decodeHandlerAction((String)actionString, (WSSConfig)cfg);
        RequestData reqData = new RequestData();
        reqData.setWssConfig(cfg);
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        CustomHandler handler = new CustomHandler();
        reqData.setMsgContext((Object)"bread");
        Assertions.assertEquals((Object)reqData.getMsgContext(), (Object)"bread");
        handler.send(doc, reqData, actionList, true);
        Assertions.assertEquals((Object)reqData.getMsgContext(), (Object)"crumb");
        if (LOG.isDebugEnabled()) {
            LOG.debug("Message:");
            String outputString = XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
    }
}

