/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.components.crypto;

import java.io.InputStream;
import java.security.KeyStore;
import java.util.Properties;
import java.util.TreeMap;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.Loader;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.dom.common.CustomCrypto;
import org.apache.wss4j.dom.engine.WSSConfig;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;

public class CryptoTest {
    public CryptoTest() {
        WSSConfig.init();
    }

    @Test
    public void testCrypto() throws Exception {
        Crypto crypto = CryptoFactory.getInstance();
        Assertions.assertNotNull((Object)crypto);
    }

    @Test
    public void testMerlinWithNullProperties() throws Exception {
        NullPropertiesCrypto crypto = new NullPropertiesCrypto();
        Assertions.assertNotNull((Object)((Object)crypto));
    }

    @Test
    public void testCustomCrypto() throws Exception {
        TreeMap tmp = new TreeMap();
        Crypto crypto = CryptoFactory.getInstance(CustomCrypto.class, tmp);
        Assertions.assertNotNull((Object)crypto);
        Assertions.assertTrue((boolean)(crypto instanceof CustomCrypto));
        CustomCrypto custom = (CustomCrypto)crypto;
        Assertions.assertSame(tmp, custom.getConfig());
    }

    @Test
    public void testNoKeyStoreFile() throws Exception {
        Crypto crypto = CryptoFactory.getInstance((String)"nofile.properties");
        Assertions.assertNotNull((Object)crypto);
    }

    @Test
    public void testDynamicCrypto() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature builder = new WSSecSignature(secHeader);
        builder.setUserInfo("wss40", "security");
        builder.setKeyIdentifierType(1);
        Merlin crypto = new Merlin();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ClassLoader loader = Loader.getClassLoader(CryptoTest.class);
        InputStream input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40.jks");
        keyStore.load(input, "security".toCharArray());
        input.close();
        crypto.setKeyStore(keyStore);
        Document signedDoc = builder.build((Crypto)crypto);
        Merlin processCrypto = new Merlin();
        KeyStore trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40CA.jks");
        trustStore.load(input, "security".toCharArray());
        input.close();
        processCrypto.setTrustStore(trustStore);
        WSSecurityEngine secEngine = new WSSecurityEngine();
        secEngine.processSecurityHeader(signedDoc, null, null, (Crypto)processCrypto);
        processCrypto = new Merlin();
        trustStore = KeyStore.getInstance(KeyStore.getDefaultType());
        input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40badca.jks");
        trustStore.load(input, "security".toCharArray());
        input.close();
        processCrypto.setTrustStore(trustStore);
        try {
            secEngine.processSecurityHeader(signedDoc, null, null, (Crypto)processCrypto);
            Assertions.fail((String)"Expected failure on a bad trust store");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
    }

    @Test
    public void testCryptoFactoryMerlin() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Properties properties = CryptoFactory.getProperties((String)"crypto.properties", (ClassLoader)classLoader);
        Crypto crypto = CryptoFactory.getInstance((Properties)properties, (ClassLoader)classLoader, null);
        Assertions.assertTrue((boolean)(crypto instanceof Merlin));
    }

    @Test
    public void testCryptoFactoryMerlinDevice() throws Exception {
        ClassLoader classLoader = this.getClass().getClassLoader();
        Properties properties = CryptoFactory.getProperties((String)"crypto_device.properties", (ClassLoader)classLoader);
        Crypto crypto = CryptoFactory.getInstance((Properties)properties, (ClassLoader)classLoader, null);
        Assertions.assertTrue((boolean)(crypto instanceof Merlin));
    }

    private static class NullPropertiesCrypto
    extends Merlin {
        public NullPropertiesCrypto() throws Exception {
            super(null, null, null);
        }
    }
}

