/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.components.crypto;

import java.io.ByteArrayInputStream;
import java.security.Provider;
import java.security.Security;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.SOAPUtil;
import org.apache.wss4j.dom.common.KeystoreCallbackHandler;
import org.apache.wss4j.dom.engine.WSSecurityEngine;
import org.apache.wss4j.dom.message.WSSecEncrypt;
import org.apache.wss4j.dom.message.WSSecHeader;
import org.apache.wss4j.dom.message.WSSecSignature;
import org.apache.xml.security.utils.XMLUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class CryptoProviderTest {
    private static final Logger LOG = LoggerFactory.getLogger(CryptoProviderTest.class);
    private WSSecurityEngine secEngine = new WSSecurityEngine();
    private CallbackHandler callbackHandler = new KeystoreCallbackHandler();
    private Crypto crypto;

    public CryptoProviderTest() throws Exception {
        this.secEngine.getWssConfig();
        this.crypto = CryptoFactory.getInstance((String)"wss86.properties");
    }

    @Test
    public void testSignatureOID() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setUserInfo("wss86", "security");
        sign.setKeyIdentifierType(2);
        Document signedDoc = sign.build(this.crypto);
        if (LOG.isDebugEnabled()) {
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)signedDoc);
            LOG.debug(outputString);
        }
        this.verify(signedDoc);
    }

    @Test
    public void testSignatureEmailAddress() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setUserInfo("wss86", "security");
        sign.setKeyIdentifierType(2);
        Document signedDoc = sign.build(this.crypto);
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)signedDoc);
        outputString = outputString.replace("1.2.840.113549.1.9.1=#16125765726e6572406578616d706c652e636f6d", "EMAILADDRESS=Werner@example.com");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        ByteArrayInputStream is = new ByteArrayInputStream(outputString.getBytes());
        Document parsedDoc = dbf.newDocumentBuilder().parse(is);
        this.verify(parsedDoc);
    }

    @Test
    public void testSignatureOtherEmailAddress() throws Exception {
        Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        WSSecHeader secHeader = new WSSecHeader(doc);
        secHeader.insertSecurityHeader();
        WSSecSignature sign = new WSSecSignature(secHeader);
        sign.setUserInfo("wss86", "security");
        sign.setKeyIdentifierType(2);
        Document signedDoc = sign.build(this.crypto);
        String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)signedDoc);
        outputString = outputString.replace("1.2.840.113549.1.9.1=#16125765726e6572406578616d706c652e636f6d", "E=Werner@example.com");
        DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
        dbf.setNamespaceAware(true);
        ByteArrayInputStream is = new ByteArrayInputStream(outputString.getBytes());
        Document parsedDoc = dbf.newDocumentBuilder().parse(is);
        this.verify(parsedDoc);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testInterop() throws Exception {
        byte[] certBytes = XMLUtils.decode((String)"MIIDqTCCApGgAwIBAgIEePiYTTANBgkqhkiG9w0BAQsFADCBhDELMAkGA1UEBhMCREUxDzANBgNVBAgTBkJheWVybjEPMA0GA1UEBxMGTXVuaWNoMQ8wDQYDVQQKEwZBcGFjaGUxDjAMBgNVBAsTBVdTUzRKMQ8wDQYDVQQDEwZXZXJuZXIxITAfBgkqhkiG9w0BCQEWEldlcm5lckBleGFtcGxlLmNvbTAeFw0xNTA5MDkxNTA3MzFaFw0yNTA5MDYxNTA3MzFaMIGEMQswCQYDVQQGEwJERTEPMA0GA1UECBMGQmF5ZXJuMQ8wDQYDVQQHEwZNdW5pY2gxDzANBgNVBAoTBkFwYWNoZTEOMAwGA1UECxMFV1NTNEoxDzANBgNVBAMTBldlcm5lcjEhMB8GCSqGSIb3DQEJARYSV2VybmVyQGV4YW1wbGUuY29tMIIBIjANBgkqhkiG9w0BAQEFAAOCAQ8AMIIBCgKCAQEAoUlwwKbNU0vNPwEc32E85k36n7cWAmuuhpX+CoTkXOfvpyoVcwBI8LwMmT1CR9KPxa+zmcE7RmX5qzVaW7Ukzra/pfD7YC3WGGAU9Awsq5OFLsMc4tZ/7FM5azGdZA/wSI2384Ytnu88Z8O1qnBblLdNluNWVADq5tvgAdPQMoks9Xg+9SBiwj2p3C0RD0uMx0bwscNEDWeHUJeGqNbWzEeYCvFLDGdl1Or3uha+drq4fNoVGstybM0VeGvFjP3NEX8dfl9WTxAl3dB0TXzb70RuQghLqHJtDEXMC/ckaNHht6F/VcOxjZCtpLlMUptyPjrMDFOIaZ5q/6NSiMIjqwIDAQABoyEwHzAdBgNVHQ4EFgQUviIg1rtoiwto4gYIAWFHCsCDISkwDQYJKoZIhvcNAQELBQADggEBAJEaMtEBpI7X1lx2+Wcjn2a3xugfTGZcy3s4fxGpbCxcdbDS7gWR/N+acwp4GXEbDrObwxIO/Kt5eMzfD5EPCuMdLfLjK+G27RXc/89bR3aphm6ZyLnTLBJ5h24Of9+uDKY2bVIcF62uyXCnVAoq6dY/rBj7btSjAOWFshMDJGNN7k/78s33sTdJfD2NQDvAvRZb1hYiUGcUij0ka+bhS/EtazH411w2NOQYUyZ50HRroKJx1PPCE+OTO5JYPNQB2rauK63RHGGC94mY2ySCE2KP/yaWhkDJ60X2JKgnTLKUZxLP9IioeHVeUzGIccIicoiZR5kqaiqoEk82V81R+VA=");
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certBytes));
            Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
            WSSecHeader secHeader = new WSSecHeader(doc);
            secHeader.insertSecurityHeader();
            WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
            encrypt.setUseThisCert(cert);
            KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            SecretKey symmetricKey = keyGen.generateKey();
            Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
            if (LOG.isDebugEnabled()) {
                String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
                LOG.debug(outputString);
            }
            this.verify(encryptedDoc);
        }
        finally {
            Security.removeProvider("BC");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testBadInterop() throws Exception {
        byte[] certBytes = XMLUtils.decode((String)"MIIDNDCCAp2gAwIBAgIBEDANBgkqhkiG9w0BAQQFADBmMQswCQYDVQQGEwJERTEPMA0GA1UECBMGQmF5ZXJuMQ8wDQYDVQQHEwZNdW5pY2gxDTALBgNVBAoTBEhvbWUxFTATBgNVBAsTDEFwYWNoZSBXU1M0SjEPMA0GA1UEAxMGV2VybmVyMB4XDTA4MDQwNDE5MzIxOFoXDTEwMDQwNDE5MzIxOFowYTELMAkGA1UEBhMCREUxDzANBgNVBAgTBkJheWVybjEPMA0GA1UEBxMGTXVuaWNoMQ8wDQYDVQQKEwZBcGFjaGUxDjAMBgNVBAsTBVdTUzRKMQ8wDQYDVQQDEwZXZXJuZXIwgZ8wDQYJKoZIhvcNAQEBBQADgY0AMIGJAoGBAINlL3/k0H/zvknpBtLo8jzXwx/IJU/CGSv6MsqJZ2fyZ6kpLlXCuSBUZ/tfkdxpuzhYq/Sc7A8csIk9gDf9RUbrhK0qKw0VP6DoCIJjS5IeN+NeJkx8YjmzLPmZqLYbNPXr/hy8CRrR6CqLTTSkBwoEJ+cDkfZrdH2/bND0FEIZAgMBAAGjgfYwgfMwCQYDVR0TBAIwADAsBglghkgBhvhCAQ0EHxYdT3BlblNTTCBHZW5lcmF0ZWQgQ2VydGlmaWNhdGUwHQYDVR0OBBYEFFSZXv0I5bG7XPEwjylwG3lmZGdiMIGYBgNVHSMEgZAwgY2AFL/FsHHolGIMacU1TZW/88Bd2EL6oWqkaDBmMQswCQYDVQQGEwJERTEPMA0GA1UECBMGQmF5ZXJuMQ8wDQYDVQQHEwZNdW5pY2gxDTALBgNVBAoTBEhvbWUxFTATBgNVBAsTDEFwYWNoZSBXU1M0SjEPMA0GA1UEAxMGV2VybmVyggkAuBIOAWJ19mwwDQYJKoZIhvcNAQEEBQADgYEAUiUh/wORVcQYXxIh13h3w2Btg6Kj2g6V6YO0Utc/gEYWwT310C2OuroKAwwoHapMIIWiJRclIAiA8Hnb0Sv/puuHYD4G4NWFdiVjRord90eZJe40NMGruRmlqIRIGGKCv+wv3E6Ux1cWW862f5H9Eyrcocke2P+3GNAGy83vghA=");
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            CertificateFactory factory = CertificateFactory.getInstance("X.509", "BC");
            X509Certificate cert = (X509Certificate)factory.generateCertificate(new ByteArrayInputStream(certBytes));
            Document doc = SOAPUtil.toSOAPPart((String)"<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
            WSSecHeader secHeader = new WSSecHeader(doc);
            secHeader.insertSecurityHeader();
            WSSecEncrypt encrypt = new WSSecEncrypt(secHeader);
            encrypt.setUseThisCert(cert);
            KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            SecretKey symmetricKey = keyGen.generateKey();
            Document encryptedDoc = encrypt.build(this.crypto, symmetricKey);
            if (LOG.isDebugEnabled()) {
                String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)encryptedDoc);
                LOG.debug(outputString);
            }
            try {
                this.verify(encryptedDoc);
                Assertions.fail((String)"Failure expected on encryption with a key that does not exist in the keystore");
            }
            catch (WSSecurityException ex) {
                Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
            }
        }
        finally {
            Security.removeProvider("BC");
        }
    }

    private void verify(Document doc) throws Exception {
        this.secEngine.processSecurityHeader(doc, null, this.callbackHandler, this.crypto);
        if (LOG.isDebugEnabled()) {
            LOG.debug("Verfied and decrypted message:");
            String outputString = org.apache.wss4j.common.util.XMLUtils.prettyDocumentToString((Document)doc);
            LOG.debug(outputString);
        }
    }
}

