/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.common;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.xml.security.utils.XMLUtils;

public class SecretKeyCallbackHandler
implements CallbackHandler {
    private Map<String, byte[]> secrets = new HashMap<String, byte[]>();
    private byte[] outboundSecret;

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            if (callback instanceof WSPasswordCallback) {
                WSPasswordCallback pc = (WSPasswordCallback)callback;
                if (pc.getUsage() != 9 && pc.getUsage() != 6) continue;
                byte[] secret = this.secrets.get(pc.getIdentifier());
                if (secret == null) {
                    secret = this.outboundSecret;
                }
                pc.setKey(secret);
                break;
            }
            throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
        }
    }

    public void addSecretKey(String identifier, byte[] secretKey) {
        this.secrets.put(identifier, secretKey);
    }

    public void setOutboundSecret(byte[] secret) throws WSSecurityException {
        this.outboundSecret = secret;
        byte[] encodedBytes = KeyUtils.generateDigest((byte[])this.outboundSecret);
        String identifier = XMLUtils.encodeToString((byte[])encodedBytes);
        this.addSecretKey(identifier, this.outboundSecret);
    }
}

