/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.common;

import java.io.IOException;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.bean.AdviceBean;
import org.apache.wss4j.common.saml.bean.KeyInfoBean;
import org.apache.wss4j.common.saml.bean.SubjectBean;
import org.apache.wss4j.common.saml.bean.Version;
import org.apache.wss4j.dom.common.AbstractSAMLCallbackHandler;

public class SAML1CallbackHandler
extends AbstractSAMLCallbackHandler {
    public SAML1CallbackHandler() throws Exception {
        if (this.certs == null) {
            Crypto crypto = CryptoFactory.getInstance((String)"wss40.properties");
            CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
            cryptoType.setAlias("wss40");
            this.certs = crypto.getX509Certificates(cryptoType);
        }
        this.subjectName = "uid=joe,ou=people,ou=saml-demo,o=example.com";
        this.subjectQualifier = "www.example.com";
        this.confirmationMethod = "urn:oasis:names:tc:SAML:1.0:cm:sender-vouches";
        this.issuer = "www.example.com";
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (Callback callback : callbacks) {
            SubjectBean subjectBean;
            SAMLCallback samlCallback;
            if (callback instanceof SAMLCallback) {
                samlCallback = (SAMLCallback)callback;
                samlCallback.setSamlVersion(Version.SAML_11);
                samlCallback.setIssuer(this.issuer);
                if (this.conditions != null) {
                    samlCallback.setConditions(this.conditions);
                }
                samlCallback.setIssuerCrypto(this.getIssuerCrypto());
                samlCallback.setIssuerKeyName(this.getIssuerName());
                samlCallback.setIssuerKeyPassword(this.getIssuerPassword());
                if (this.getAssertionAdviceElement() != null) {
                    AdviceBean advice = new AdviceBean();
                    advice.getAssertions().add(this.getAssertionAdviceElement());
                    samlCallback.setAdvice(advice);
                }
                subjectBean = new SubjectBean(this.subjectName, this.subjectQualifier, this.confirmationMethod);
                if (this.subjectNameIDFormat != null) {
                    subjectBean.setSubjectNameIDFormat(this.subjectNameIDFormat);
                }
                if ("urn:oasis:names:tc:SAML:1.0:cm:holder-of-key".equals(this.confirmationMethod)) {
                    try {
                        KeyInfoBean keyInfo = this.createKeyInfo();
                        subjectBean.setKeyInfo(keyInfo);
                    }
                    catch (Exception ex) {
                        throw new IOException("Problem creating KeyInfo: " + ex.getMessage());
                    }
                }
            } else {
                throw new UnsupportedCallbackException(callback, "Unrecognized Callback");
            }
            this.createAndSetStatement(subjectBean, samlCallback);
            samlCallback.setSignAssertion(this.signAssertion);
        }
    }
}

