/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.common;

import java.security.cert.X509Certificate;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.crypto.KeyGenerator;
import javax.crypto.SecretKey;
import javax.security.auth.callback.CallbackHandler;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.saml.SAMLCallback;
import org.apache.wss4j.common.saml.bean.ActionBean;
import org.apache.wss4j.common.saml.bean.AttributeBean;
import org.apache.wss4j.common.saml.bean.AttributeStatementBean;
import org.apache.wss4j.common.saml.bean.AuthDecisionStatementBean;
import org.apache.wss4j.common.saml.bean.AuthenticationStatementBean;
import org.apache.wss4j.common.saml.bean.ConditionsBean;
import org.apache.wss4j.common.saml.bean.KeyInfoBean;
import org.apache.wss4j.common.saml.bean.NameIDBean;
import org.apache.wss4j.common.saml.bean.SubjectBean;
import org.apache.wss4j.common.saml.bean.SubjectConfirmationDataBean;
import org.apache.wss4j.common.saml.bean.SubjectLocalityBean;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.dom.message.WSSecEncryptedKey;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public abstract class AbstractSAMLCallbackHandler
implements CallbackHandler {
    protected String subjectName;
    protected String subjectQualifier;
    protected String confirmationMethod;
    protected X509Certificate[] certs;
    protected Statement statement = Statement.AUTHN;
    protected KeyInfoBean.CERT_IDENTIFIER certIdentifier = KeyInfoBean.CERT_IDENTIFIER.X509_CERT;
    protected byte[] ephemeralKey;
    protected String issuer;
    protected String issuerFormat;
    protected String subjectNameIDFormat;
    protected String subjectLocalityIpAddress;
    protected String subjectLocalityDnsAddress;
    protected Instant sessionNotOnOrAfter;
    protected Instant authenticationInstant;
    protected String resource;
    protected List<Object> customAttributeValues;
    protected ConditionsBean conditions;
    protected SubjectConfirmationDataBean subjectConfirmationData;
    private Crypto issuerCrypto;
    private String issuerName;
    private String issuerPassword;
    private Element assertionAdviceElement;
    private Element keyInfoElement;
    protected NameIDBean subjectConfirmationNameID;
    protected boolean signAssertion;

    public boolean isSignAssertion() {
        return this.signAssertion;
    }

    public void setSignAssertion(boolean signAssertion) {
        this.signAssertion = signAssertion;
    }

    public void setSubjectName(String subjectName) {
        this.subjectName = subjectName;
    }

    public NameIDBean getSubjectConfirmationNameID() {
        return this.subjectConfirmationNameID;
    }

    public void setSubjectConfirmationNameID(NameIDBean subjectConfirmationNameID) {
        this.subjectConfirmationNameID = subjectConfirmationNameID;
    }

    public void setSubjectConfirmationData(SubjectConfirmationDataBean subjectConfirmationData) {
        this.subjectConfirmationData = subjectConfirmationData;
    }

    public void setConditions(ConditionsBean conditionsBean) {
        this.conditions = conditionsBean;
    }

    public void setConfirmationMethod(String confMethod) {
        this.confirmationMethod = confMethod;
    }

    public void setSessionNotOnOrAfter(Instant sessionNotOnOrAfter) {
        this.sessionNotOnOrAfter = sessionNotOnOrAfter;
    }

    public void setStatement(Statement statement) {
        this.statement = statement;
    }

    public void setCertIdentifier(KeyInfoBean.CERT_IDENTIFIER certIdentifier) {
        this.certIdentifier = certIdentifier;
    }

    public void setCerts(X509Certificate[] certs) {
        this.certs = certs;
    }

    public byte[] getEphemeralKey() {
        return this.ephemeralKey;
    }

    public void setIssuer(String issuer) {
        this.issuer = issuer;
    }

    public void setIssuerFormat(String issuerFormat) {
        this.issuerFormat = issuerFormat;
    }

    public void setSubjectNameIDFormat(String subjectNameIDFormat) {
        this.subjectNameIDFormat = subjectNameIDFormat;
    }

    public void setSubjectLocality(String ipAddress, String dnsAddress) {
        this.subjectLocalityIpAddress = ipAddress;
        this.subjectLocalityDnsAddress = dnsAddress;
    }

    public void setResource(String resource) {
        this.resource = resource;
    }

    public void setCustomAttributeValues(List<Object> customAttributeValues) {
        this.customAttributeValues = customAttributeValues;
    }

    public Instant getAuthenticationInstant() {
        return this.authenticationInstant;
    }

    public void setAuthenticationInstant(Instant authenticationInstant) {
        this.authenticationInstant = authenticationInstant;
    }

    protected void createAndSetStatement(SubjectBean subjectBean, SAMLCallback callback) {
        if (this.statement == Statement.AUTHN) {
            AuthenticationStatementBean authBean = new AuthenticationStatementBean();
            if (subjectBean != null) {
                authBean.setSubject(subjectBean);
            }
            if (this.subjectLocalityIpAddress != null || this.subjectLocalityDnsAddress != null) {
                SubjectLocalityBean subjectLocality = new SubjectLocalityBean();
                subjectLocality.setIpAddress(this.subjectLocalityIpAddress);
                subjectLocality.setDnsAddress(this.subjectLocalityDnsAddress);
                authBean.setSubjectLocality(subjectLocality);
            }
            authBean.setAuthenticationMethod("Password");
            authBean.setAuthenticationInstant(this.authenticationInstant);
            authBean.setSessionNotOnOrAfter(this.sessionNotOnOrAfter);
            callback.setAuthenticationStatementData(Collections.singletonList(authBean));
        } else if (this.statement == Statement.ATTR) {
            AttributeStatementBean attrBean = new AttributeStatementBean();
            AttributeBean attributeBean = new AttributeBean();
            if (subjectBean != null) {
                attrBean.setSubject(subjectBean);
                attributeBean.setSimpleName("role");
                attributeBean.setQualifiedName("http://custom-ns");
            } else {
                attributeBean.setQualifiedName("role");
            }
            if (this.customAttributeValues != null) {
                attributeBean.setAttributeValues(this.customAttributeValues);
            } else {
                ArrayList<String> attributes = new ArrayList<String>();
                attributes.add("user");
                attributeBean.setAttributeValues(attributes);
            }
            attrBean.setSamlAttributes(Collections.singletonList(attributeBean));
            callback.setAttributeStatementData(Collections.singletonList(attrBean));
        } else {
            AuthDecisionStatementBean authzBean = new AuthDecisionStatementBean();
            if (subjectBean != null) {
                authzBean.setSubject(subjectBean);
            }
            ActionBean actionBean = new ActionBean();
            actionBean.setContents("Read");
            authzBean.setActions(Collections.singletonList(actionBean));
            authzBean.setResource("endpoint");
            authzBean.setDecision(AuthDecisionStatementBean.Decision.PERMIT);
            authzBean.setResource(this.resource);
            callback.setAuthDecisionStatementData(Collections.singletonList(authzBean));
        }
    }

    protected KeyInfoBean createKeyInfo() throws Exception {
        KeyInfoBean keyInfo = new KeyInfoBean();
        if (this.keyInfoElement != null) {
            keyInfo.setElement(this.keyInfoElement);
        } else if (this.statement == Statement.AUTHN) {
            keyInfo.setCertificate(this.certs[0]);
            keyInfo.setCertIdentifer(this.certIdentifier);
        } else if (this.statement == Statement.ATTR) {
            DocumentBuilderFactory docBuilderFactory = DocumentBuilderFactory.newInstance();
            docBuilderFactory.setNamespaceAware(true);
            DocumentBuilder docBuilder = docBuilderFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            WSSecEncryptedKey encrKey = new WSSecEncryptedKey(doc);
            encrKey.setKeyIdentifierType(2);
            encrKey.setUseThisCert(this.certs[0]);
            KeyGenerator keyGen = KeyUtils.getKeyGenerator((String)"http://www.w3.org/2001/04/xmlenc#aes128-cbc");
            SecretKey symmetricKey = keyGen.generateKey();
            encrKey.prepare(null, symmetricKey);
            this.ephemeralKey = symmetricKey.getEncoded();
            Element encryptedKeyElement = encrKey.getEncryptedKeyElement();
            Element kiElement = doc.createElementNS("http://www.w3.org/2000/09/xmldsig#", "ds:KeyInfo");
            kiElement.setAttributeNS("http://www.w3.org/2000/xmlns/", "xmlns:ds", "http://www.w3.org/2000/09/xmldsig#");
            kiElement.appendChild(encryptedKeyElement);
            keyInfo.setElement(kiElement);
        }
        return keyInfo;
    }

    public Crypto getIssuerCrypto() {
        return this.issuerCrypto;
    }

    public void setIssuerCrypto(Crypto issuerCrypto) {
        this.issuerCrypto = issuerCrypto;
    }

    public String getIssuerName() {
        return this.issuerName;
    }

    public void setIssuerName(String issuerName) {
        this.issuerName = issuerName;
    }

    public String getIssuerPassword() {
        return this.issuerPassword;
    }

    public void setIssuerPassword(String issuerPassword) {
        this.issuerPassword = issuerPassword;
    }

    public Element getAssertionAdviceElement() {
        return this.assertionAdviceElement;
    }

    public void setAssertionAdviceElement(Element assertionAdviceElement) {
        this.assertionAdviceElement = assertionAdviceElement;
    }

    public Element getKeyInfoElement() {
        return this.keyInfoElement;
    }

    public void setKeyInfoElement(Element keyInfoElement) {
        this.keyInfoElement = keyInfoElement;
    }

    public static enum Statement {
        AUTHN,
        ATTR,
        AUTHZ;

    }
}

