/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.dom.processor;

import java.io.IOException;
import javax.crypto.SecretKey;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.wss4j.common.ext.WSPasswordCallback;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.KeyUtils;
import org.apache.wss4j.common.util.XMLUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public final class X509Util {
    private static final Logger LOG = LoggerFactory.getLogger(X509Util.class);

    private X509Util() {
    }

    public static boolean isContent(Node encBodyData) {
        String typeStr;
        if (encBodyData != null && (typeStr = ((Element)encBodyData).getAttributeNS(null, "Type")) != null) {
            return typeStr.equals("http://www.w3.org/2001/04/xmlenc#Content");
        }
        return false;
    }

    public static String getEncAlgo(Node encBodyData) throws WSSecurityException {
        Element tmpE = XMLUtils.getDirectChildElement((Node)encBodyData, (String)"EncryptionMethod", (String)"http://www.w3.org/2001/04/xmlenc#");
        String symEncAlgo = null;
        if (tmpE != null && ((symEncAlgo = tmpE.getAttributeNS(null, "Algorithm")) == null || "".equals(symEncAlgo))) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.UNSUPPORTED_ALGORITHM, "noEncAlgo", new Object[0]);
        }
        if (LOG.isDebugEnabled()) {
            LOG.debug("Sym Enc Algo: " + symEncAlgo);
        }
        return symEncAlgo;
    }

    protected static SecretKey getSharedKey(Element keyInfoElem, String algorithm, CallbackHandler cb) throws WSSecurityException {
        String keyName = null;
        Element keyNmElem = XMLUtils.getDirectChildElement((Node)keyInfoElem, (String)"KeyName", (String)"http://www.w3.org/2000/09/xmldsig#");
        if (keyNmElem != null) {
            keyName = XMLUtils.getElementText((Element)keyNmElem);
        }
        if (keyName == null || keyName.length() <= 0) {
            LOG.debug("No Key Name available");
        }
        WSPasswordCallback pwCb = new WSPasswordCallback(keyName, 9);
        try {
            cb.handle(new Callback[]{pwCb});
        }
        catch (IOException | UnsupportedCallbackException e) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noPassword", e, new Object[]{keyName});
        }
        byte[] decryptedData = pwCb.getKey();
        if (decryptedData == null) {
            throw new WSSecurityException(WSSecurityException.ErrorCode.FAILURE, "noPassword", new Object[]{keyName});
        }
        return KeyUtils.prepareSecretKey((String)algorithm, (byte[])decryptedData);
    }
}

