/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.util;

import jakarta.xml.soap.MessageFactory;
import jakarta.xml.soap.SOAPPart;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Document;

public class SOAPUtil {
    public static final String SAMPLE_SOAP_MSG = "<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>";
    private static final Logger LOG = LoggerFactory.getLogger(SOAPUtil.class);
    private static DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
    private static MessageFactory saajFactory = null;

    public static Document toSOAPPart(String xml) throws Exception {
        try (ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());){
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(in);
            return document;
        }
    }

    public static Document toSOAPPart(InputStream in) throws Exception {
        DocumentBuilder builder = factory.newDocumentBuilder();
        return builder.parse(in);
    }

    public static SOAPPart toSAAJSOAPPart(String xml) throws Exception {
        try (ByteArrayInputStream in = new ByteArrayInputStream(xml.getBytes());){
            SOAPPart sOAPPart = saajFactory.createMessage(null, (InputStream)in).getSOAPPart();
            return sOAPPart;
        }
    }

    static {
        factory.setNamespaceAware(true);
        try {
            saajFactory = MessageFactory.newInstance();
        }
        catch (Exception e) {
            LOG.debug("can't create SAAJ MessageFactory", (Throwable)e);
        }
    }
}

