/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.security.InvalidAlgorithmParameterException;
import java.security.KeyStore;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.PKIXParameters;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import javax.security.auth.x500.X500Principal;
import org.apache.wss4j.common.util.CommaDelimiterRfc2253Name;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class CommaDelimiterRfc2253NameTest {
    private static final String TYPICAL_CA = "CN=Entrust Certification Authority - L1K,OU=(c) 2012 Entrust\\, Inc. - for authorized use only,OU=See www.entrust.net/legal-terms,O=Entrust\\, Inc.,C=US";
    private static final String QUOTES_TYPICAL_CA = "CN=Entrust Certification Authority - L1K, OU=\"(c) 2012 Entrust, Inc. - for authorized use only\", OU=See www.entrust.net/legal-terms, O=\"Entrust, Inc.\", C=US";
    private CommaDelimiterRfc2253Name subject = new CommaDelimiterRfc2253Name();

    CommaDelimiterRfc2253NameTest() {
    }

    @Test
    void whenMultipleAttributesArePresentThenSpaceIsPlacedAfterComma() {
        String actual = new CommaDelimiterRfc2253Name().execute("CN=EOIR,OU=Some Unit,DC=Another place");
        Assertions.assertEquals((Object)"CN=EOIR, OU=Some Unit, DC=Another place", (Object)actual);
    }

    @Test
    void whenRdnContainsACommaThenTheRdnIsSurroundedByDoubleQuotes() {
        String actual = new CommaDelimiterRfc2253Name().execute(TYPICAL_CA);
        Assertions.assertEquals((Object)QUOTES_TYPICAL_CA, (Object)actual);
    }

    @Test
    void whenRdnIsInvalidThenExpectException() {
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.subject.execute("invalid"));
    }

    @Test
    void whenCallingUnescapeWithStringNoEscapesThenNoChangesAreMade() throws Exception {
        String input = "This is a string with (c) no escaped! sStrings $";
        String actual = this.subject.unEscapeRfc2253RdnSubPart(input);
        Assertions.assertEquals((Object)input, (Object)actual, (String)"Expect that string is unchanged");
    }

    @Test
    void whenCallingUnescapeWithStringThenItUnescapesAppropiateCharacters() throws Exception {
        String input = "This is a string with escapes \\,\\; \\\\ and \\< then \\> \\\"Copyright Apache\\\" ";
        String expected = "This is a string with escapes ,; \\ and < then > \"Copyright Apache\" ";
        String actual = this.subject.unEscapeRfc2253RdnSubPart(input);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)"Expect that string is unescaped");
    }

    @Test
    void whenCallingUnescapeWithStringWithMultiValueRdnThenItUnescapesAppropriateCharacters() throws Exception {
        String input = "OU=Sales\\+CN=J. Smith\\,O=Widget Inc.\\,C=US";
        String expected = "OU=Sales+CN=J. Smith,O=Widget Inc.,C=US";
        String actual = this.subject.unEscapeRfc2253RdnSubPart(input);
        Assertions.assertEquals((Object)expected, (Object)actual, (String)"Expect that string is unescaped");
    }

    @Test
    public void testThatACommaDelimitedDnStringAndABackSlashEscapedDnProducesTheSameX509PrincipalUsingDefaultTruststore() throws KeyStoreException, InvalidAlgorithmParameterException, CertificateException, NoSuchAlgorithmException, IOException {
        KeyStore keystore = this.loadDefaultKeyStore();
        PKIXParameters params = new PKIXParameters(keystore);
        for (TrustAnchor ta : params.getTrustAnchors()) {
            X509Certificate cert = ta.getTrustedCert();
            this.assertThatTransformIsEquivalent(cert.getSubjectX500Principal().getName());
        }
    }

    private void assertThatTransformIsEquivalent(String dnString) {
        X500Principal expected = new X500Principal(dnString);
        X500Principal recreatedX509principal = new X500Principal(this.subject.execute(dnString));
        Assertions.assertEquals((Object)expected, (Object)recreatedX509principal);
    }

    private KeyStore loadDefaultKeyStore() throws IOException, KeyStoreException, CertificateException, NoSuchAlgorithmException {
        String filename = System.getProperty("java.home") + "/lib/security/cacerts".replace('/', File.separatorChar);
        FileInputStream is = new FileInputStream(filename);
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        String password = "changeit";
        keystore.load(is, password.toCharArray());
        return keystore;
    }
}

