/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.token;

import java.math.BigInteger;
import org.apache.wss4j.common.token.DOMX509IssuerSerial;
import org.apache.wss4j.common.util.SOAPUtil;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.w3c.dom.Document;

class DOMX509IssuerSerialTest {
    DOMX509IssuerSerialTest() {
    }

    @Test
    public void whenConstructingForWsSecUsersUsingConstructorThenUseDefaultIssuerDelimiting() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        String input = "CN=EOIR,OU=Some Unit";
        BigInteger serialNumber = new BigInteger("123");
        DOMX509IssuerSerial subject = new DOMX509IssuerSerial(doc, input, serialNumber);
        String expected = "CN=EOIR,OU=Some Unit";
        Assertions.assertEquals((Object)expected, (Object)subject.getIssuer());
    }

    @Test
    public void whenConstructingForWsSecUsersUsingNewConstructorWithCommaDelimitedThenUseWcfCompatibleDelimiting() throws Exception {
        Document doc = SOAPUtil.toSOAPPart("<?xml version=\"1.0\" encoding=\"UTF-8\"?><SOAP-ENV:Envelope xmlns:SOAP-ENV=\"http://schemas.xmlsoap.org/soap/envelope/\" xmlns:xsd=\"http://www.w3.org/2001/XMLSchema\" xmlns:xsi=\"http://www.w3.org/2001/XMLSchema-instance\"><SOAP-ENV:Body><add xmlns=\"http://ws.apache.org/counter/counter_port_type\"><value xmlns=\"\">15</value></add></SOAP-ENV:Body></SOAP-ENV:Envelope>");
        String input = "CN=EOIR,OU=Some Unit";
        BigInteger serialNumber = new BigInteger("123");
        DOMX509IssuerSerial subject = new DOMX509IssuerSerial(doc, input, serialNumber, true);
        String expected = "CN=EOIR, OU=Some Unit";
        Assertions.assertEquals((Object)expected, (Object)subject.getIssuer());
        System.out.println(subject.getIssuer());
    }
}

