/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.crypto;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.X509Certificate;
import org.apache.wss4j.common.crypto.Crypto;
import org.apache.wss4j.common.crypto.CryptoFactory;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.util.Loader;
import org.apache.xml.security.utils.XMLUtils;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class SKITest {
    @Test
    public void testRSA1024() throws Exception {
        Merlin crypto = new Merlin();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ClassLoader loader = Loader.getClassLoader(SKITest.class);
        InputStream input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/rsa1024.jks");
        keyStore.load(input, "security".toCharArray());
        input.close();
        crypto.setKeyStore(keyStore);
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
        Assertions.assertTrue((certs != null && certs.length > 0 ? 1 : 0) != 0);
        byte[] skiBytes = crypto.getSKIBytesFromCert(certs[0]);
        String knownBase64Encoding = "H7dt0lv9M8uYOy4SedV0kPOs22A=";
        Assertions.assertTrue((boolean)knownBase64Encoding.equals(XMLUtils.encodeToString((byte[])skiBytes)));
    }

    @Test
    public void testRSA2048() throws Exception {
        Merlin crypto = new Merlin();
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ClassLoader loader = Loader.getClassLoader(SKITest.class);
        InputStream input = Merlin.loadInputStream((ClassLoader)loader, (String)"keys/wss40_server.jks");
        keyStore.load(input, "security".toCharArray());
        input.close();
        crypto.setKeyStore(keyStore);
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40_server");
        X509Certificate[] certs = crypto.getX509Certificates(cryptoType);
        Assertions.assertTrue((certs != null && certs.length > 0 ? 1 : 0) != 0);
        byte[] skiBytes = crypto.getSKIBytesFromCert(certs[0]);
        String knownBase64Encoding = "5LsTsLDSb7XxlaCffjNBHM5n+1A=";
        Assertions.assertTrue((boolean)knownBase64Encoding.equals(XMLUtils.encodeToString((byte[])skiBytes)));
    }

    @Test
    public void testBouncyCastlePKCS12() throws Exception {
        try {
            Security.addProvider((Provider)new BouncyCastleProvider());
            Crypto crypto = CryptoFactory.getInstance((String)"alice_bouncycastle.properties");
            Assertions.assertNotNull((Object)crypto);
        }
        finally {
            Security.removeProvider("BC");
        }
    }
}

