/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.crypto;

import java.io.IOException;
import java.io.InputStream;
import java.security.KeyStore;
import java.security.Provider;
import java.security.Security;
import java.security.cert.Certificate;
import java.security.cert.TrustAnchor;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import java.util.regex.Pattern;
import org.apache.wss4j.common.crypto.CertificateStore;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.crypto.MerlinAKI;
import org.apache.wss4j.common.crypto.WSProviderConfig;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.Loader;
import org.bouncycastle.jce.provider.BouncyCastleProvider;
import org.hamcrest.Matcher;
import org.hamcrest.MatcherAssert;
import org.hamcrest.core.Is;
import org.hamcrest.core.IsEqual;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Assumptions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;

public class NameConstraintsTest {
    private static final String KEY_ROOT = "keys/nameconstraints/";
    private static final String SELF_SIGNED = "keys/nameconstraints/self_signed.p12";
    private static final String ROOT_SIGNED = "keys/nameconstraints/root_signed.p12";
    private static final String INTERMEDIATE_SIGNED = "keys/nameconstraints/intermediate_signed.p12";
    private static final String KEYSTORE = "keys/nameconstraints/nameconstraints.jks";
    private static final char[] PASSWORD = "changeit".toCharArray();
    private static final Pattern SUBJ_PATTERN = Pattern.compile(".*OU=wss4j,O=apache");
    private boolean isIBMJdK = System.getProperty("java.vendor").contains("IBM");

    @BeforeEach
    public void setup() throws Exception {
        WSProviderConfig.init();
    }

    private KeyStore getRootKeyStore() throws Exception {
        ClassLoader loader = Loader.getClassLoader(NameConstraintsTest.class);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream inputStream = Merlin.loadInputStream((ClassLoader)loader, (String)KEYSTORE);){
            keyStore.load(inputStream, PASSWORD);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    private KeyStore getSelfKeyStore() throws Exception {
        ClassLoader loader = Loader.getClassLoader(NameConstraintsTest.class);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream inputStream = loader.getResourceAsStream(SELF_SIGNED);){
            keyStore.load(inputStream, PASSWORD);
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    private X509Certificate[] getTestCertificateChain(String keychainPath) throws Exception {
        ClassLoader loader = Loader.getClassLoader(NameConstraintsTest.class);
        KeyStore keystore = KeyStore.getInstance(KeyStore.getDefaultType());
        try (InputStream inputStream = loader.getResourceAsStream(keychainPath);){
            keystore.load(inputStream, PASSWORD);
            Enumeration<String> aliases = keystore.aliases();
            Certificate[] certificates = keystore.getCertificateChain(aliases.nextElement());
            Assertions.assertNotNull((Object)certificates);
            X509Certificate[] x509Certificates = new X509Certificate[certificates.length];
            System.arraycopy(certificates, 0, x509Certificates, 0, certificates.length);
            X509Certificate[] x509CertificateArray = x509Certificates;
            return x509CertificateArray;
        }
    }

    @Test
    public void testNameConstraints() throws Exception {
        Assumptions.assumeFalse((boolean)this.isIBMJdK);
        Merlin merlin = new Merlin();
        X509Certificate[] certificates = this.getTestCertificateChain(INTERMEDIATE_SIGNED);
        Assertions.assertNull((Object)merlin.getNameConstraints(certificates[0]));
        Assertions.assertNull((Object)merlin.getNameConstraints(certificates[1]));
        byte[] nameConstraints = merlin.getNameConstraints(certificates[2]);
        Assertions.assertNotNull((Object)nameConstraints);
        MatcherAssert.assertThat((String)"Tag byte is wrong", (Object)nameConstraints[0], (Matcher)Is.is((Object)48));
        TrustAnchor trustAnchor = new TrustAnchor(certificates[2], nameConstraints);
        MatcherAssert.assertThat((String)"TrustAnchor constraints wrong", (Object)trustAnchor.getNameConstraints(), (Matcher)IsEqual.equalTo((Object)nameConstraints));
    }

    @Test
    public void testNameConstraintsWithKeyStoreUsingMerlin() throws Exception {
        Assumptions.assumeFalse((boolean)this.isIBMJdK);
        this.withKeyStoreUsingMerlin(this.getSelfKeyStore(), this.getTestCertificateChain(SELF_SIGNED), new Merlin());
        this.withKeyStoreUsingMerlin(this.getRootKeyStore(), this.getTestCertificateChain(ROOT_SIGNED), new Merlin());
        this.withKeyStoreUsingMerlin(this.getRootKeyStore(), this.getTestCertificateChain(INTERMEDIATE_SIGNED), new Merlin());
    }

    @Test
    public void testNameConstraintsWithTrustStoreUsingMerlin() throws Exception {
        Assumptions.assumeFalse((boolean)this.isIBMJdK);
        this.withTrustStoreUsingMerlin(this.getSelfKeyStore(), this.getTestCertificateChain(SELF_SIGNED), new Merlin());
        this.withTrustStoreUsingMerlin(this.getRootKeyStore(), this.getTestCertificateChain(ROOT_SIGNED), new Merlin());
        this.withTrustStoreUsingMerlin(this.getRootKeyStore(), this.getTestCertificateChain(INTERMEDIATE_SIGNED), new Merlin());
    }

    @Test
    public void testNameConstraintsWithKeyStoreUsingMerlinAki() throws Exception {
        Assumptions.assumeFalse((boolean)this.isIBMJdK);
        this.withKeyStoreUsingMerlinAKI(this.getSelfKeyStore(), this.getTestCertificateChain(SELF_SIGNED), new MerlinAKI());
        this.withKeyStoreUsingMerlinAKI(this.getRootKeyStore(), this.getTestCertificateChain(ROOT_SIGNED), new MerlinAKI());
        this.withKeyStoreUsingMerlinAKI(this.getRootKeyStore(), this.getTestCertificateChain(INTERMEDIATE_SIGNED), new MerlinAKI());
    }

    @Test
    public void testNameConstraintsWithTrustStoreUsingMerlinAki() throws Exception {
        Assumptions.assumeFalse((boolean)this.isIBMJdK);
        this.withTrustStoreUsingMerlinAKI(this.getSelfKeyStore(), this.getTestCertificateChain(SELF_SIGNED), new MerlinAKI());
        this.withTrustStoreUsingMerlinAKI(this.getRootKeyStore(), this.getTestCertificateChain(ROOT_SIGNED), new MerlinAKI());
        this.withTrustStoreUsingMerlinAKI(this.getRootKeyStore(), this.getTestCertificateChain(INTERMEDIATE_SIGNED), new MerlinAKI());
    }

    @Test
    public void testNameConstraintsWithKeyStoreUsingMerlinBc() throws Exception {
        Assumptions.assumeFalse((boolean)this.isIBMJdK);
        this.withKeyStoreUsingMerlin(this.getSelfKeyStore(), this.getTestCertificateChain(SELF_SIGNED), this.getMerlinBc());
        this.withKeyStoreUsingMerlin(this.getRootKeyStore(), this.getTestCertificateChain(ROOT_SIGNED), this.getMerlinBc());
        this.withKeyStoreUsingMerlin(this.getRootKeyStore(), this.getTestCertificateChain(INTERMEDIATE_SIGNED), this.getMerlinBc());
    }

    @Test
    public void testNameConstraintsWithTrustStoreUsingMerlinBc() throws Exception {
        Assumptions.assumeFalse((boolean)this.isIBMJdK);
        this.withTrustStoreUsingMerlin(this.getSelfKeyStore(), this.getTestCertificateChain(SELF_SIGNED), this.getMerlinBc());
        this.withTrustStoreUsingMerlin(this.getRootKeyStore(), this.getTestCertificateChain(ROOT_SIGNED), this.getMerlinBc());
        this.withTrustStoreUsingMerlin(this.getRootKeyStore(), this.getTestCertificateChain(INTERMEDIATE_SIGNED), this.getMerlinBc());
    }

    @Test
    public void testNameConstraintsWithKeyStoreUsingMerlinAkiBc() throws Exception {
        Assumptions.assumeFalse((boolean)this.isIBMJdK);
        this.withKeyStoreUsingMerlinAKI(this.getSelfKeyStore(), this.getTestCertificateChain(SELF_SIGNED), this.getMerlinAkiBc());
        this.withKeyStoreUsingMerlinAKI(this.getRootKeyStore(), this.getTestCertificateChain(ROOT_SIGNED), this.getMerlinAkiBc());
        this.withKeyStoreUsingMerlinAKI(this.getRootKeyStore(), this.getTestCertificateChain(INTERMEDIATE_SIGNED), this.getMerlinAkiBc());
    }

    @Test
    public void testNameConstraintsWithTrustStoreUsingMerlinAkiBc() throws Exception {
        Assumptions.assumeFalse((boolean)this.isIBMJdK);
        this.withTrustStoreUsingMerlinAKI(this.getSelfKeyStore(), this.getTestCertificateChain(SELF_SIGNED), this.getMerlinAkiBc());
        this.withTrustStoreUsingMerlinAKI(this.getRootKeyStore(), this.getTestCertificateChain(ROOT_SIGNED), this.getMerlinAkiBc());
        this.withTrustStoreUsingMerlinAKI(this.getRootKeyStore(), this.getTestCertificateChain(INTERMEDIATE_SIGNED), this.getMerlinAkiBc());
    }

    @Test
    public void testNameConstraintsWithKeyStoreUsingMerlinBreaking() throws Exception {
        Assumptions.assumeFalse((boolean)this.isIBMJdK);
        Properties properties = new Properties();
        properties.setProperty("org.apache.wss4j.crypto.merlin.cert.provider.nameconstraints", "true");
        Merlin merlin = new Merlin(properties, this.getClass().getClassLoader(), null);
        Assertions.assertThrows(Exception.class, () -> this.withKeyStoreUsingMerlin(this.getRootKeyStore(), this.getTestCertificateChain(ROOT_SIGNED), merlin));
    }

    @Test
    public void testNameConstraintsWithKeyStoreUsingMerlinAkiBreaking() throws Exception {
        Assumptions.assumeFalse((boolean)this.isIBMJdK);
        Properties properties = new Properties();
        properties.setProperty("org.apache.wss4j.crypto.merlin.cert.provider.nameconstraints", "true");
        MerlinAKI merlin = new MerlinAKI(properties, this.getClass().getClassLoader(), null);
        Assertions.assertThrows(Exception.class, () -> this.withKeyStoreUsingMerlin(this.getRootKeyStore(), this.getTestCertificateChain(ROOT_SIGNED), (Merlin)merlin));
    }

    @Test
    public void testNameConstraintsUsingCertificateStore() throws Exception {
        Assumptions.assumeFalse((boolean)this.isIBMJdK);
        this.usingCertificateStore(this.getSelfKeyStore(), this.getTestCertificateChain(SELF_SIGNED));
        this.usingCertificateStore(this.getRootKeyStore(), this.getTestCertificateChain(ROOT_SIGNED));
        this.usingCertificateStore(this.getRootKeyStore(), this.getTestCertificateChain(INTERMEDIATE_SIGNED));
    }

    private void withKeyStoreUsingMerlin(KeyStore keyStore, X509Certificate[] certificates, Merlin crypto) throws Exception {
        crypto.setKeyStore(keyStore);
        crypto.verifyTrust(certificates, false, Collections.singletonList(SUBJ_PATTERN));
    }

    private void withTrustStoreUsingMerlin(KeyStore keyStore, X509Certificate[] certificates, Merlin crypto) throws Exception {
        crypto.setTrustStore(keyStore);
        crypto.verifyTrust(certificates, false, Collections.singletonList(SUBJ_PATTERN));
    }

    private void withKeyStoreUsingMerlinAKI(KeyStore keyStore, X509Certificate[] certificates, MerlinAKI crypto) throws Exception {
        crypto.setKeyStore(keyStore);
        crypto.verifyTrust(certificates, false, Collections.singletonList(SUBJ_PATTERN));
    }

    private void withTrustStoreUsingMerlinAKI(KeyStore keyStore, X509Certificate[] certificates, MerlinAKI crypto) throws Exception {
        crypto.setTrustStore(keyStore);
        crypto.verifyTrust(certificates, false, Collections.singletonList(SUBJ_PATTERN));
    }

    private void usingCertificateStore(KeyStore keyStore, X509Certificate[] certificates) throws Exception {
        Enumeration<String> aliases = keyStore.aliases();
        ArrayList<X509Certificate> certList = new ArrayList<X509Certificate>();
        while (aliases.hasMoreElements()) {
            String alias = aliases.nextElement();
            certList.add((X509Certificate)keyStore.getCertificate(alias));
        }
        CertificateStore crypto = new CertificateStore(certList.toArray(new X509Certificate[0]));
        crypto.verifyTrust(certificates, false, Collections.singletonList(SUBJ_PATTERN));
    }

    private Merlin getMerlinBc() throws WSSecurityException, IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Properties properties = new Properties();
        properties.setProperty("org.apache.wss4j.crypto.merlin.cert.provider", "BC");
        properties.setProperty("org.apache.wss4j.crypto.merlin.cert.provider.nameconstraints", "true");
        return new Merlin(properties, this.getClass().getClassLoader(), null);
    }

    private MerlinAKI getMerlinAkiBc() throws WSSecurityException, IOException {
        Security.addProvider((Provider)new BouncyCastleProvider());
        Properties properties = new Properties();
        properties.setProperty("org.apache.wss4j.crypto.merlin.cert.provider", "BC");
        properties.setProperty("org.apache.wss4j.crypto.merlin.cert.provider.nameconstraints", "true");
        return new MerlinAKI(properties, this.getClass().getClassLoader(), null);
    }
}

