/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.crypto;

import java.io.InputStream;
import java.security.KeyStore;
import org.apache.wss4j.common.crypto.CryptoType;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.crypto.WSProviderConfig;
import org.apache.wss4j.common.util.Loader;
import org.junit.jupiter.api.AfterAll;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.RepeatedTest;

public class MerlinTest {
    private static Merlin jksCrypto = new Merlin();
    private static Merlin pkcs12Crypto = new Merlin();

    @BeforeAll
    public static void setup() throws Exception {
        WSProviderConfig.init();
        KeyStore keyStore = MerlinTest.loadKeyStore("keys/wss40.jks", "security");
        jksCrypto.setKeyStore(keyStore);
        KeyStore pkcs12KeyStore = MerlinTest.loadKeyStore("keys/wss40.p12", "security");
        pkcs12Crypto.setKeyStore(pkcs12KeyStore);
    }

    @AfterAll
    public static void cleanup() {
        jksCrypto.clearCache();
        pkcs12Crypto.clearCache();
    }

    @RepeatedTest(value=1000)
    public void testGetPrivateKeyJKS() throws Exception {
        Assertions.assertNotNull((Object)jksCrypto.getPrivateKey("wss40", "security"));
    }

    @RepeatedTest(value=1000)
    public void testGetPrivateKeyPKCS12() throws Exception {
        Assertions.assertNotNull((Object)pkcs12Crypto.getPrivateKey("wss40", "security"));
    }

    @RepeatedTest(value=1000)
    public void testGetCertificateJKS() throws Exception {
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        Assertions.assertNotNull((Object)jksCrypto.getX509Certificates(cryptoType));
    }

    @RepeatedTest(value=1000)
    public void testGetCertificatePKCS12() throws Exception {
        CryptoType cryptoType = new CryptoType(CryptoType.TYPE.ALIAS);
        cryptoType.setAlias("wss40");
        Assertions.assertNotNull((Object)pkcs12Crypto.getX509Certificates(cryptoType));
    }

    private static KeyStore loadKeyStore(String path, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ClassLoader loader = Loader.getClassLoader(MerlinTest.class);
        InputStream input = Merlin.loadInputStream((ClassLoader)loader, (String)path);
        keyStore.load(input, password.toCharArray());
        input.close();
        return keyStore;
    }
}

