/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.crypto;

import java.io.InputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.Arrays;
import org.apache.wss4j.common.crypto.BouncyCastleUtils;
import org.apache.wss4j.common.crypto.Merlin;
import org.apache.wss4j.common.crypto.MerlinAKI;
import org.apache.wss4j.common.crypto.WSProviderConfig;
import org.apache.wss4j.common.ext.WSSecurityException;
import org.apache.wss4j.common.util.Loader;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AuthorityKeyIdentifierTest {
    public AuthorityKeyIdentifierTest() {
        WSProviderConfig.init();
    }

    @Test
    public void testExtractKeyIdentifiers() throws Exception {
        KeyStore keyStore = this.loadKeyStore("keys/wss40.jks", "security");
        Assertions.assertNotNull((Object)keyStore);
        X509Certificate cert = (X509Certificate)keyStore.getCertificate("wss40");
        Assertions.assertNotNull((Object)cert);
        byte[] keyIdentifierBytes = BouncyCastleUtils.getAuthorityKeyIdentifierBytes((X509Certificate)cert);
        Assertions.assertNotNull((Object)keyIdentifierBytes);
        KeyStore caKeyStore = this.loadKeyStore("keys/wss40CA.jks", "security");
        Assertions.assertNotNull((Object)caKeyStore);
        X509Certificate caCert = (X509Certificate)caKeyStore.getCertificate("wss40CA");
        Assertions.assertNotNull((Object)caCert);
        byte[] subjectKeyIdentifierBytes = BouncyCastleUtils.getSubjectKeyIdentifierBytes((X509Certificate)caCert);
        Assertions.assertNotNull((Object)subjectKeyIdentifierBytes);
        Assertions.assertTrue((boolean)Arrays.equals(keyIdentifierBytes, subjectKeyIdentifierBytes));
    }

    @Test
    public void testMerlinAKI() throws Exception {
        KeyStore keyStore = this.loadKeyStore("keys/wss40.jks", "security");
        Assertions.assertNotNull((Object)keyStore);
        X509Certificate cert = (X509Certificate)keyStore.getCertificate("wss40");
        Assertions.assertNotNull((Object)cert);
        KeyStore caKeyStore = this.loadKeyStore("keys/wss40CA.jks", "security");
        Assertions.assertNotNull((Object)caKeyStore);
        MerlinAKI crypto = new MerlinAKI();
        crypto.setTrustStore(caKeyStore);
        crypto.verifyTrust(new X509Certificate[]{cert}, false, null);
        KeyStore badKeyStore = this.loadKeyStore("keys/wss86.keystore", "security");
        Assertions.assertNotNull((Object)badKeyStore);
        X509Certificate badCert = (X509Certificate)badKeyStore.getCertificate("wss86");
        Assertions.assertNotNull((Object)badCert);
        try {
            crypto.verifyTrust(new X509Certificate[]{badCert}, false, null);
            Assertions.fail((String)"Failure expected on trying to validate an untrusted cert");
        }
        catch (WSSecurityException ex) {
            Assertions.assertTrue((ex.getErrorCode() == WSSecurityException.ErrorCode.FAILURE ? 1 : 0) != 0);
        }
    }

    private KeyStore loadKeyStore(String path, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        ClassLoader loader = Loader.getClassLoader(AuthorityKeyIdentifierTest.class);
        InputStream input = Merlin.loadInputStream((ClassLoader)loader, (String)path);
        keyStore.load(input, password.toCharArray());
        input.close();
        return keyStore;
    }
}

