/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.cache;

import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.util.UUID;
import org.apache.wss4j.common.cache.EHCacheReplayCache;
import org.apache.wss4j.common.cache.EHCacheValue;
import org.apache.wss4j.common.cache.MemoryReplayCache;
import org.apache.wss4j.common.cache.ReplayCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.io.TempDir;

public class ReplayCacheTest {
    @TempDir
    Path tempDir;

    @Test
    public void testMemoryReplayCache() throws InterruptedException, IOException {
        try (MemoryReplayCache replayCache = new MemoryReplayCache();){
            this.testReplayCacheInstance((ReplayCache)replayCache);
        }
    }

    @Test
    public void testEhCacheReplayCache() throws Exception {
        try (EHCacheReplayCache replayCache = new EHCacheReplayCache("xyz", this.tempDir);){
            this.testReplayCacheInstance((ReplayCache)replayCache);
        }
    }

    @Test
    public void testEhCacheReplayCacheNoPath() throws Exception {
        try (EHCacheReplayCache replayCache = new EHCacheReplayCache("xyz");){
            this.testReplayCacheInstance((ReplayCache)replayCache);
        }
    }

    @Test
    public void testEhCacheDifferentCaches() throws Exception {
        EHCacheReplayCache replayCache = new EHCacheReplayCache("abc", this.tempDir.resolve("abc"));
        EHCacheReplayCache replayCache2 = new EHCacheReplayCache("cba", this.tempDir.resolve("cba"));
        String id = UUID.randomUUID().toString();
        replayCache.add(id);
        Assertions.assertTrue((boolean)replayCache.contains(id));
        Assertions.assertFalse((boolean)replayCache2.contains(id));
        replayCache.close();
        replayCache2.close();
    }

    @Test
    public void testOverflowToDisk() throws Exception {
        EHCacheReplayCache replayCache = new EHCacheReplayCache("abc", this.tempDir);
        for (int i = 0; i < 10050; ++i) {
            String id = Integer.toString(i);
            replayCache.add(id);
            Assertions.assertTrue((boolean)replayCache.contains(id));
        }
        replayCache.close();
    }

    @Test
    public void testEhCacheCloseCacheTwice() throws Exception {
        EHCacheReplayCache replayCache = new EHCacheReplayCache("abc", this.tempDir);
        replayCache.close();
        replayCache.close();
    }

    @Test
    public void testEhCacheReplayCacheNoExpirySpecified() throws Exception {
        EHCacheReplayCache replayCache = new EHCacheReplayCache("xyz", this.tempDir);
        String id = UUID.randomUUID().toString();
        replayCache.add(id);
        Assertions.assertTrue((boolean)replayCache.contains(id));
        EHCacheValue ehCacheValue = replayCache.get(id);
        Assertions.assertNotNull((Object)ehCacheValue);
        Assertions.assertNull((Object)ehCacheValue.getExpiry());
        Assertions.assertEquals((Object)id, (Object)ehCacheValue.getIdentifier());
        replayCache.close();
    }

    @Test
    public void testEhCacheReplayCacheNegativeExpiry() throws Exception {
        EHCacheReplayCache replayCache = new EHCacheReplayCache("xyz", this.tempDir);
        String id = UUID.randomUUID().toString();
        replayCache.add(id, Instant.now().minusSeconds(100L));
        Assertions.assertTrue((boolean)replayCache.contains(id));
        EHCacheValue ehCacheValue = replayCache.get(id);
        Assertions.assertNotNull((Object)ehCacheValue);
        Assertions.assertNotNull((Object)ehCacheValue.getExpiry());
        Assertions.assertEquals((Object)id, (Object)ehCacheValue.getIdentifier());
        replayCache.close();
    }

    @Test
    public void testEhCacheReplayCacheHugeExpiry() throws Exception {
        EHCacheReplayCache replayCache = new EHCacheReplayCache("xyz", this.tempDir);
        String id = UUID.randomUUID().toString();
        replayCache.add(id, Instant.now().plus(14L, ChronoUnit.HOURS));
        Assertions.assertTrue((boolean)replayCache.contains(id));
        EHCacheValue ehCacheValue = replayCache.get(id);
        Assertions.assertNotNull((Object)ehCacheValue);
        Assertions.assertNotNull((Object)ehCacheValue.getExpiry());
        Assertions.assertEquals((Object)id, (Object)ehCacheValue.getIdentifier());
        replayCache.close();
    }

    @Test
    public void testNullKey() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> new EHCacheReplayCache(null, this.tempDir));
    }

    @Test
    public void testPersistentAndDiskstoreNull() throws Exception {
        Assertions.assertThrows(NullPointerException.class, () -> new EHCacheReplayCache("abc", null, 10L, 10000L, true));
    }

    @Test
    public void testZeroDiskSize() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new EHCacheReplayCache("abc", this.tempDir, 0L, 10000L, false));
    }

    @Test
    public void testTooLargeDiskSize() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new EHCacheReplayCache("abc", this.tempDir, 10001L, 10000L, false));
    }

    @Test
    public void testTooSmallHeapEntries() throws Exception {
        Assertions.assertThrows(IllegalArgumentException.class, () -> new EHCacheReplayCache("abc", this.tempDir, 10L, 10L, false));
    }

    private void testReplayCacheInstance(ReplayCache replayCache) throws InterruptedException, IOException {
        String id = UUID.randomUUID().toString();
        replayCache.add(id);
        Assertions.assertTrue((boolean)replayCache.contains(id));
        id = UUID.randomUUID().toString();
        replayCache.add(id, Instant.now().plusSeconds(100L));
        Assertions.assertTrue((boolean)replayCache.contains(id));
        id = UUID.randomUUID().toString();
        replayCache.add(id, Instant.now().plusSeconds(1L));
        Thread.sleep(1250L);
        Assertions.assertFalse((boolean)replayCache.contains(id));
    }
}

