/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.cache;

import java.time.Duration;
import java.time.Instant;
import java.time.temporal.ChronoUnit;
import org.apache.wss4j.common.cache.EHCacheExpiry;
import org.apache.wss4j.common.cache.EHCacheValue;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class EHCacheExpiryTest {
    @Test
    public void testNoExpirySpecified() {
        EHCacheExpiry cacheExpiry = new EHCacheExpiry();
        Duration expiryForCreation = cacheExpiry.getExpiryForCreation("xyz", new EHCacheValue("xyz", null));
        Assertions.assertNotNull((Object)expiryForCreation);
        Assertions.assertEquals((long)3600L, (long)expiryForCreation.getSeconds());
    }

    @Test
    public void testExpirySpecified() {
        EHCacheExpiry cacheExpiry = new EHCacheExpiry();
        Duration expiryForCreation = cacheExpiry.getExpiryForCreation("xyz", new EHCacheValue("xyz", Instant.now().plusSeconds(30L)));
        Assertions.assertNotNull((Object)expiryForCreation);
        Assertions.assertTrue((expiryForCreation.getSeconds() <= 30L ? 1 : 0) != 0);
        Assertions.assertTrue((expiryForCreation.getSeconds() > 25L ? 1 : 0) != 0);
    }

    @Test
    public void testExpirySpecified2() {
        EHCacheExpiry cacheExpiry = new EHCacheExpiry();
        Duration expiryForCreation = cacheExpiry.getExpiryForCreation("xyz", new EHCacheValue("xyz", Instant.now().plus(6L, ChronoUnit.HOURS)));
        Assertions.assertNotNull((Object)expiryForCreation);
        Assertions.assertTrue((expiryForCreation.getSeconds() <= 21600L ? 1 : 0) != 0);
        Assertions.assertTrue((expiryForCreation.getSeconds() > 21595L ? 1 : 0) != 0);
    }

    @Test
    public void testNegativeExpirySpecified() {
        EHCacheExpiry cacheExpiry = new EHCacheExpiry();
        Duration expiryForCreation = cacheExpiry.getExpiryForCreation("xyz", new EHCacheValue("xyz", Instant.now().minusSeconds(30L)));
        Assertions.assertNotNull((Object)expiryForCreation);
        Assertions.assertEquals((long)3600L, (long)expiryForCreation.getSeconds());
    }

    @Test
    public void testHugeExpirySpecified() {
        EHCacheExpiry cacheExpiry = new EHCacheExpiry();
        Duration expiryForCreation = cacheExpiry.getExpiryForCreation("xyz", new EHCacheValue("xyz", Instant.now().plus(14L, ChronoUnit.HOURS)));
        Assertions.assertNotNull((Object)expiryForCreation);
        Assertions.assertEquals((long)3600L, (long)expiryForCreation.getSeconds());
    }
}

