/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.attachment;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.Random;
import org.apache.wss4j.common.util.CRLFOutputStream;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class CRLFOutputStreamTest {
    @Test
    public void testBytePerByte() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CRLFOutputStream crlfOutputStream = new CRLFOutputStream((OutputStream)baos);
        crlfOutputStream.write(10);
        crlfOutputStream.write(13);
        crlfOutputStream.write(13);
        crlfOutputStream.write(10);
        crlfOutputStream.write(10);
        crlfOutputStream.write(10);
        crlfOutputStream.write(13);
        crlfOutputStream.write(13);
        crlfOutputStream.write(13);
        crlfOutputStream.write(97);
        crlfOutputStream.write(10);
        crlfOutputStream.write(13);
        crlfOutputStream.write(10);
        crlfOutputStream.write(97);
        crlfOutputStream.write(97);
        crlfOutputStream.write(97);
        crlfOutputStream.close();
        Assertions.assertArrayEquals((byte[])"\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\na\r\n\r\naaa".getBytes(), (byte[])baos.toByteArray());
    }

    @Test
    public void testBytes() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CRLFOutputStream crlfOutputStream = new CRLFOutputStream((OutputStream)baos);
        crlfOutputStream.write("\n\r\r\n\n\n\r\r\ra\n\r\naaa".getBytes());
        crlfOutputStream.close();
        Assertions.assertArrayEquals((byte[])"\r\n\r\n\r\n\r\n\r\n\r\n\r\n\r\na\r\n\r\naaa".getBytes(), (byte[])baos.toByteArray());
    }

    @Test
    public void testBytes1() throws Exception {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CRLFOutputStream crlfOutputStream = new CRLFOutputStream((OutputStream)baos);
        crlfOutputStream.write("aaaaaaaaaa".getBytes());
        crlfOutputStream.close();
        Assertions.assertArrayEquals((byte[])"aaaaaaaaaa".getBytes(), (byte[])baos.toByteArray());
    }

    @Test
    public void testRandom() throws Exception {
        byte[] pool = new byte[]{13, 10, 97};
        Random random = new Random();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        CRLFOutputStream crlfOutputStream = new CRLFOutputStream((OutputStream)baos);
        ByteArrayOutputStream testString = new ByteArrayOutputStream();
        for (int h = 0; h < 10000; ++h) {
            if (random.nextBoolean()) {
                byte b = pool[random.nextInt(pool.length)];
                testString.write(b);
                crlfOutputStream.write((int)b);
                continue;
            }
            int byteCount = random.nextInt(1000);
            byte[] bytes = new byte[byteCount];
            for (int i = 0; i < byteCount; ++i) {
                bytes[i] = pool[random.nextInt(pool.length)];
            }
            testString.write(bytes);
            crlfOutputStream.write(bytes);
        }
        crlfOutputStream.close();
        byte[] res = baos.toByteArray();
        for (int i = 0; i < res.length; ++i) {
            byte re = res[i];
            if (re == 13) {
                if (res[i + 1] == 10) continue;
                throw new Exception("Missing \\n in\n" + this.createEscapedString(res) + "\n input string: " + this.createEscapedString(testString.toByteArray()));
            }
            if (re != 10 || res[i - 1] == 13) continue;
            throw new Exception("Missing \\r in\n" + this.createEscapedString(res) + "\n input string: " + this.createEscapedString(testString.toByteArray()));
        }
    }

    private String createEscapedString(byte[] bytes) {
        StringBuilder stringBuilder = new StringBuilder();
        for (byte aByte : bytes) {
            if (aByte == 13) {
                stringBuilder.append("\\r");
                continue;
            }
            if (aByte == 10) {
                stringBuilder.append("\\n");
                continue;
            }
            stringBuilder.append((char)aByte);
        }
        return stringBuilder.toString();
    }
}

