/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.attachment;

import org.apache.wss4j.common.util.AttachmentUtils;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

public class AttachmentTest {
    @Test
    public void testMatch() {
        Assertions.assertTrue((boolean)"text/xml".matches("(?i)(text/xml).*"));
        Assertions.assertTrue((boolean)"TEXT/XML".matches("(?i)(text/xml).*"));
        Assertions.assertTrue((boolean)"application/xml".matches("(?i)(application/xml).*"));
        Assertions.assertTrue((boolean)"APPLICATION/XML".matches("(?i)(application/xml).*"));
        Assertions.assertTrue((boolean)"text/plain".matches("(?i)(text/).*"));
        Assertions.assertTrue((boolean)"TEXT/PLAIN".matches("(?i)(text/).*"));
    }

    @Test
    public void testMimeHeaderUncomment_1() throws Exception {
        Assertions.assertEquals((Object)"\"a\" \"(b)\" c  test", (Object)AttachmentUtils.uncomment((String)"\"a\" \"(b)\" c ((\"d\")) test"));
    }

    @Test
    public void testMimeHeaderUncomment_2() throws Exception {
        Assertions.assertEquals((Object)"", (Object)AttachmentUtils.uncomment((String)"(\"a\" \"(b)\" c ((\"d\")) test)"));
    }

    @Test
    public void testMimeHeaderUncomment_3() throws Exception {
        Assertions.assertEquals((Object)"\"a\" \"(\"b\")\" test", (Object)AttachmentUtils.uncomment((String)"\"a\" \"(\"b\")\" (c(\"d\"))test"));
    }

    @Test
    public void testMimeHeaderUnfold_1() throws Exception {
        Assertions.assertEquals((Object)"\r\n", (Object)AttachmentUtils.unfold((String)"\r\n"));
    }

    @Test
    public void testMimeHeaderUnfold_2() throws Exception {
        Assertions.assertEquals((Object)"\r\na", (Object)AttachmentUtils.unfold((String)"\r\na"));
    }

    @Test
    public void testMimeHeaderUnfold_3() throws Exception {
        Assertions.assertEquals((Object)"", (Object)AttachmentUtils.unfold((String)"\r\n "));
    }

    @Test
    public void testMimeHeaderUnfold_4() throws Exception {
        Assertions.assertEquals((Object)"", (Object)AttachmentUtils.unfold((String)"\r\n\t"));
    }

    @Test
    public void testMimeHeaderUnfold_5() throws Exception {
        Assertions.assertEquals((Object)"aa", (Object)AttachmentUtils.unfold((String)"a\r\n\ta"));
    }

    @Test
    public void testMimeHeaderUnfold_6() throws Exception {
        Assertions.assertEquals((Object)"aaa", (Object)AttachmentUtils.unfold((String)"a\r\n\taa"));
    }

    @Test
    public void testMimeHeaderUnfold_7() throws Exception {
        Assertions.assertEquals((Object)"aaaa", (Object)AttachmentUtils.unfold((String)"\r\n\taaaa"));
    }

    @Test
    public void testMimeHeaderUnfold_8() throws Exception {
        Assertions.assertEquals((Object)"a", (Object)AttachmentUtils.unfold((String)"\r\n\ta\r\n "));
    }

    @Test
    public void testMimeHeaderUnfold_9() throws Exception {
        Assertions.assertEquals((Object)"\r\n\ra", (Object)AttachmentUtils.unfold((String)"\r\n\ra\r\n "));
    }

    @Test
    public void testMimeHeaderUnfold_10() throws Exception {
        Assertions.assertEquals((Object)"\r\n", (Object)AttachmentUtils.unfold((String)"\r\n \r\n \r\n"));
    }

    @Test
    public void testMimeHeaderUnfoldWS_1() throws Exception {
        Assertions.assertEquals((Object)"a ", (Object)AttachmentUtils.unfoldWhitespace((String)" a "));
    }

    @Test
    public void testMimeHeaderUnfoldWS_2() throws Exception {
        Assertions.assertEquals((Object)"", (Object)AttachmentUtils.unfoldWhitespace((String)""));
    }

    @Test
    public void testMimeHeaderUnfoldWS_3() throws Exception {
        Assertions.assertEquals((Object)"", (Object)AttachmentUtils.unfoldWhitespace((String)" \t \t\t  "));
    }

    @Test
    public void testMimeHeaderUnfoldWS_4() throws Exception {
        Assertions.assertEquals((Object)"a\ta\t  a", (Object)AttachmentUtils.unfoldWhitespace((String)" \t a\ta\t  a"));
    }

    @Test
    public void testMimeHeaderDecodeRfc2184_1() throws Exception {
        Assertions.assertEquals((Object)"message/external-body;access-type=\"URL\";test=\"true\";url=\"ftp://cs.utk.edu/pub/moore/bulk-mailer/bulk-mailer.tar\"", (Object)AttachmentUtils.decodeRfc2184((String)"Message/External-Body; access-type=URL;URL*0=\"ftp://\";URL*1=\"cs.utk.edu/pub/moore/bulk-mailer/bulk-mailer.tar\";test=true"));
    }

    @Test
    public void testMimeHeaderDecodeRfc2184_2() throws Exception {
        Assertions.assertEquals((Object)"message/external-body;access-type=\"URL\";url=\"ftp://cs.utk.edu/pub/moore/bulk-mailer/bulk-mailer.tar\"", (Object)AttachmentUtils.decodeRfc2184((String)"Message/External-Body; access-type=URL;URL*0=\"ftp://\";URL*1=\"cs.utk.edu/pub/moore/bulk-mailer/bulk-mailer.tar\""));
    }

    @Test
    public void testMimeHeaderDecodeRfc2184_3() throws Exception {
        Assertions.assertEquals((Object)"application/x-stuff;title=\"This is ***fun***\"", (Object)AttachmentUtils.decodeRfc2184((String)"application/x-stuff;title*=us-ascii'en-us'This%20is%20%2A%2A%2Afun%2A%2A%2A"));
    }

    @Test
    public void testMimeHeaderDecodeRfc2184_4() throws Exception {
        Assertions.assertEquals((Object)"application/x-stuff;title=\"This is even more ***fun*** isn't it!\"", (Object)AttachmentUtils.decodeRfc2184((String)"application/x-stuff;title*1*=us-ascii'en'This%20is%20even%20more%20;title*2*=%2A%2A%2Afun%2A%2A%2A%20;title*3=\"isn't it!\""));
    }

    @Test
    public void testMimeHeaderUnquoteInnerText_1() throws Exception {
        Assertions.assertEquals((Object)"\"\\\"\\\"\\\\A\"", (Object)AttachmentUtils.unquoteInnerText((String)"\\\"\"\"\\\\\\A\\\""));
    }

    @Test
    public void testMimeHeaderUnquoteInnerText_2() throws Exception {
        Assertions.assertEquals((Object)"\"a\"", (Object)AttachmentUtils.unquoteInnerText((String)"\\\"a\\\""));
    }
}

