/*
 * Decompiled with CFR 0.152.
 */
package org.apache.wss4j.common.kerberos;

import java.security.Principal;
import java.security.PrivilegedAction;
import javax.security.auth.kerberos.KerberosPrincipal;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KerberosServiceAction
implements PrivilegedAction<Principal> {
    private static final Logger LOG = LoggerFactory.getLogger(KerberosServiceAction.class);
    private byte[] ticket;
    private String serviceName;

    public KerberosServiceAction(byte[] ticket, String serviceName) {
        this.ticket = ticket;
        this.serviceName = serviceName;
    }

    @Override
    public Principal run() {
        try {
            GSSManager gssManager = GSSManager.getInstance();
            Oid kerberos5Oid = new Oid("1.2.840.113554.1.2.2");
            GSSName gssService = gssManager.createName(this.serviceName, GSSName.NT_HOSTBASED_SERVICE);
            GSSCredential credentials = gssManager.createCredential(gssService, 0, kerberos5Oid, 2);
            GSSContext secContext = gssManager.createContext(credentials);
            secContext.acceptSecContext(this.ticket, 0, this.ticket.length);
            GSSName clientName = secContext.getSrcName();
            secContext.dispose();
            return new KerberosPrincipal(clientName.toString());
        }
        catch (GSSException e) {
            if (LOG.isDebugEnabled()) {
                LOG.debug("Error in validating a Kerberos token", (Throwable)e);
            }
            return null;
        }
    }
}

