/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.commons.schema.walker;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.apache.ws.commons.schema.XmlSchema;
import org.apache.ws.commons.schema.XmlSchemaAnyAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttribute;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroup;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroupMember;
import org.apache.ws.commons.schema.XmlSchemaAttributeGroupRef;
import org.apache.ws.commons.schema.XmlSchemaAttributeOrGroupRef;
import org.apache.ws.commons.schema.XmlSchemaComplexContent;
import org.apache.ws.commons.schema.XmlSchemaComplexContentExtension;
import org.apache.ws.commons.schema.XmlSchemaComplexContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaComplexType;
import org.apache.ws.commons.schema.XmlSchemaContent;
import org.apache.ws.commons.schema.XmlSchemaFacet;
import org.apache.ws.commons.schema.XmlSchemaParticle;
import org.apache.ws.commons.schema.XmlSchemaSequence;
import org.apache.ws.commons.schema.XmlSchemaSequenceMember;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentExtension;
import org.apache.ws.commons.schema.XmlSchemaSimpleContentRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleType;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeContent;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeList;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeRestriction;
import org.apache.ws.commons.schema.XmlSchemaSimpleTypeUnion;
import org.apache.ws.commons.schema.XmlSchemaType;
import org.apache.ws.commons.schema.XmlSchemaUse;
import org.apache.ws.commons.schema.utils.XmlSchemaNamed;
import org.apache.ws.commons.schema.walker.SchemasByNamespace;
import org.apache.ws.commons.schema.walker.XmlSchemaAttrInfo;
import org.apache.ws.commons.schema.walker.XmlSchemaBaseSimpleType;
import org.apache.ws.commons.schema.walker.XmlSchemaRestriction;
import org.apache.ws.commons.schema.walker.XmlSchemaTypeInfo;

final class XmlSchemaScope {
    private SchemasByNamespace schemasByNamespace;
    private Map<QName, XmlSchemaScope> scopeCache;
    private XmlSchemaTypeInfo typeInfo = null;
    private HashMap<QName, XmlSchemaAttrInfo> attributes = null;
    private XmlSchemaParticle child = null;
    private XmlSchemaAnyAttribute anyAttr = null;
    private Set<QName> userRecognizedTypes;

    private XmlSchemaScope() {
    }

    private XmlSchemaScope(XmlSchemaScope child, XmlSchemaType type) {
        this();
        this.schemasByNamespace = child.schemasByNamespace;
        this.scopeCache = child.scopeCache;
        this.userRecognizedTypes = child.userRecognizedTypes;
        this.walk(type);
    }

    XmlSchemaScope(XmlSchemaType type, SchemasByNamespace xmlSchemasByNamespace, Map<QName, XmlSchemaScope> scopeCache, Set<QName> userRecognizedTypes) {
        this();
        this.schemasByNamespace = xmlSchemasByNamespace;
        this.scopeCache = scopeCache;
        this.userRecognizedTypes = userRecognizedTypes;
        this.walk(type);
    }

    XmlSchemaTypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    Collection<XmlSchemaAttrInfo> getAttributesInScope() {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.values();
    }

    XmlSchemaParticle getParticle() {
        return this.child;
    }

    XmlSchemaAnyAttribute getAnyAttribute() {
        return this.anyAttr;
    }

    private void walk(XmlSchemaType type) {
        if (type instanceof XmlSchemaSimpleType) {
            this.walk((XmlSchemaSimpleType)type);
        } else if (type instanceof XmlSchemaComplexType) {
            this.walk((XmlSchemaComplexType)type);
        } else {
            throw new IllegalArgumentException("Unrecognized XmlSchemaType of type " + type.getClass().getName());
        }
    }

    private void walk(XmlSchemaSimpleType simpleType) {
        XmlSchemaSimpleTypeContent content = simpleType.getContent();
        if (content == null) {
            this.typeInfo = new XmlSchemaTypeInfo(XmlSchemaBaseSimpleType.ANYTYPE);
        } else if (content instanceof XmlSchemaSimpleTypeList) {
            XmlSchemaSimpleTypeList list = (XmlSchemaSimpleTypeList)content;
            XmlSchemaSimpleType listType = list.getItemType();
            if (listType == null) {
                listType = (XmlSchemaSimpleType)this.schemasByNamespace.getTypeByName(list.getItemTypeName());
            }
            if (listType == null) {
                throw new IllegalArgumentException("Unrecognized schema type for list " + XmlSchemaScope.getName((XmlSchemaNamed)simpleType, "{Anonymous List Type}"));
            }
            XmlSchemaScope parentScope = this.getScope((XmlSchemaType)listType);
            switch (parentScope.getTypeInfo().getType()) {
                case UNION: 
                case ATOMIC: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Attempted to create a list from a " + (Object)((Object)parentScope.getTypeInfo().getType()) + " type.");
                }
            }
            this.typeInfo = new XmlSchemaTypeInfo(parentScope.getTypeInfo());
        } else if (content instanceof XmlSchemaSimpleTypeUnion) {
            XmlSchemaSimpleTypeUnion union = (XmlSchemaSimpleTypeUnion)content;
            QName[] namedBaseTypes = union.getMemberTypesQNames();
            ArrayList<XmlSchemaSimpleType> baseTypes = union.getBaseTypes();
            if (namedBaseTypes != null) {
                if (baseTypes == null) {
                    baseTypes = new ArrayList<XmlSchemaSimpleType>(namedBaseTypes.length);
                }
                for (QName namedBaseType : namedBaseTypes) {
                    XmlSchemaSimpleType baseType = (XmlSchemaSimpleType)this.schemasByNamespace.getTypeByName(namedBaseType);
                    if (baseType == null) continue;
                    baseTypes.add(baseType);
                }
            }
            if (baseTypes == null || baseTypes.isEmpty()) {
                throw new IllegalArgumentException("Unrecognized base types for union " + XmlSchemaScope.getName((XmlSchemaNamed)simpleType, "{Anonymous Union Type}"));
            }
            ArrayList<XmlSchemaTypeInfo> childTypes = new ArrayList<XmlSchemaTypeInfo>(baseTypes.size());
            for (XmlSchemaSimpleType baseType : baseTypes) {
                XmlSchemaScope parentScope = this.getScope((XmlSchemaType)baseType);
                if (parentScope.getTypeInfo().getType().equals((Object)XmlSchemaTypeInfo.Type.UNION)) {
                    childTypes.addAll(parentScope.getTypeInfo().getChildTypes());
                    continue;
                }
                childTypes.add(parentScope.getTypeInfo());
            }
            this.typeInfo = new XmlSchemaTypeInfo(childTypes);
        } else if (content instanceof XmlSchemaSimpleTypeRestriction) {
            XmlSchemaSimpleTypeRestriction restr = (XmlSchemaSimpleTypeRestriction)content;
            List facets = restr.getFacets();
            XmlSchemaTypeInfo parentTypeInfo = null;
            if (XmlSchemaBaseSimpleType.isBaseSimpleType(simpleType.getQName())) {
                this.typeInfo = new XmlSchemaTypeInfo(XmlSchemaBaseSimpleType.getBaseSimpleTypeFor(simpleType.getQName()), XmlSchemaScope.mergeFacets(null, facets));
            } else {
                XmlSchemaSimpleType baseType = restr.getBaseType();
                if (baseType == null) {
                    baseType = (XmlSchemaSimpleType)this.schemasByNamespace.getTypeByName(restr.getBaseTypeName());
                }
                if (baseType != null) {
                    XmlSchemaScope parentScope = this.getScope((XmlSchemaType)baseType);
                    parentTypeInfo = parentScope.getTypeInfo();
                    HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> mergedFacets = XmlSchemaScope.mergeFacets(parentTypeInfo.getFacets(), facets);
                    this.typeInfo = XmlSchemaScope.restrictTypeInfo(parentTypeInfo, mergedFacets);
                } else {
                    throw new IllegalArgumentException("Unrecognized base type for " + XmlSchemaScope.getName((XmlSchemaNamed)simpleType, "{Anonymous Simple Type}"));
                }
            }
            this.typeInfo.setUserRecognizedType(this.getUserRecognizedType(simpleType.getQName(), parentTypeInfo));
        } else {
            throw new IllegalArgumentException("XmlSchemaSimpleType " + XmlSchemaScope.getName((XmlSchemaNamed)simpleType, "{Anonymous Simple Type}") + "contains unrecognized XmlSchemaSimpleTypeContent " + content.getClass().getName());
        }
    }

    private void walk(XmlSchemaComplexType complexType) {
        XmlSchemaContent complexContent;
        XmlSchemaContent xmlSchemaContent = complexContent = complexType.getContentModel() != null ? complexType.getContentModel().getContent() : null;
        if (complexContent != null) {
            boolean isMixed = false;
            if (complexType.isMixed()) {
                isMixed = complexType.isMixed();
            } else if (complexType.getContentModel() instanceof XmlSchemaComplexContent) {
                isMixed = ((XmlSchemaComplexContent)complexType.getContentModel()).isMixed();
            }
            this.walk(isMixed, complexContent);
            QName userRecognizedType = this.getUserRecognizedType(complexType.getQName(), null);
            if (userRecognizedType != null) {
                this.typeInfo.setUserRecognizedType(userRecognizedType);
            }
        } else {
            this.child = complexType.getParticle();
            this.attributes = this.createAttributeMap(complexType.getAttributes());
            this.anyAttr = complexType.getAnyAttribute();
            this.typeInfo = new XmlSchemaTypeInfo(complexType.isMixed());
        }
    }

    private void walk(boolean isMixed, XmlSchemaContent content) {
        if (content instanceof XmlSchemaComplexContentExtension) {
            XmlSchemaTypeInfo parentTypeInfo;
            XmlSchemaComplexContentExtension ext = (XmlSchemaComplexContentExtension)content;
            XmlSchemaType baseType = this.schemasByNamespace.getTypeByName(ext.getBaseTypeName());
            XmlSchemaParticle baseParticle = null;
            XmlSchemaAnyAttribute baseAnyAttr = null;
            XmlSchemaScope parentScope = null;
            if (baseType != null) {
                parentScope = this.getScope(baseType);
                this.attributes = this.createAttributeMap(ext.getAttributes());
                if (this.attributes == null) {
                    this.attributes = parentScope.attributes;
                } else if (parentScope.attributes != null) {
                    this.attributes.putAll(parentScope.attributes);
                }
                baseParticle = parentScope.getParticle();
                baseAnyAttr = parentScope.anyAttr;
            }
            if (ext.getParticle() == null) {
                this.child = baseParticle;
            } else if (baseParticle == null) {
                this.child = ext.getParticle();
            } else {
                XmlSchemaSequence seq = new XmlSchemaSequence();
                seq.getItems().add((XmlSchemaSequenceMember)baseParticle);
                seq.getItems().add((XmlSchemaSequenceMember)ext.getParticle());
                this.child = seq;
            }
            if (baseAnyAttr == null) {
                this.anyAttr = ext.getAnyAttribute();
            } else if (ext.getAnyAttribute() == null) {
                this.anyAttr = baseAnyAttr;
            } else {
                String[] baseNamespaces = baseAnyAttr.getNamespace().split(" ");
                String[] childNamespaces = ext.getAnyAttribute().getNamespace().split(" ");
                HashSet<String> namespaces = new HashSet<String>();
                for (String baseNs : baseNamespaces) {
                    if (baseNs.length() <= 0) continue;
                    namespaces.add(baseNs);
                }
                for (String childNs : childNamespaces) {
                    if (childNs.length() <= 0) continue;
                    namespaces.add(childNs);
                }
                StringBuilder nsAsString = new StringBuilder();
                for (String namespace : namespaces) {
                    nsAsString.append(namespace).append(' ');
                }
                this.anyAttr = new XmlSchemaAnyAttribute();
                this.anyAttr.setNamespace(nsAsString.toString());
                this.anyAttr.setProcessContent(ext.getAnyAttribute().getProcessContent());
                this.anyAttr.setAnnotation(ext.getAnyAttribute().getAnnotation());
                this.anyAttr.setId(ext.getAnyAttribute().getId());
                this.anyAttr.setLineNumber(ext.getAnyAttribute().getLineNumber());
                this.anyAttr.setLinePosition(ext.getAnyAttribute().getLinePosition());
                this.anyAttr.setMetaInfoMap(ext.getAnyAttribute().getMetaInfoMap());
                this.anyAttr.setSourceURI(ext.getAnyAttribute().getSourceURI());
                this.anyAttr.setUnhandledAttributes(ext.getUnhandledAttributes());
            }
            XmlSchemaTypeInfo xmlSchemaTypeInfo = parentTypeInfo = parentScope == null ? null : parentScope.getTypeInfo();
            this.typeInfo = parentTypeInfo != null && !parentTypeInfo.getType().equals((Object)XmlSchemaTypeInfo.Type.COMPLEX) ? parentScope.getTypeInfo() : new XmlSchemaTypeInfo(isMixed);
        } else if (content instanceof XmlSchemaComplexContentRestriction) {
            XmlSchemaTypeInfo parentTypeInfo;
            XmlSchemaComplexContentRestriction rstr = (XmlSchemaComplexContentRestriction)content;
            XmlSchemaType baseType = this.schemasByNamespace.getTypeByName(rstr.getBaseTypeName());
            XmlSchemaScope parentScope = null;
            if (baseType != null) {
                parentScope = this.getScope(baseType);
                this.attributes = this.mergeAttributes(parentScope.attributes, this.createAttributeMap(rstr.getAttributes()));
                this.child = parentScope.getParticle();
            }
            if (rstr.getParticle() != null) {
                this.child = rstr.getParticle();
            }
            this.anyAttr = rstr.getAnyAttribute();
            XmlSchemaTypeInfo xmlSchemaTypeInfo = parentTypeInfo = parentScope == null ? null : parentScope.getTypeInfo();
            this.typeInfo = parentTypeInfo != null && !parentTypeInfo.getType().equals((Object)XmlSchemaTypeInfo.Type.COMPLEX) ? parentTypeInfo : new XmlSchemaTypeInfo(isMixed);
        } else if (content instanceof XmlSchemaSimpleContentExtension) {
            XmlSchemaSimpleContentExtension ext = (XmlSchemaSimpleContentExtension)content;
            this.attributes = this.createAttributeMap(ext.getAttributes());
            XmlSchemaType baseType = this.schemasByNamespace.getTypeByName(ext.getBaseTypeName());
            if (baseType != null) {
                XmlSchemaScope parentScope = this.getScope(baseType);
                this.typeInfo = parentScope.getTypeInfo();
                if (this.attributes == null) {
                    this.attributes = parentScope.attributes;
                } else if (parentScope.attributes != null) {
                    this.attributes.putAll(parentScope.attributes);
                }
            }
            this.anyAttr = ext.getAnyAttribute();
        } else if (content instanceof XmlSchemaSimpleContentRestriction) {
            XmlSchemaSimpleContentRestriction rstr = (XmlSchemaSimpleContentRestriction)content;
            this.attributes = this.createAttributeMap(rstr.getAttributes());
            Object baseType = null;
            baseType = rstr.getBaseType() != null ? rstr.getBaseType() : this.schemasByNamespace.getTypeByName(rstr.getBaseTypeName());
            if (baseType != null) {
                XmlSchemaScope parentScope = this.getScope((XmlSchemaType)baseType);
                this.typeInfo = XmlSchemaScope.restrictTypeInfo(parentScope.getTypeInfo(), XmlSchemaScope.mergeFacets(parentScope.getTypeInfo().getFacets(), rstr.getFacets()));
                this.attributes = this.mergeAttributes(parentScope.attributes, this.attributes);
            }
            this.anyAttr = rstr.getAnyAttribute();
        }
    }

    private ArrayList<XmlSchemaAttrInfo> getAttributesOf(XmlSchemaAttributeGroupRef groupRef) {
        XmlSchemaAttributeGroup attrGroup = (XmlSchemaAttributeGroup)groupRef.getRef().getTarget();
        if (attrGroup == null) {
            attrGroup = this.schemasByNamespace.getAttributeGroupByName(groupRef.getTargetQName());
        }
        return this.getAttributesOf(attrGroup);
    }

    private ArrayList<XmlSchemaAttrInfo> getAttributesOf(XmlSchemaAttributeGroup attrGroup) {
        ArrayList<XmlSchemaAttrInfo> attrs = new ArrayList<XmlSchemaAttrInfo>(attrGroup.getAttributes().size());
        for (XmlSchemaAttributeGroupMember member : attrGroup.getAttributes()) {
            if (member instanceof XmlSchemaAttribute) {
                attrs.add(this.getAttribute((XmlSchemaAttribute)member, false));
                continue;
            }
            if (member instanceof XmlSchemaAttributeGroup) {
                attrs.addAll(this.getAttributesOf((XmlSchemaAttributeGroup)member));
                continue;
            }
            if (member instanceof XmlSchemaAttributeGroupRef) {
                attrs.addAll(this.getAttributesOf((XmlSchemaAttributeGroupRef)member));
                continue;
            }
            throw new IllegalArgumentException("Attribute Group " + XmlSchemaScope.getName((XmlSchemaNamed)attrGroup, "{Anonymous Attribute Group}") + " contains unrecognized attribute group memeber type " + member.getClass().getName());
        }
        return attrs;
    }

    private XmlSchemaAttrInfo getAttribute(XmlSchemaAttribute attribute, boolean forceCopy) {
        XmlSchema schema;
        XmlSchemaUse attrUsage;
        String id;
        String defaultValue;
        String fixedValue;
        QName typeQName;
        if (!attribute.isRef() && attribute.getSchemaType() != null && !forceCopy) {
            if (attribute.getUse().equals((Object)XmlSchemaUse.NONE)) {
                attribute.setUse(XmlSchemaUse.OPTIONAL);
            }
            return new XmlSchemaAttrInfo(attribute);
        }
        XmlSchemaAttribute globalAttr = null;
        QName attrQName = null;
        attrQName = attribute.isRef() ? attribute.getRefBase().getTargetQName() : attribute.getQName();
        globalAttr = !attribute.isRef() && (forceCopy || attribute.getSchemaType() == null) ? attribute : (attribute.getRef().getTarget() != null ? (XmlSchemaAttribute)attribute.getRef().getTarget() : this.schemasByNamespace.getAttributeByName(attrQName));
        XmlSchemaSimpleType schemaType = globalAttr.getSchemaType();
        if (schemaType == null && (typeQName = globalAttr.getSchemaTypeName()) != null) {
            schemaType = (XmlSchemaSimpleType)this.schemasByNamespace.getTypeByName(typeQName);
        }
        if ((fixedValue = attribute.getFixedValue()) != null && attribute != globalAttr) {
            fixedValue = globalAttr.getFixedValue();
        }
        if ((defaultValue = attribute.getDefaultValue()) == null && fixedValue == null && attribute != globalAttr) {
            defaultValue = globalAttr.getDefaultValue();
        }
        if ((id = attribute.getId()) == null && attribute != globalAttr) {
            id = globalAttr.getId();
        }
        if ((attrUsage = attribute.getUse()).equals((Object)XmlSchemaUse.NONE)) {
            attrUsage = XmlSchemaUse.OPTIONAL;
        }
        if ((schema = this.schemasByNamespace.getSchemaDefiningAttribute(attrQName)) == null) {
            schema = attribute.getParent();
        }
        XmlSchemaAttribute copy = new XmlSchemaAttribute(schema, false);
        copy.setName(globalAttr.getName());
        copy.setAnnotation(globalAttr.getAnnotation());
        copy.setDefaultValue(defaultValue);
        copy.setFixedValue(fixedValue);
        copy.setForm(globalAttr.getForm());
        copy.setId(id);
        copy.setLineNumber(attribute.getLineNumber());
        copy.setLinePosition(attribute.getLinePosition());
        copy.setMetaInfoMap(globalAttr.getMetaInfoMap());
        copy.setSchemaType(schemaType);
        copy.setSchemaTypeName(globalAttr.getSchemaTypeName());
        copy.setSourceURI(globalAttr.getSourceURI());
        copy.setUnhandledAttributes(globalAttr.getUnhandledAttributes());
        copy.setUse(attrUsage);
        return new XmlSchemaAttrInfo(copy, globalAttr.isTopLevel());
    }

    private HashMap<QName, XmlSchemaAttrInfo> createAttributeMap(Collection<? extends XmlSchemaAttributeOrGroupRef> attrs) {
        if (attrs == null || attrs.isEmpty()) {
            return null;
        }
        HashMap<QName, XmlSchemaAttrInfo> attributes = new HashMap<QName, XmlSchemaAttrInfo>();
        for (XmlSchemaAttributeOrGroupRef xmlSchemaAttributeOrGroupRef : attrs) {
            if (xmlSchemaAttributeOrGroupRef instanceof XmlSchemaAttribute) {
                XmlSchemaAttrInfo attribute = this.getAttribute((XmlSchemaAttribute)xmlSchemaAttributeOrGroupRef, false);
                attributes.put(attribute.getAttribute().getQName(), attribute);
                continue;
            }
            if (!(xmlSchemaAttributeOrGroupRef instanceof XmlSchemaAttributeGroupRef)) continue;
            ArrayList<XmlSchemaAttrInfo> attrList = this.getAttributesOf((XmlSchemaAttributeGroupRef)xmlSchemaAttributeOrGroupRef);
            for (XmlSchemaAttrInfo attribute : attrList) {
                attributes.put(attribute.getAttribute().getQName(), attribute);
            }
        }
        return attributes;
    }

    private HashMap<QName, XmlSchemaAttrInfo> mergeAttributes(HashMap<QName, XmlSchemaAttrInfo> parentAttrs, HashMap<QName, XmlSchemaAttrInfo> childAttrs) {
        if (parentAttrs == null || parentAttrs.isEmpty()) {
            return childAttrs;
        }
        if (childAttrs == null || childAttrs.isEmpty()) {
            return parentAttrs;
        }
        HashMap<QName, XmlSchemaAttrInfo> newAttrs = new HashMap<QName, XmlSchemaAttrInfo>(parentAttrs);
        for (Map.Entry<QName, XmlSchemaAttrInfo> parentAttrEntry : parentAttrs.entrySet()) {
            XmlSchemaAttrInfo parentAttr = parentAttrEntry.getValue();
            XmlSchemaAttrInfo childAttr = childAttrs.get(parentAttrEntry.getKey());
            if (childAttr == null) continue;
            XmlSchemaAttrInfo newAttr = this.getAttribute(parentAttr.getAttribute(), true);
            if (childAttr.getAttribute().getSchemaType() != null) {
                newAttr.getAttribute().setSchemaType(childAttr.getAttribute().getSchemaType());
            }
            if (childAttr.getAttribute().getUse() != XmlSchemaUse.NONE) {
                newAttr.getAttribute().setUse(childAttr.getAttribute().getUse());
            }
            if (childAttr.getAttribute().getDefaultValue() != null) {
                newAttr.getAttribute().setDefaultValue(childAttr.getAttribute().getDefaultValue());
                newAttr.getAttribute().setFixedValue(null);
            } else if (childAttr.getAttribute().getFixedValue() != null) {
                newAttr.getAttribute().setFixedValue(childAttr.getAttribute().getFixedValue());
                newAttr.getAttribute().setDefaultValue(null);
            }
            newAttrs.put(newAttr.getAttribute().getQName(), newAttr);
        }
        return newAttrs;
    }

    private XmlSchemaScope getScope(XmlSchemaType type) {
        if (type.getQName() != null && this.scopeCache.containsKey(type.getQName())) {
            return this.scopeCache.get(type.getQName());
        }
        XmlSchemaScope scope = new XmlSchemaScope(this, type);
        if (type.getQName() != null) {
            this.scopeCache.put(type.getQName(), scope);
        }
        return scope;
    }

    private QName getUserRecognizedType(QName simpleType, XmlSchemaTypeInfo parent) {
        if (this.userRecognizedTypes == null) {
            return null;
        }
        if (simpleType == null) {
            return parent == null ? null : parent.getUserRecognizedType();
        }
        if (this.userRecognizedTypes.contains(simpleType)) {
            return simpleType;
        }
        if (XmlSchemaBaseSimpleType.isBaseSimpleType(simpleType)) {
            QName anyType;
            QName anySimpleType;
            boolean checkAnyType = true;
            boolean checkAnySimpleType = true;
            switch (XmlSchemaBaseSimpleType.getBaseSimpleTypeFor(simpleType)) {
                case ANYTYPE: {
                    checkAnyType = false;
                    break;
                }
                case ANYSIMPLETYPE: {
                    checkAnySimpleType = false;
                    break;
                }
            }
            if (checkAnySimpleType && this.userRecognizedTypes.contains(anySimpleType = XmlSchemaBaseSimpleType.ANYSIMPLETYPE.getQName())) {
                return anySimpleType;
            }
            if (checkAnyType && this.userRecognizedTypes.contains(anyType = XmlSchemaBaseSimpleType.ANYTYPE.getQName())) {
                return anyType;
            }
        }
        return parent == null ? null : parent.getUserRecognizedType();
    }

    private static String getName(XmlSchemaNamed name, String defaultName) {
        if (name.isAnonymous()) {
            return defaultName;
        }
        return name.getName();
    }

    private static HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> mergeFacets(HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> parentFacets, List<XmlSchemaFacet> child) {
        if (child == null || child.isEmpty()) {
            return parentFacets;
        }
        HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> childFacets = new HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>>(child.size());
        for (XmlSchemaFacet facet : child) {
            XmlSchemaRestriction rstr = new XmlSchemaRestriction(facet);
            List<XmlSchemaRestriction> rstrList = childFacets.get((Object)rstr.getType());
            if (rstrList == null) {
                rstrList = rstr.getType() == XmlSchemaRestriction.Type.ENUMERATION ? new ArrayList<XmlSchemaRestriction>(5) : new ArrayList<XmlSchemaRestriction>(1);
                childFacets.put(rstr.getType(), rstrList);
            }
            rstrList.add(rstr);
        }
        if (parentFacets == null) {
            return childFacets;
        }
        HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> mergedFacets = new HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>>(parentFacets);
        for (Map.Entry<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> rstrEntry : childFacets.entrySet()) {
            mergedFacets.put(rstrEntry.getKey(), rstrEntry.getValue());
        }
        return mergedFacets;
    }

    private static XmlSchemaTypeInfo restrictTypeInfo(XmlSchemaTypeInfo parentTypeInfo, HashMap<XmlSchemaRestriction.Type, List<XmlSchemaRestriction>> facets) {
        XmlSchemaTypeInfo typeInfo = null;
        switch (parentTypeInfo.getType()) {
            case LIST: {
                typeInfo = new XmlSchemaTypeInfo(parentTypeInfo.getChildTypes().get(0), facets);
                break;
            }
            case UNION: {
                typeInfo = new XmlSchemaTypeInfo(parentTypeInfo.getChildTypes(), facets);
                break;
            }
            case ATOMIC: {
                typeInfo = new XmlSchemaTypeInfo(parentTypeInfo.getBaseType(), facets);
                break;
            }
            default: {
                throw new IllegalStateException("Cannot restrict on a " + (Object)((Object)parentTypeInfo.getType()) + " type.");
            }
        }
        if (parentTypeInfo.getUserRecognizedType() != null) {
            typeInfo.setUserRecognizedType(parentTypeInfo.getUserRecognizedType());
        }
        return typeInfo;
    }
}

