/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ws.security;

import java.io.Serializable;
import java.security.Principal;
import org.apache.ws.security.saml.ext.AssertionWrapper;
import org.opensaml.common.SAMLVersion;
import org.opensaml.saml1.core.AttributeStatement;
import org.opensaml.saml1.core.AuthenticationStatement;
import org.opensaml.saml1.core.AuthorizationDecisionStatement;
import org.opensaml.saml1.core.Statement;
import org.opensaml.saml1.core.Subject;

public class SAMLTokenPrincipal
implements Principal,
Serializable {
    private static final long serialVersionUID = 1L;
    private String name;
    private AssertionWrapper assertion;

    public SAMLTokenPrincipal(AssertionWrapper assertion) {
        this.assertion = assertion;
        if (assertion.getSamlVersion() == SAMLVersion.VERSION_20) {
            org.opensaml.saml2.core.Subject subject = assertion.getSaml2().getSubject();
            if (subject != null && subject.getNameID() != null) {
                this.name = subject.getNameID().getValue();
            }
        } else {
            Subject samlSubject = null;
            for (Statement stmt : assertion.getSaml1().getStatements()) {
                if (stmt instanceof AttributeStatement) {
                    AttributeStatement attrStmt = (AttributeStatement)stmt;
                    samlSubject = attrStmt.getSubject();
                } else if (stmt instanceof AuthenticationStatement) {
                    AuthenticationStatement authStmt = (AuthenticationStatement)stmt;
                    samlSubject = authStmt.getSubject();
                } else {
                    AuthorizationDecisionStatement authzStmt = (AuthorizationDecisionStatement)stmt;
                    samlSubject = authzStmt.getSubject();
                }
                if (samlSubject == null) continue;
                break;
            }
            if (samlSubject != null && samlSubject.getNameIdentifier() != null) {
                this.name = samlSubject.getNameIdentifier().getNameIdentifier();
            }
        }
    }

    public AssertionWrapper getToken() {
        return this.assertion;
    }

    public String getName() {
        return this.name;
    }

    public String getId() {
        if (this.assertion != null) {
            return this.assertion.getId();
        }
        return null;
    }
}

